/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.LoaderTransfer;
import org.openide.util.HelpCtx;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

abstract class DataTransferSupport {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.DataTransferSupport");
    static /* synthetic */ Class class$org$openide$loaders$DataTransferSupport$SerializePaste;
    static /* synthetic */ Class class$org$openide$loaders$DataTransferSupport$InstantiatePaste;

    DataTransferSupport() {
    }

    protected abstract PasteTypeExt[] definePasteTypes(int var1);

    protected abstract int[] defineOperations();

    protected void handleCreatePasteTypes(Transferable transferable, List list) {
    }

    public final void createPasteTypes(Transferable transferable, List list) {
        int[] nArray = this.defineOperations();
        for (int i = 0; i < nArray.length; ++i) {
            DataObject[] dataObjectArray = LoaderTransfer.getDataObjects(transferable, nArray[i]);
            if (dataObjectArray == null || dataObjectArray.length == 0) continue;
            PasteTypeExt[] pasteTypeExtArray = this.definePasteTypes(nArray[i]);
            for (int j = 0; j < pasteTypeExtArray.length; ++j) {
                pasteTypeExtArray[j].setDataObjects(dataObjectArray);
                if (!pasteTypeExtArray[j].canPaste()) continue;
                list.add(pasteTypeExtArray[j]);
            }
        }
        this.handleCreatePasteTypes(transferable, list);
    }

    static class InstantiatePaste
    extends PasteType {
        private InstanceCookie cookie;
        private DataFolder target;

        public InstantiatePaste(DataFolder dataFolder, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.target = dataFolder;
        }

        public String getName() {
            return DataObject.getString("PT_instance");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$loaders$DataTransferSupport$InstantiatePaste == null ? (class$org$openide$loaders$DataTransferSupport$InstantiatePaste = DataTransferSupport.class$("org.openide.loaders.DataTransferSupport$InstantiatePaste")) : class$org$openide$loaders$DataTransferSupport$InstantiatePaste);
        }

        public final Transferable paste() throws IOException {
            try {
                Class clazz = this.cookie.instanceClass();
                InstanceDataObject.create(this.getTargetFolder(), null, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
            return null;
        }

        protected DataFolder getTargetFolder() throws IOException {
            return this.target;
        }
    }

    static class SerializePaste
    extends PasteType {
        private InstanceCookie cookie;
        private DataFolder target;

        public SerializePaste(DataFolder dataFolder, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.target = dataFolder;
        }

        public String getName() {
            return DataObject.getString("PT_serialize");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$loaders$DataTransferSupport$SerializePaste == null ? (class$org$openide$loaders$DataTransferSupport$SerializePaste = DataTransferSupport.class$("org.openide.loaders.DataTransferSupport$SerializePaste")) : class$org$openide$loaders$DataTransferSupport$SerializePaste);
        }

        public final Transferable paste() throws IOException {
            DataFolder dataFolder = this.getTargetFolder();
            String string = this.cookie.instanceName();
            int n = string.lastIndexOf(46) + 1;
            if (n != 0 && n != string.length()) {
                string = string.substring(n);
            }
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)string, (String)"ser");
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(DataObject.getString("SerializeBean_Text"), DataObject.getString("SerializeBean_Title"));
            inputLine.setInputText(string);
            if (NotifyDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine)) {
                DataObjectPool.getPOOL().runAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(this, dataFolder, inputLine){
                    private final /* synthetic */ DataFolder val$trg;
                    private final /* synthetic */ NotifyDescriptor.InputLine val$nd;
                    private final /* synthetic */ SerializePaste this$0;
                    {
                        this.this$0 = serializePaste;
                        this.val$trg = dataFolder;
                        this.val$nd = inputLine;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() throws IOException {
                        FileLock fileLock;
                        block6: {
                            FileObject fileObject = this.val$trg.getPrimaryFile().createData(this.val$nd.getInputText(), "ser");
                            fileLock = fileObject.lock();
                            ObjectOutputStream objectOutputStream = null;
                            try {
                                try {
                                    objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileObject.getOutputStream(fileLock)));
                                    objectOutputStream.writeObject(SerializePaste.access$100(this.this$0).instanceCreate());
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new IOException(classNotFoundException.getMessage());
                                }
                                Object var6_4 = null;
                                if (objectOutputStream == null) break block6;
                            }
                            catch (Throwable throwable) {
                                Object var6_5 = null;
                                if (objectOutputStream != null) {
                                    objectOutputStream.close();
                                }
                                fileLock.releaseLock();
                                throw throwable;
                            }
                            objectOutputStream.close();
                        }
                        fileLock.releaseLock();
                    }
                });
            }
            return null;
        }

        protected DataFolder getTargetFolder() throws IOException {
            return this.target;
        }

        static /* synthetic */ InstanceCookie access$100(SerializePaste serializePaste) {
            return serializePaste.cookie;
        }
    }

    static abstract class PasteTypeExt
    extends PasteType {
        private DataObject[] objs;

        protected abstract boolean handleCanPaste(DataObject var1);

        protected abstract void handlePaste(DataObject var1) throws IOException;

        protected boolean cleanClipboard() {
            return false;
        }

        public final boolean canPaste() {
            for (int i = 0; i < this.objs.length; ++i) {
                if (this.handleCanPaste(this.objs[i])) continue;
                return false;
            }
            return true;
        }

        public final Transferable paste() throws IOException {
            this.doPaste();
            return this.cleanClipboard() ? ExTransferable.EMPTY : null;
        }

        private void doPaste() throws IOException {
            if (err.isLoggable(1)) {
                err.notify(1, new Throwable("Issue #58666: Called " + (Object)((Object)this) + " doPaste() on objects " + Arrays.asList(this.objs)));
            }
            for (int i = 0; i < this.objs.length; ++i) {
                this.handlePaste(this.objs[i]);
            }
        }

        public final void setDataObjects(DataObject[] dataObjectArray) {
            this.objs = dataObjectArray;
        }
    }
}

