/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultES;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class DefaultDataObject
extends MultiDataObject
implements OpenCookie {
    static final long serialVersionUID = -4936309935667095746L;

    DefaultDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    protected Node createNodeDelegate() {
        DataNode dataNode = new DataNode(this, Children.LEAF);
        dataNode.setShortDescription(NbBundle.getMessage((Class)DefaultDataObject.class, (String)"HINT_DefaultDataObject"));
        return dataNode;
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleRename(String string) throws IOException {
        FileLock fileLock = this.getPrimaryFile().lock();
        int n = string.lastIndexOf(46);
        try {
            if (n < 0) {
                this.getPrimaryFile().rename(fileLock, string, null);
            } else if (n == 0) {
                this.getPrimaryFile().rename(fileLock, string, this.getPrimaryFile().getExt());
            } else if (!string.equals(this.getPrimaryFile().getNameExt())) {
                this.getPrimaryFile().rename(fileLock, string.substring(0, n), string.substring(n + 1, string.length()));
                DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(this.getPrimaryFile())));
            }
        }
        finally {
            fileLock.releaseLock();
        }
        return this.getPrimaryFile();
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string != null && string.endsWith("." + this.getPrimaryFile().getExt())) {
            string = string.substring(0, string.lastIndexOf("." + this.getPrimaryFile().getExt()));
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    public void open() {
        EditorCookie editorCookie = (EditorCookie)this.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(NotifyDescriptor.OK_OPTION);
            arrayList.add(NotifyDescriptor.CANCEL_OPTION);
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage((Class)DefaultDataObject.class, (String)"MSG_BinaryFileQuestion"), NbBundle.getMessage((Class)DefaultDataObject.class, (String)"MSG_BinaryFileWarning"), -1, 3, arrayList.toArray(), null);
            Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (object != NotifyDescriptor.OK_OPTION) {
                return;
            }
            EditorCookie editorCookie2 = (EditorCookie)this.getCookie(EditorCookie.class, true);
            editorCookie2.open();
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        return this.getCookie(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Node.Cookie getCookie(Class clazz, boolean bl) {
        if (clazz == OpenCookie.class) {
            return this;
        }
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        if (!(clazz.isAssignableFrom(EditCookie.class) || clazz.isAssignableFrom(EditorCookie.Observable.class) || clazz.isAssignableFrom(PrintCookie.class) || clazz.isAssignableFrom(CloseCookie.class))) {
            if (clazz != DefaultES.class) return null;
        }
        try {
            Object object;
            if (!bl) {
                object = new byte[2048];
                InputStream inputStream = this.getPrimaryFile().getInputStream();
                try {
                    int n = inputStream.read((byte[])object);
                    for (int i = 0; i < n; ++i) {
                        if (object[i] < 0 || object[i] > 31 || object[i] == 10 || object[i] == 13 || object[i] == 9) continue;
                        Node.Cookie cookie2 = null;
                        return cookie2;
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            object = (Object)new DefaultES(this, this.getPrimaryEntry(), this.getCookieSet());
            this.getCookieSet().add((Node.Cookie)object);
            return this.getCookieSet().getCookie(clazz);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }
}

