/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.MultiDataObject;

final class FilesSet
implements Set {
    private MultiDataObject mymdo;
    private boolean lazyWorkDone;
    private Object primaryFile;
    private HashMap secondary;
    private TreeSet delegate;

    public FilesSet(MultiDataObject multiDataObject) {
        this.mymdo = multiDataObject;
        this.lazyWorkDone = false;
        this.primaryFile = null;
        this.secondary = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLazyWork() {
        FilesSet filesSet = this;
        synchronized (filesSet) {
            if (!this.lazyWorkDone) {
                this.lazyWorkDone = true;
                Object object = this.mymdo.synchObjectSecondary();
                synchronized (object) {
                    this.mymdo.secondaryEntries();
                    this.primaryFile = this.mymdo.getPrimaryFile();
                    this.secondary = this.mymdo.getSecondary();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getDelegate() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            if (this.delegate == null) {
                this.delegate = new TreeSet(new FilesComparator());
                this.delegate.add(this.primaryFile);
                this.delegate.addAll(this.secondary.keySet());
            }
        }
        return this.delegate;
    }

    public boolean add(Object object) {
        return this.getDelegate().add(object);
    }

    public boolean addAll(Collection collection) {
        return this.getDelegate().addAll(collection);
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(Object object) {
        return this.getDelegate().contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.getDelegate().containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            return this.delegate == null ? false : this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            return this.delegate == null ? new FilesIterator() : this.delegate.iterator();
        }
    }

    public boolean remove(Object object) {
        return this.getDelegate().remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.getDelegate().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getDelegate().retainAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            return this.delegate == null ? this.secondary.size() + 1 : this.delegate.size();
        }
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getDelegate().toArray(objectArray);
    }

    public boolean equals(Object object) {
        return ((Object)this.getDelegate()).equals(object);
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public int hashCode() {
        return ((Object)this.getDelegate()).hashCode();
    }

    private final class FilesComparator
    implements Comparator {
        FilesComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == FilesSet.this.primaryFile) {
                return -1;
            }
            if (object2 == FilesSet.this.primaryFile) {
                return 1;
            }
            FileObject fileObject = (FileObject)object;
            FileObject fileObject2 = (FileObject)object2;
            int n = fileObject.getNameExt().compareTo(fileObject2.getNameExt());
            if (n == 0) {
                try {
                    if (fileObject.getFileSystem() == fileObject2.getFileSystem()) {
                        return 0;
                    }
                    return fileObject.getFileSystem().getSystemName().compareTo(fileObject2.getFileSystem().getSystemName());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return 0;
                }
            }
            return n;
        }
    }

    private final class FilesIterator
    implements Iterator {
        private boolean first = true;
        private Iterator itDelegate = null;

        FilesIterator() {
        }

        public boolean hasNext() {
            return this.first ? true : this.getIteratorDelegate().hasNext();
        }

        public Object next() {
            if (this.first) {
                this.first = false;
                return FilesSet.this.primaryFile;
            }
            return this.getIteratorDelegate().next();
        }

        public void remove() {
            this.getIteratorDelegate().remove();
        }

        private Iterator getIteratorDelegate() {
            if (this.itDelegate == null) {
                this.itDelegate = FilesSet.this.getDelegate().iterator();
                this.itDelegate.next();
            }
            return this.itDelegate;
        }
    }
}

