/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.util.Enumerations;

final class FolderOrder
implements Comparator {
    private static final char SEP = '/';
    private static final WeakHashMap map = new WeakHashMap(101);
    private static final Map knownOrders = Collections.synchronizedMap(new WeakHashMap(50));
    private Map order;
    private FileObject folder;
    private boolean ignorePartials;
    private DataFolder.SortMode sortMode;
    private Object previous;

    private FolderOrder(FileObject fileObject) {
        this.folder = fileObject;
    }

    public void setSortMode(DataFolder.SortMode sortMode) throws IOException {
        this.sortMode = sortMode;
        sortMode.write(this.folder);
    }

    public DataFolder.SortMode getSortMode() {
        if (this.sortMode == null) {
            this.sortMode = DataFolder.SortMode.read(this.folder);
        }
        return this.sortMode;
    }

    public synchronized void setOrder(DataObject[] dataObjectArray) throws IOException {
        if (dataObjectArray != null) {
            this.order = new HashMap(dataObjectArray.length * 4 / 3 + 1);
            Enumeration enumeration = Enumerations.removeDuplicates((Enumeration)Enumerations.array((Object[])dataObjectArray));
            int n = 0;
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                FileObject fileObject = dataObject.getPrimaryFile();
                if (!this.folder.equals(fileObject.getParent())) continue;
                this.order.put(fileObject.getNameExt(), new Integer(n++));
            }
            this.ignorePartials = true;
        } else {
            this.order = null;
        }
        this.write();
    }

    public synchronized Map getOrderingConstraints(Collection collection) {
        Serializable serializable;
        Set set = this.readPartials();
        if (set.isEmpty()) {
            return null;
        }
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            serializable = (DataObject)iterator.next();
            hashMap.put(((DataObject)serializable).getPrimaryFile().getNameExt(), serializable);
        }
        serializable = new HashMap();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject;
            DataObject dataObject2;
            String string = (String)iterator.next();
            int n = string.indexOf(47);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (this.ignorePartials && (this.order.containsKey(string2) || this.order.containsKey(string3)) || (dataObject2 = (DataObject)hashMap.get(string2)) == null || (dataObject = (DataObject)hashMap.get(string3)) == null) continue;
            LinkedList<DataObject> linkedList = (LinkedList<DataObject>)serializable.get(dataObject2);
            if (linkedList == null) {
                linkedList = new LinkedList<DataObject>();
                serializable.put(dataObject2, linkedList);
            }
            linkedList.add(dataObject);
        }
        return serializable;
    }

    private Set readPartials() {
        Enumeration enumeration = this.folder.getAttributes();
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (string.indexOf(47) == -1 || !((object = this.folder.getAttribute(string)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public int compare(Object object, Object object2) {
        Integer n;
        DataObject dataObject = (DataObject)object;
        DataObject dataObject2 = (DataObject)object2;
        Integer n2 = this.order == null ? null : (Integer)this.order.get(dataObject.getPrimaryFile().getNameExt());
        Integer n3 = n = this.order == null ? null : (Integer)this.order.get(dataObject2.getPrimaryFile().getNameExt());
        if (n2 == null) {
            if (n != null) {
                return 1;
            }
            return this.getSortMode().compare(dataObject, dataObject2);
        }
        if (n == null) {
            return -1;
        }
        if (n2.intValue() == n.intValue()) {
            return 0;
        }
        if (n2 < n) {
            return -1;
        }
        return 1;
    }

    public void write() throws IOException {
        if (this.order == null) {
            this.folder.setAttribute("OpenIDE-Folder-Order", null);
        } else {
            Object object;
            Iterator iterator = this.order.entrySet().iterator();
            String[] stringArray = new String[this.order.size()];
            while (iterator.hasNext()) {
                object = iterator.next();
                String string = (String)object.getKey();
                int n = (Integer)object.getValue();
                stringArray[n] = string;
            }
            object = new StringBuffer(255);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append('/');
                }
                ((StringBuffer)object).append(stringArray[i]);
            }
            Set set = this.ignorePartials ? this.readPartials() : null;
            this.folder.setAttribute("OpenIDE-Folder-Order", (Object)((StringBuffer)object).toString());
            if (this.ignorePartials) {
                if (!set.isEmpty()) {
                    String string;
                    HashSet<String> hashSet = new HashSet<String>();
                    iterator = this.order.keySet().iterator();
                    while (iterator.hasNext()) {
                        string = (String)((Object)iterator.next());
                        hashSet.add(string);
                    }
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        int n;
                        string = (String)((Object)iterator.next());
                        if (!hashSet.contains(string.substring(0, n = string.indexOf(47))) || !hashSet.contains(string.substring(n + 1))) continue;
                        this.folder.setAttribute(string, null);
                    }
                }
                this.ignorePartials = false;
            }
        }
    }

    private void read() {
        Object object = this.folder.getAttribute("OpenIDE-Folder-Order");
        if (this.previous == null && object == null || this.previous != null && this.previous.equals(object)) {
            return;
        }
        if (object instanceof Object[] && this.previous instanceof Object[] && FolderOrder.compare((Object[])object, (Object[])this.previous)) {
            return;
        }
        this.doRead(object);
        this.previous = object;
        if (this.previous != null) {
            knownOrders.put(this.folder, this.previous);
        }
        FolderList.changedFolderOrder(this.folder);
    }

    private static boolean compare(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3;
        if (objectArray == objectArray2) {
            return true;
        }
        int n = Math.min(objectArray.length, objectArray2.length);
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == objectArray2[i]) continue;
            if (objectArray[i] == null) {
                return false;
            }
            if (objectArray[i].equals(objectArray2[i])) continue;
            if (objectArray[i] instanceof Object[] && objectArray2[i] instanceof Object[]) {
                if (FolderOrder.compare((Object[])objectArray[i], (Object[])objectArray2[i])) continue;
                return false;
            }
            return false;
        }
        Object[] objectArray4 = objectArray3 = objectArray.length > objectArray2.length ? objectArray : objectArray2;
        return !FolderOrder.checkNonNull(objectArray3, n);
    }

    private static boolean checkNonNull(Object[] objectArray, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            return true;
        }
        return false;
    }

    private void doRead(Object object) {
        if (object == null) {
            this.order = null;
            return;
        }
        if (object instanceof String[][]) {
            String[][] stringArray = (String[][])object;
            if (stringArray.length != 2) {
                this.order = null;
                return;
            }
            String[] stringArray2 = stringArray[0];
            String[] stringArray3 = stringArray[1];
            if (stringArray2 == null || stringArray3 == null || stringArray2.length != stringArray3.length) {
                this.order = null;
                return;
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(stringArray2.length);
            for (int i = 0; i < stringArray2.length; ++i) {
                hashMap.put(stringArray2[i], new Integer(i));
            }
            this.order = hashMap;
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                hashMap.put(string2, new Integer(n));
                ++n;
            }
            this.order = hashMap;
            return;
        }
        this.order = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderOrder findFor(FileObject fileObject) {
        FolderOrder folderOrder = null;
        Object object = map;
        synchronized (object) {
            Reference reference = (Reference)map.get(fileObject);
            FolderOrder folderOrder2 = folderOrder = reference == null ? null : (FolderOrder)reference.get();
            if (folderOrder == null) {
                folderOrder = new FolderOrder(fileObject);
                folderOrder.previous = knownOrders.get(fileObject);
                folderOrder.doRead(folderOrder.previous);
                map.put(fileObject, new SoftReference<FolderOrder>(folderOrder));
            }
        }
        object = folderOrder;
        synchronized (object) {
            folderOrder.read();
            return folderOrder;
        }
    }
}

