/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.FilesSet;
import org.openide.loaders.FolderList;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public class MultiDataObject
extends DataObject {
    static final long serialVersionUID = -7750146802134210308L;
    private static final Object cookieSetLock = new Object();
    private static final Object secondaryCreationLock = new Object();
    private static final RequestProcessor firingProcessor = new RequestProcessor("MDO PropertyChange processor");
    private static final RequestProcessor delayProcessor = new RequestProcessor("MDO Firing delayer");
    private RequestProcessor.Task delayedPropFilesTask;
    private static final Object delayedPropFilesLock = new Object();
    static final ErrorManager ERR = ErrorManager.getDefault().getInstance(MultiDataObject.class.getName());
    static final boolean LOG = ERR.isLoggable(1);
    private Entry primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    private HashMap secondary;
    private CookieSet cookieSet;
    boolean checked = false;
    private ChangeListener chLis;
    private static EmptyRecognizer RECOGNIZER = new EmptyRecognizer();

    public MultiDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    MultiDataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataLoader);
    }

    public final MultiFileLoader getMultiFileLoader() {
        DataLoader dataLoader = this.getLoader();
        if (!(dataLoader instanceof MultiFileLoader)) {
            return null;
        }
        return (MultiFileLoader)dataLoader;
    }

    public Set files() {
        return new FilesSet(this);
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existReadOnlySecondary() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            Iterator iterator = this.getSecondary().keySet().iterator();
            while (iterator.hasNext()) {
                if (!((FileObject)iterator.next()).isReadOnly()) continue;
                return true;
            }
        }
        return false;
    }

    private HashMap checkSecondary() {
        if (!this.checked) {
            this.checkFiles(this);
            this.checked = true;
        }
        return this.getSecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getSecondary() {
        Object object = secondaryCreationLock;
        synchronized (object) {
            if (this.secondary == null) {
                this.secondary = new HashMap(4);
            }
            if (LOG) {
                ERR.log("getSecondary for " + this + " is " + this.secondary);
            }
            return this.secondary;
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    Object synchObjectSecondary() {
        HashMap hashMap = this.checkSecondary();
        if (hashMap == null) {
            throw new IllegalStateException("checkSecondary was null from " + this);
        }
        return this.checkSecondary();
    }

    protected Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        return dataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSecondaryEntry(Entry entry) {
        Object object = this.getSecondary();
        synchronized (object) {
            this.getSecondary().put(entry.getFile(), entry);
            if (LOG) {
                ERR.log("addSecondaryEntry: " + entry + " for " + this);
            }
        }
        object = this.getFolderList();
        if (object == null) {
            this.firePropertyChangeLater("files", null, null);
        } else if (((FolderList)object).isCreated()) {
            this.firePropertyChangeLater("files", null, null);
        } else {
            this.firePropFilesAfterFinishing();
        }
    }

    private FolderList getFolderList() {
        FileObject fileObject = this.primary.file.getParent();
        if (fileObject != null) {
            return FolderList.find(fileObject, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeSecondaryEntry(Entry entry) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            this.getSecondary().remove(entry.getFile());
            if (LOG) {
                ERR.log("removeSecondaryEntry: " + entry + " for " + this);
            }
        }
        this.firePropertyChangeLater("files", null, null);
        if (entry.isImportant()) {
            this.checkConsistency(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markSecondaryEntriesRecognized(DataLoader.RecognizedFiles recognizedFiles) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            Iterator iterator = this.getSecondary().keySet().iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                recognizedFiles.markRecognized(fileObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry registerEntry(FileObject fileObject) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            if (fileObject == null) {
                return this.primary;
            }
            if (fileObject.equals(this.getPrimaryFile())) {
                return this.primary;
            }
            Entry entry = (Entry)this.getSecondary().get(fileObject);
            if (entry != null) {
                return entry;
            }
            entry = this.createSecondaryEntry(this, fileObject);
            this.addSecondaryEntry(entry);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeFile(FileObject fileObject) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            Entry entry = (Entry)this.getSecondary().get(fileObject);
            if (entry != null) {
                this.removeSecondaryEntry(entry);
            }
        }
    }

    public final Entry getPrimaryEntry() {
        return this.primary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set secondaryEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            return new HashSet(this.getSecondary().values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Entry findSecondaryEntry(FileObject fileObject) {
        Entry entry;
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            entry = (Entry)this.getSecondary().get(fileObject);
        }
        return entry;
    }

    private void removeAllInvalid() {
        if (LOG) {
            ERR.log("removeAllInvalid, started " + this);
        }
        Iterator iterator = this.checkSecondary().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FileObject fileObject = (FileObject)entry.getKey();
            if (fileObject.isValid()) continue;
            iterator.remove();
            if (LOG) {
                ERR.log("removeAllInvalid, removed: " + fileObject + " for " + this);
            }
            this.firePropertyChangeLater("files", null, null);
        }
        if (LOG) {
            ERR.log("removeAllInvalid, finished " + this);
        }
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryEntry().takeLock();
    }

    private String existInFolder(FileObject fileObject, FileObject fileObject2) {
        if (fileObject.isFolder() && this.isMergingFolders(fileObject, fileObject2)) {
            return "";
        }
        String string = fileObject.getName();
        String string2 = FileUtil.findFreeFileName((FileObject)fileObject2, (String)string, (String)fileObject.getExt());
        if (string2.length() <= string.length()) {
            return "";
        }
        return string2.substring(string.length());
    }

    boolean isMergingFolders(FileObject fileObject, FileObject fileObject2) {
        return false;
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        Iterator iterator = this.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).copy(dataFolder.getPrimaryFile(), string);
        }
        FileObject fileObject = this.getPrimaryEntry().copy(dataFolder.getPrimaryFile(), string);
        try {
            return this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDelete() throws IOException {
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            iterator = new ArrayList(this.getSecondary().entrySet()).iterator();
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            ((Entry)object.getValue()).delete();
            arrayList.add(object.getKey());
        }
        object = this.synchObjectSecondary();
        synchronized (object) {
            Object[] objectArray = arrayList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.getSecondary().remove(objectArray[i]);
                if (!LOG) continue;
                ERR.log("  handleDelete, removed entry: " + objectArray[i]);
            }
        }
        this.getPrimaryEntry().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleRename(String string) throws IOException {
        Object[] objectArray;
        Iterator iterator;
        this.getPrimaryEntry().changeFile(this.getPrimaryEntry().rename(string));
        HashMap<FileObject, Entry> hashMap = null;
        ArrayList arrayList = new ArrayList();
        Map.Entry entry = this.synchObjectSecondary();
        synchronized (entry) {
            this.removeAllInvalid();
            iterator = new ArrayList(this.getSecondary().entrySet()).iterator();
        }
        while (iterator.hasNext()) {
            entry = iterator.next();
            objectArray = ((Entry)entry.getValue()).rename(string);
            if (objectArray == null) {
                arrayList.add(entry.getKey());
                continue;
            }
            if (objectArray.equals(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<FileObject, Entry>();
            }
            Entry entry2 = (Entry)entry.getValue();
            entry2.changeFile((FileObject)objectArray);
            hashMap.put(entry2.getFile(), entry2);
            arrayList.add(entry.getKey());
        }
        if (hashMap != null || !arrayList.isEmpty()) {
            entry = this.synchObjectSecondary();
            synchronized (entry) {
                if (!arrayList.isEmpty()) {
                    objectArray = arrayList.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        this.getSecondary().remove(objectArray[i]);
                        if (!LOG) continue;
                        ERR.log("handleRename, removed: " + objectArray[i] + " for " + this);
                    }
                }
                if (hashMap != null) {
                    this.getSecondary().putAll(hashMap);
                    if (LOG) {
                        ERR.log("handleRename, putAll: " + hashMap + " for " + this);
                    }
                }
            }
            this.firePropertyChangeLater("files", null, null);
        }
        return this.getPrimaryEntry().getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        List list = this.saveEntries();
        try {
            Iterator iterator;
            int n;
            Object[] objectArray;
            HashMap<FileObject, Entry> hashMap = null;
            ArrayList arrayList = new ArrayList();
            Object object = this.synchObjectSecondary();
            synchronized (object) {
                this.removeAllInvalid();
                objectArray = new ArrayList(this.getSecondary().entrySet());
                n = objectArray.size();
                iterator = objectArray.iterator();
            }
            if (LOG) {
                ERR.log("move " + this + " to " + dataFolder + " number of secondary entries: " + n);
                ERR.log("moving primary entry: " + this.getPrimaryEntry());
            }
            this.getPrimaryEntry().changeFile(this.getPrimaryEntry().move(dataFolder.getPrimaryFile(), string));
            if (LOG) {
                ERR.log("               moved: " + this.getPrimaryEntry().getFile());
            }
            while (iterator.hasNext()) {
                object = iterator.next();
                if (LOG) {
                    ERR.log("moving entry :" + object);
                }
                objectArray = ((Entry)object.getValue()).move(dataFolder.getPrimaryFile(), string);
                if (LOG) {
                    ERR.log("  moved to   :" + objectArray);
                }
                if (objectArray == null) {
                    arrayList.add(object.getKey());
                    continue;
                }
                if (objectArray.equals(object.getKey())) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<FileObject, Entry>();
                }
                Entry entry = (Entry)object.getValue();
                entry.changeFile((FileObject)objectArray);
                hashMap.put(entry.getFile(), entry);
                arrayList.add(object.getKey());
            }
            if (hashMap != null || !arrayList.isEmpty()) {
                object = this.synchObjectSecondary();
                synchronized (object) {
                    if (!arrayList.isEmpty()) {
                        objectArray = arrayList.toArray();
                        for (int i = 0; i < objectArray.length; ++i) {
                            this.getSecondary().remove(objectArray[i]);
                            if (!LOG) continue;
                            ERR.log("handleMove, remove: " + objectArray[i] + " for " + this);
                        }
                    }
                    if (hashMap != null) {
                        this.getSecondary().putAll(hashMap);
                        if (LOG) {
                            ERR.log("handleMove, putAll: " + hashMap + " for " + this);
                        }
                    }
                }
                this.firePropertyChangeLater("files", null, null);
            }
            if (LOG) {
                ERR.log("successfully moved " + this);
            }
            return this.getPrimaryEntry().getFile();
        }
        catch (IOException iOException) {
            if (LOG) {
                ERR.log("exception is here, restoring entries " + this);
                ERR.notify(1, (Throwable)iOException);
            }
            this.restoreEntries(list);
            if (LOG) {
                ERR.log("entries restored " + this);
            }
            throw iOException;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.getPrimaryFile().getExt());
        }
        FileObject fileObject = this.getPrimaryEntry().createFromTemplate(dataFolder.getPrimaryFile(), string);
        Iterator iterator = this.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).createFromTemplate(dataFolder.getPrimaryFile(), string);
        }
        try {
            if (this instanceof DefaultDataObject) {
                return DataObject.find(fileObject);
            }
            return this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    protected final void setCookieSet(CookieSet cookieSet) {
        this.setCookieSet(cookieSet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCookieSet(CookieSet cookieSet, boolean bl) {
        Object object = cookieSetLock;
        synchronized (object) {
            ChangeListener changeListener = this.getChangeListener();
            if (this.cookieSet != null) {
                this.cookieSet.removeChangeListener(changeListener);
            }
            cookieSet.addChangeListener(changeListener);
            this.cookieSet = cookieSet;
        }
        if (bl) {
            this.fireCookieChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null) {
            return cookieSet;
        }
        Object object = cookieSetLock;
        synchronized (object) {
            if (this.cookieSet != null) {
                return this.cookieSet;
            }
            this.setCookieSet(new CookieSet(), false);
            return this.cookieSet;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie;
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null && (cookie = cookieSet.getCookie(clazz)) != null) {
            return cookie;
        }
        return super.getCookie(clazz);
    }

    final void fireCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    private void firePropertyChangeLater(final String string, final Object object, final Object object2) {
        firingProcessor.post(new Runnable(){

            public void run() {
                MultiDataObject.this.firePropertyChange(string, object, object2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropFilesAfterFinishing() {
        Object object = delayedPropFilesLock;
        synchronized (object) {
            if (this.delayedPropFilesTask == null) {
                this.delayedPropFilesTask = delayProcessor.post(new Runnable(){

                    public void run() {
                        FolderList folderList = MultiDataObject.this.getFolderList();
                        if (folderList != null) {
                            folderList.waitProcessingFinished();
                        }
                        MultiDataObject.this.firePropertyChangeLater("files", null, null);
                    }
                });
            } else {
                this.delayedPropFilesTask.schedule(0);
            }
        }
    }

    final void recognizedByFolder() {
        this.checked = true;
    }

    final ChangeListener getChangeListener() {
        if (this.chLis == null) {
            this.chLis = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MultiDataObject.this.fireCookieChange();
                }
            };
        }
        return this.chLis;
    }

    private final Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createPrimaryEntry(multiDataObject, fileObject);
        }
        Entry entry = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return entry;
    }

    private final Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createSecondaryEntryImpl(multiDataObject, fileObject);
        }
        Entry entry = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return entry;
    }

    private final MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        MultiDataObject multiDataObject = multiFileLoader != null ? DataObjectPool.createMultiObject(multiFileLoader, fileObject) : (MultiDataObject)this.getLoader().findDataObject(fileObject, RECOGNIZER);
        return multiDataObject;
    }

    private final void checkConsistency(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkConsistency(multiDataObject);
        }
    }

    private final void checkFiles(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkFiles(multiDataObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List saveEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            LinkedList<Pair> linkedList = new LinkedList<Pair>();
            Iterator iterator = this.secondaryEntries().iterator();
            linkedList.add(new Pair(this.getPrimaryEntry()));
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                linkedList.add(new Pair(entry));
            }
            return linkedList;
        }
    }

    final void restoreEntries(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.entry.getFile().equals(pair.file)) continue;
            if (pair.file.isValid()) {
                pair.entry.changeFile(pair.file);
                continue;
            }
            try {
                if (pair.entry.getFile().isData()) {
                    pair.entry.changeFile(pair.entry.getFile().copy(pair.file.getParent(), pair.file.getName(), pair.file.getExt()));
                    continue;
                }
                FileObject fileObject = pair.file.getParent().createFolder(pair.file.getName());
                FileUtil.copyAttributes((FileObject)pair.entry.getFile(), (FileObject)fileObject);
                pair.entry.changeFile(fileObject);
            }
            catch (IOException iOException) {}
        }
    }

    void notifyFileDeleted(FileEvent fileEvent) {
        this.removeFile(fileEvent.getFile());
        if (fileEvent.getFile().equals(this.getPrimaryFile())) {
            try {
                this.markInvalid0();
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            }
        }
    }

    void notifyFileDataCreated(FileEvent fileEvent) {
        this.checked = false;
    }

    private static final class EntryReplace
    implements Serializable {
        static final long serialVersionUID = -1498798537289529182L;
        private FileObject file;
        private transient Entry entry;

        public EntryReplace(FileObject fileObject) {
            this.file = fileObject;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            try {
                DataObject dataObject = DataObject.find(this.file);
                if (dataObject instanceof MultiDataObject) {
                    MultiDataObject multiDataObject = (MultiDataObject)dataObject;
                    if (this.file.equals(multiDataObject.getPrimaryFile())) {
                        this.entry = multiDataObject.getPrimaryEntry();
                    } else {
                        Entry entry = multiDataObject.findSecondaryEntry(this.file);
                        if (entry == null) {
                            throw new InvalidObjectException(dataObject.toString());
                        }
                        this.entry = entry;
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new InvalidObjectException(dataObjectNotFoundException.getMessage());
            }
        }

        public Object readResolve() {
            return this.entry;
        }
    }

    public abstract class Entry
    implements Serializable {
        static final long serialVersionUID = 6024795908818133571L;
        private FileObject file;
        private transient WeakReference lock;

        protected Entry(FileObject fileObject) {
            this.file = fileObject;
            if (!this.isImportant()) {
                fileObject.setImportant(false);
            }
        }

        final void changeFile(FileObject fileObject) {
            FileLock fileLock;
            if (fileObject.equals(this.file)) {
                return;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "changeFile: " + fileObject + " for " + this + " of " + this.getDataObject());
            }
            fileObject.setImportant(this.isImportant());
            this.file = fileObject;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock != null && fileLock.isValid()) {
                if (ERR.isLoggable(1)) {
                    ERR.log("releasing old lock: " + this + " was: " + fileLock);
                }
                fileLock.releaseLock();
            }
            this.lock = null;
        }

        public final FileObject getFile() {
            return this.file;
        }

        public final MultiDataObject getDataObject() {
            return MultiDataObject.this;
        }

        public boolean isImportant() {
            return true;
        }

        public abstract FileObject copy(FileObject var1, String var2) throws IOException;

        public abstract FileObject rename(String var1) throws IOException;

        public abstract FileObject move(FileObject var1, String var2) throws IOException;

        public abstract void delete() throws IOException;

        public abstract FileObject createFromTemplate(FileObject var1, String var2) throws IOException;

        public FileLock takeLock() throws IOException {
            FileLock fileLock;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock == null || !fileLock.isValid()) {
                fileLock = this.getFile().lock();
                this.lock = new WeakReference<FileLock>(fileLock);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("takeLock: " + this + " is: " + fileLock);
            }
            return fileLock;
        }

        public boolean isLocked() {
            FileLock fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            return fileLock != null && fileLock.isValid();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return this.getFile().equals(((Entry)object).getFile());
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        protected Object writeReplace() {
            return new EntryReplace(this.getFile());
        }
    }

    private static final class Pair {
        Entry entry;
        FileObject file;

        Pair(Entry entry) {
            this.entry = entry;
            this.file = entry.getFile();
        }
    }

    private static class EmptyRecognizer
    implements DataLoader.RecognizedFiles {
        EmptyRecognizer() {
        }

        public void markRecognized(FileObject fileObject) {
        }
    }
}

