/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.xml.parsers.DocumentBuilder;
import org.openide.ErrorManager;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.Environment;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObjectImpl;
import org.openide.loaders.XMLEntityResolverChain;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.windows.CloneableOpenSupport;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataObject
extends MultiDataObject {
    static final long serialVersionUID = 8757854986453256578L;
    public static final String XMLINFO_DTD_PUBLIC_ID_FORTE = "-//Forte for Java//DTD xmlinfo//EN";
    public static final String XMLINFO_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD xmlinfo//EN";
    public static final String MIME = "text/xml";
    public static final int STATUS_NOT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final String PROP_DOCUMENT = "document";
    public static final String PROP_INFO = "info";
    private static ErrorPrinter errorHandler = new ErrorPrinter();
    private static XMLEntityResolverChain chainingEntityResolver;
    private static HashMap infos;
    private static Object emgrLock;
    private DelDoc doc;
    private int status;
    private EditorCookie editor = null;
    private InfoParser infoParser;
    private static final ErrorManager ERR;
    private static final boolean LOG;
    private static final StopSaxException STOP;
    private static XMLReader sharedParserImpl;
    private static final Lookup.Template TEMPLATE;
    private static final String NULL = "";
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$Processor;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$DelDoc;
    static /* synthetic */ Class class$org$w3c$dom$DocumentType;

    public XMLDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.getIP(), (Object)fileObject));
        this.status = 0;
        CookieSet.Factory factory = new CookieSet.Factory(){

            public Node.Cookie createCookie(Class clazz) {
                if (clazz.isAssignableFrom(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = XMLDataObject.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie) || clazz.isAssignableFrom(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = XMLDataObject.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie) || clazz.isAssignableFrom(class$org$openide$cookies$CloseCookie == null ? (class$org$openide$cookies$CloseCookie = XMLDataObject.class$("org.openide.cookies.CloseCookie")) : class$org$openide$cookies$CloseCookie) || clazz.isAssignableFrom(class$org$openide$cookies$PrintCookie == null ? (class$org$openide$cookies$PrintCookie = XMLDataObject.class$("org.openide.cookies.PrintCookie")) : class$org$openide$cookies$PrintCookie)) {
                    if (XMLDataObject.this.editor == null) {
                        XMLDataObject.this.editor = XMLDataObject.this.createEditorCookie();
                    }
                    if (XMLDataObject.this.editor == null) {
                        return null;
                    }
                    return clazz.isAssignableFrom(XMLDataObject.this.editor.getClass()) ? XMLDataObject.this.editor : null;
                }
                return null;
            }
        };
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(EditorCookie.class, factory);
        cookieSet.add(OpenCookie.class, factory);
        cookieSet.add(CloseCookie.class, factory);
        cookieSet.add(PrintCookie.class, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InfoParser getIP() {
        Object object = emgrLock;
        synchronized (object) {
            if (this.infoParser == null) {
                this.infoParser = new InfoParser();
            }
        }
        return this.infoParser;
    }

    protected Node createNodeDelegate() {
        XMLNode xMLNode = new XMLNode(this);
        xMLNode.setShortDescription(NbBundle.getMessage((Class)XMLDataObject.class, (String)"HINT_XMLDataObject"));
        return xMLNode;
    }

    protected void updateIconBase(String string) {
    }

    protected void handleDelete() throws IOException {
        this.getIP().waitFinished();
        super.handleDelete();
    }

    public HelpCtx getHelpCtx() {
        try {
            if (this.getPrimaryFile().getFileSystem().isDefault() && this.getCookie(InstanceCookie.class) != null) {
                return HelpCtx.DEFAULT_HELP;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return new HelpCtx(XMLDataObject.class);
    }

    public Node.Cookie getCookie(Class clazz) {
        this.getIP().waitFinished();
        Node.Cookie cookie = (Node.Cookie)this.getIP().lookupCookie(clazz);
        if (LOG) {
            ERR.log("Query for " + clazz + " for " + this);
            ERR.log("Gives a cake " + cookie + " for " + this);
        }
        if (cookie instanceof InstanceCookie) {
            cookie = this.ofCookie((InstanceCookie)cookie, clazz);
        }
        if (LOG) {
            ERR.log("After ofCookie: " + cookie + " for " + this);
        }
        if (cookie == null) {
            cookie = super.getCookie(clazz);
        }
        if (LOG) {
            ERR.log("getCookie returns " + cookie + " for " + this);
        }
        return cookie;
    }

    private InstanceCookie ofCookie(InstanceCookie instanceCookie, Class clazz) {
        if (instanceCookie instanceof InstanceCookie.Of) {
            return instanceCookie;
        }
        if (!clazz.isAssignableFrom(ICDel.class)) {
            return instanceCookie;
        }
        ICDel iCDel = new ICDel(this, instanceCookie);
        return iCDel;
    }

    private void notifyEx(Exception exception) {
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.annotate((Throwable)exception, "Cannot resolve following class in xmlinfo.");
        errorManager.notify((Throwable)exception);
    }

    protected EditorCookie createEditorCookie() {
        return new XMLEditorSupport(this);
    }

    private final void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    private final void removeSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().remove((Node.Cookie)saveCookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Document getDocument() throws IOException, SAXException {
        if (LOG) {
            ERR.log("getDocument for " + this);
        }
        XMLDataObject xMLDataObject = this;
        synchronized (xMLDataObject) {
            DelDoc delDoc = this.doc;
            if (delDoc == null) {
                this.doc = delDoc = new DelDoc();
            }
            return delDoc.getProxyDocument();
        }
    }

    final void clearDocument() {
        if (LOG) {
            ERR.log("clearDocument for " + this);
        }
        this.doc = null;
        this.firePropertyChange(PROP_DOCUMENT, null, null);
    }

    public final int getStatus() {
        return this.status;
    }

    public final Info getInfo() {
        return null;
    }

    public final synchronized void setInfo(Info info) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Document parsePrimaryFile() throws IOException, SAXException {
        if (LOG) {
            ERR.log("parsePrimaryFile for " + this);
        }
        String string = this.getPrimaryFile().getURL().toExternalForm();
        try {
            return XMLUtil.parse((InputSource)new InputSource(string), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
        }
        catch (IOException iOException) {
            InputStream inputStream = this.getPrimaryFile().getInputStream();
            try {
                Document document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
                return document;
            }
            finally {
                inputStream.close();
            }
        }
    }

    public static Document parse(URL uRL) throws IOException, SAXException {
        return XMLDataObject.parse(uRL, errorHandler, false);
    }

    public static Document parse(URL uRL, boolean bl) throws IOException, SAXException {
        return XMLDataObject.parse(uRL, errorHandler, bl);
    }

    public static Document parse(URL uRL, ErrorHandler errorHandler) throws IOException, SAXException {
        return XMLDataObject.parse(uRL, errorHandler, false);
    }

    public static Document parse(URL uRL, ErrorHandler errorHandler, boolean bl) throws IOException, SAXException {
        DocumentBuilder documentBuilder = XMLDataObjectImpl.makeBuilder(bl);
        documentBuilder.setErrorHandler(errorHandler);
        documentBuilder.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return documentBuilder.parse(new InputSource(uRL.toExternalForm()));
    }

    public static Parser createParser() {
        return XMLDataObject.createParser(false);
    }

    public static Parser createParser(boolean bl) {
        Parser parser = XMLDataObjectImpl.makeParser(bl);
        parser.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return parser;
    }

    public static Document createDocument() {
        XMLDataObject.deprecated();
        try {
            return XMLDataObjectImpl.makeBuilder(false).newDocument();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public static void write(Document document, Writer writer) throws IOException {
        XMLDataObject.deprecated();
        try {
            Class<?> clazz = Class.forName("org.openide.xml.XMLUtilImpl");
            Method method = clazz.getDeclaredMethod("write", Document.class, Object.class, String.class);
            method.setAccessible(true);
            method.invoke(null, document, writer, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
    }

    public static void write(Document document, OutputStream outputStream, String string) throws IOException {
        XMLUtil.write((Document)document, (OutputStream)outputStream, (String)string);
    }

    public static InputSource createInputSource(URL uRL) throws IOException {
        return new InputSource(uRL.toExternalForm());
    }

    public static void registerCatalogEntry(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(string, string2);
    }

    public static void registerCatalogEntry(String string, String string2, ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(string, "nbres:/" + string2);
    }

    public static final boolean addEntityResolver(EntityResolver entityResolver) {
        return XMLDataObject.getChainingEntityResolver().addEntityResolver(entityResolver);
    }

    public static final EntityResolver removeEntityResolver(EntityResolver entityResolver) {
        return XMLDataObject.getChainingEntityResolver().removeEntityResolver(entityResolver);
    }

    private static synchronized XMLEntityResolverChain getChainingEntityResolver() {
        if (chainingEntityResolver == null) {
            chainingEntityResolver = new XMLEntityResolverChain();
            chainingEntityResolver.addEntityResolver(XMLDataObject.getSystemResolver());
        }
        return chainingEntityResolver;
    }

    private static EntityResolver getSystemResolver() {
        return EntityCatalog.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInfo(String string, Info info) {
        HashMap hashMap = infos;
        synchronized (hashMap) {
            if (info == null) {
                infos.remove(string);
            } else {
                infos.put(string, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getRegisteredInfo(String string) {
        HashMap hashMap = infos;
        synchronized (hashMap) {
            Info info = (Info)infos.get(string);
            return info == null ? null : (Info)info.clone();
        }
    }

    private static void deprecated() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Exception(NULL).printStackTrace(printWriter);
        printWriter.flush();
        String string = stringWriter.toString().trim();
        int n = string.indexOf("\n");
        int n2 = string.indexOf("\n", n + 1);
        while (string.indexOf("XMLDataObject", n + 1) > 0) {
            n = n2;
            n2 = string.indexOf("\n", n + 1);
        }
        String string2 = string.substring(n + 1, n2).trim();
        System.out.println("Warning: deprecated method called " + string2);
    }

    static Lookup createInfoLookup(XMLDataObject xMLDataObject, Info info) {
        return new InfoLkp(xMLDataObject, info);
    }

    private Node findNode() {
        Node node = (Node)this.getIP().lookupCookie(Node.class);
        if (node == null) {
            return new PlainDataNode();
        }
        return node;
    }

    static /* synthetic */ XMLReader access$500() {
        return sharedParserImpl;
    }

    static {
        infos = new HashMap();
        emgrLock = new Object();
        ERR = ErrorManager.getDefault().getInstance(XMLDataObject.class.getName());
        LOG = ERR.isLoggable(1);
        STOP = new StopSaxException();
        sharedParserImpl = null;
        try {
            sharedParserImpl = XMLUtil.createXMLReader();
            sharedParserImpl.setEntityResolver(new EmptyEntityResolver());
        }
        catch (SAXException sAXException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)sAXException, "System does not contain JAXP 1.1 compliant parser!");
            errorManager.notify(65536, (Throwable)sAXException);
        }
        try {
            Properties properties = System.getProperties();
            if (properties.getProperty("org.xml.sax.driver") == null) {
                properties.put("org.xml.sax.driver", sharedParserImpl.getClass().getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TEMPLATE = new Lookup.Template(Node.Cookie.class);
    }

    private final class DelDoc
    implements InvocationHandler {
        private Reference xmlDocument;
        private final Document proxyDocument = (Document)Proxy.newProxyInstance((class$org$openide$loaders$XMLDataObject$DelDoc == null ? (class$org$openide$loaders$XMLDataObject$DelDoc = XMLDataObject.class$("org.openide.loaders.XMLDataObject$DelDoc")) : class$org$openide$loaders$XMLDataObject$DelDoc).getClassLoader(), new Class[]{class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XMLDataObject.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document}, (InvocationHandler)this);

        DelDoc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Document getDocumentImpl(boolean bl) {
            DelDoc delDoc = this;
            synchronized (delDoc) {
                Object var3_3;
                Object v0 = var3_3 = this.xmlDocument == null ? null : this.xmlDocument.get();
                if (var3_3 instanceof Document) {
                    return var3_3;
                }
                if (!bl) {
                    return null;
                }
                XMLDataObject.this.status = 1;
                try {
                    Document document = XMLDataObject.this.parsePrimaryFile();
                    this.xmlDocument = new SoftReference<Document>(document);
                    return document;
                }
                catch (SAXException sAXException) {
                    ERR.notify(1, (Throwable)sAXException);
                }
                catch (IOException iOException) {
                    ERR.notify(1, (Throwable)iOException);
                }
                XMLDataObject.this.status = 3;
                Document document = XMLUtil.createDocument((String)"brokenDocument", null, null, null);
                this.xmlDocument = new SoftReference<Document>(document);
                XMLDataObject.this.firePropertyChange(XMLDataObject.PROP_DOCUMENT, null, null);
                return document;
            }
        }

        public Document getProxyDocument() {
            return this.proxyDocument;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("getDoctype") && objectArray == null) {
                return Proxy.newProxyInstance((class$org$openide$loaders$XMLDataObject$DelDoc == null ? (class$org$openide$loaders$XMLDataObject$DelDoc = XMLDataObject.class$("org.openide.loaders.XMLDataObject$DelDoc")) : class$org$openide$loaders$XMLDataObject$DelDoc).getClassLoader(), new Class[]{class$org$w3c$dom$DocumentType == null ? (class$org$w3c$dom$DocumentType = XMLDataObject.class$("org.w3c.dom.DocumentType")) : class$org$w3c$dom$DocumentType}, (InvocationHandler)this);
            }
            if (method.getName().equals("getPublicId") && objectArray == null) {
                Document document = this.getDocumentImpl(false);
                if (document != null) {
                    DocumentType documentType = document.getDoctype();
                    return documentType == null ? null : documentType.getPublicId();
                }
                return XMLDataObject.this.getIP().getPublicId();
            }
            return method.invoke((Object)this.getDocumentImpl(true), objectArray);
        }
    }

    private static class ICDel
    implements InstanceCookie.Of {
        private XMLDataObject obj;
        private InstanceCookie ic;

        public ICDel(XMLDataObject xMLDataObject, InstanceCookie instanceCookie) {
            this.obj = xMLDataObject;
            this.ic = instanceCookie;
        }

        public String instanceName() {
            return this.ic.instanceName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.ic.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return this.ic.instanceCreate();
        }

        public boolean instanceOf(Class clazz) {
            if (this.ic instanceof InstanceCookie.Of) {
                return ((InstanceCookie.Of)this.ic).instanceOf(clazz);
            }
            try {
                return clazz.isAssignableFrom(this.instanceClass());
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public int hashCode() {
            return 2 * this.obj.hashCode() + this.ic.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ICDel) {
                ICDel iCDel = (ICDel)object;
                return iCDel.obj == object && iCDel.ic == this.ic;
            }
            return false;
        }
    }

    private final class XMLNode
    extends FilterNode {
        public XMLNode(XMLDataObject xMLDataObject2) {
            this(xMLDataObject2.findNode());
        }

        private XMLNode(Node node) {
            super(node, (Children)new FilterNode.Children(node));
        }

        private void update() {
            this.changeOriginal(XMLDataObject.this.findNode(), true);
        }
    }

    private final class PlainDataNode
    extends DataNode {
        public PlainDataNode() {
            super(XMLDataObject.this, Children.LEAF);
            this.setIconBaseWithExtension("org/openide/loaders/xmlObject.gif");
        }

        public Action getPreferredAction() {
            return SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = XMLDataObject.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction));
        }
    }

    private static final class InfoLkp
    extends AbstractLookup {
        public final Info info;

        public InfoLkp(XMLDataObject xMLDataObject, Info info) {
            this.info = info;
            Iterator iterator = info.processorClasses();
            ArrayList<InfoPair> arrayList = new ArrayList<InfoPair>(info.processors.size());
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                arrayList.add(new InfoPair(xMLDataObject, clazz));
            }
            this.setPairs(arrayList);
        }

        private static final class InfoPair
        extends AbstractLookup.Pair {
            private Class clazz;
            private Object obj;

            protected InfoPair(XMLDataObject xMLDataObject, Class clazz) {
                this.obj = xMLDataObject;
                this.clazz = clazz;
            }

            protected boolean instanceOf(Class clazz) {
                Class clazz2 = this.clazz;
                if (clazz2 == null) {
                    return clazz.isInstance(this.obj);
                }
                return clazz.isAssignableFrom(clazz2);
            }

            protected boolean creatorOf(Object object) {
                return this.obj == object;
            }

            public synchronized Object getInstance() {
                if (this.clazz == null) {
                    return this.obj;
                }
                XMLDataObject xMLDataObject = (XMLDataObject)this.obj;
                this.obj = null;
                Class clazz = this.clazz;
                this.clazz = null;
                try {
                    if ((class$org$openide$loaders$XMLDataObject$Processor == null ? (class$org$openide$loaders$XMLDataObject$Processor = XMLDataObject.class$("org.openide.loaders.XMLDataObject$Processor")) : class$org$openide$loaders$XMLDataObject$Processor).isAssignableFrom(clazz)) {
                        this.obj = clazz.newInstance();
                        Processor processor = (Processor)this.obj;
                        processor.attachTo(xMLDataObject);
                        return this.obj;
                    }
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    for (int i = 0; i < constructorArray.length; ++i) {
                        Class<?>[] classArray = constructorArray[i].getParameterTypes();
                        if (classArray.length != 1 || classArray[0] != (class$org$openide$loaders$DataObject == null ? XMLDataObject.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) && classArray[0] != (class$org$openide$loaders$XMLDataObject == null ? XMLDataObject.class$("org.openide.loaders.XMLDataObject") : class$org$openide$loaders$XMLDataObject)) continue;
                        this.obj = constructorArray[i].newInstance(xMLDataObject);
                        return this.obj;
                    }
                    throw new InternalError("XMLDataObject processor class " + clazz + " invalid");
                }
                catch (InvocationTargetException invocationTargetException) {
                    xMLDataObject.notifyEx(invocationTargetException);
                }
                catch (InstantiationException instantiationException) {
                    xMLDataObject.notifyEx(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    xMLDataObject.notifyEx(illegalAccessException);
                }
                return this.obj;
            }

            public Class getType() {
                Class<?> clazz = this.clazz;
                return clazz != null ? clazz : this.obj.getClass();
            }

            public String getId() {
                return "Info[" + this.getType().getName();
            }

            public String getDisplayName() {
                return this.getType().getName();
            }
        }
    }

    public static final class Info
    implements Cloneable {
        List processors = new ArrayList();
        String iconBase = null;

        public Object clone() {
            Info info = new Info();
            Iterator iterator = this.processors.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                info.processors.add(clazz);
            }
            info.iconBase = this.iconBase;
            return info;
        }

        public synchronized void addProcessorClass(Class clazz) {
            if (!(class$org$openide$loaders$XMLDataObject$Processor == null ? (class$org$openide$loaders$XMLDataObject$Processor = XMLDataObject.class$("org.openide.loaders.XMLDataObject$Processor")) : class$org$openide$loaders$XMLDataObject$Processor).isAssignableFrom(clazz)) {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                for (int i = 0; i < constructorArray.length; ++i) {
                    Class<?>[] classArray = constructorArray[i].getParameterTypes();
                    if (classArray.length != 1 || classArray[0] != (class$org$openide$loaders$DataObject == null ? XMLDataObject.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) && classArray[0] != (class$org$openide$loaders$XMLDataObject == null ? XMLDataObject.class$("org.openide.loaders.XMLDataObject") : class$org$openide$loaders$XMLDataObject)) continue;
                    constructorArray = null;
                    break;
                }
                if (constructorArray != null) {
                    throw new IllegalArgumentException();
                }
            }
            this.processors.add(clazz);
        }

        public boolean removeProcessorClass(Class clazz) {
            return this.processors.remove(clazz);
        }

        public Iterator processorClasses() {
            return this.processors.iterator();
        }

        public void setIconBase(String string) {
            this.iconBase = string;
        }

        public String getIconBase() {
            return this.iconBase;
        }

        public void write(Writer writer) throws IOException {
            throw new IOException("Not supported anymore");
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Info)) {
                return false;
            }
            Info info = (Info)object;
            return (this.iconBase != null && this.iconBase.equals(info.iconBase) || info.iconBase == this.iconBase) && ((Object)this.processors).equals(info.processors);
        }
    }

    public static interface Processor
    extends Node.Cookie {
        public void attachTo(XMLDataObject var1);
    }

    static final class Loader
    extends MultiFileLoader {
        static final long serialVersionUID = 3917883920409453930L;

        public Loader() {
            super("org.openide.loaders.XMLDataObject");
        }

        protected String actionsContext() {
            return "Loaders/text/xml/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlLoader_Name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            String string = fileObject.getMIMEType();
            if (string.endsWith("/xml") || string.endsWith("+xml")) {
                return fileObject;
            }
            return null;
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException {
            return new XMLDataObject(fileObject, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = new InputSource(new StringReader(XMLDataObject.NULL));
            inputSource.setSystemId("StringReader");
            return inputSource;
        }
    }

    private final class InfoParser
    extends DefaultHandler
    implements FileChangeListener,
    LexicalHandler,
    LookupListener {
        private String parsedId;
        private Lookup lookup;
        private Lookup.Result result;
        private ThreadLocal QUERY = new ThreadLocal();

        InfoParser() {
        }

        public String getPublicId() {
            String string = this.waitFinished();
            return string == XMLDataObject.NULL ? null : string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lookupCookie(Class clazz) {
            if (this.QUERY.get() == clazz) {
                if (LOG) {
                    ERR.log("Cyclic deps on queried class: " + clazz + " for " + XMLDataObject.this);
                }
                return new InstanceCookie(this, clazz){
                    private final /* synthetic */ Class val$clazz;
                    private final /* synthetic */ InfoParser this$1;
                    {
                        this.this$1 = infoParser;
                        this.val$clazz = clazz;
                    }

                    public Class instanceClass() {
                        return this.val$clazz;
                    }

                    public Object instanceCreate() throws IOException {
                        throw new IOException("Cyclic reference, sorry: " + this.val$clazz);
                    }

                    public String instanceName() {
                        return this.val$clazz.getName();
                    }
                };
            }
            Object t = this.QUERY.get();
            try {
                Lookup lookup;
                Object object;
                String string;
                block19: {
                    this.QUERY.set(clazz);
                    if (LOG) {
                        ERR.log("Will do query for class: " + clazz + " for " + XMLDataObject.this);
                    }
                    do {
                        string = this.waitFinished();
                        object = this;
                        synchronized (object) {
                            lookup = this.lookup != null ? this.lookup : null;
                        }
                        if (LOG) {
                            ERR.log("Lookup is " + lookup + " for id: " + string);
                        }
                        if (lookup == null) {
                            lookup = this.updateLookup(null, string);
                            if (LOG) {
                                ERR.log("Updating lookup: " + lookup);
                            }
                        }
                        if (LOG) {
                            ERR.log("Wait lookup is over: " + lookup + XMLDataObject.this);
                        }
                        if (lookup != null) break block19;
                    } while (this.parsedId != null);
                    lookup = Lookup.EMPTY;
                }
                if ((string = this.result) != null) {
                    if (LOG) {
                        ERR.log("Querying the result: " + string);
                    }
                    string.allItems();
                } else if (LOG) {
                    ERR.log("No result for lookup: " + this.lookup);
                }
                object = lookup.lookup(clazz);
                if (LOG) {
                    ERR.log("Returning value: " + object + " for " + XMLDataObject.this);
                }
                Object object2 = object;
                return object2;
            }
            finally {
                this.QUERY.set(t);
            }
        }

        public String waitFinished() {
            return this.waitFinished(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String waitFinished(String var1_1) {
            if (XMLDataObject.access$500() == null) {
                XMLDataObject.access$400().log("No sharedParserImpl, exiting");
                return "";
            }
            var2_2 = XMLDataObject.access$500();
            var3_3 = XMLDataObject.this.getPrimaryFile();
            var4_4 = null;
            if (XMLDataObject.access$300()) {
                XMLDataObject.access$400().log("Going to read parsedId for " + XMLDataObject.this);
            }
            var6_5 = this;
            synchronized (var6_5) {
                var5_6 = this.parsedId;
                ** if (var5_6 == null) goto lbl16
            }
lbl-1000:
            // 1 sources

            {
                if (XMLDataObject.access$300() == false) return var5_6;
                XMLDataObject.access$400().log("Has already been parsed: " + this.parsedId + " for " + XMLDataObject.this);
                return var5_6;
            }
lbl16:
            // 1 sources

            var6_5 = null;
            var7_7 = null;
            try {
                var6_5 = var3_3.getURL();
            }
            catch (IOException var8_8) {
                this.warning(var8_8, "I/O exception while retrieving xml FileObject URL.");
                return "";
            }
            var8_9 = this;
            synchronized (var8_9) {
                block70: {
                    block58: {
                        block68: {
                            block69: {
                                block53: {
                                    block59: {
                                        block52: {
                                            try {
                                                if (!var3_3.isValid()) {
                                                    if (XMLDataObject.access$300()) {
                                                        XMLDataObject.access$400().log("Invalid file object: " + var3_3);
                                                    }
                                                    var9_10 = "";
                                                    var16_17 = null;
                                                    break block52;
                                                }
                                                this.parsedId = "";
                                                if (XMLDataObject.access$300()) {
                                                    XMLDataObject.access$400().log("parsedId set to NULL for " + XMLDataObject.this);
                                                }
                                                try {
                                                    var7_7 = var3_3.getInputStream();
                                                    break block53;
                                                }
                                                catch (IOException var9_11) {
                                                    this.warning(var9_11, "I/O exception while openning xml.");
                                                    var10_25 = "";
                                                    var16_18 = null;
                                                    try {
                                                        if (var7_7 == null) return var10_25;
                                                        var7_7.close();
                                                    }
                                                    catch (IOException var17_22) {
                                                        v0 = XMLDataObject.access$400();
                                                        XMLDataObject.access$400();
                                                        v0.notify(1, (Throwable)var17_22);
                                                    }
                                                    return var10_25;
                                                }
                                            }
                                            catch (Throwable var15_42) {
                                                var16_20 = null;
                                                ** try [egrp 11[TRYBLOCK] [22 : 762->775)] { 
lbl60:
                                                // 1 sources

                                                if (var7_7 == null) throw var15_42;
                                                var7_7.close();
                                                throw var15_42;
lbl63:
                                                // 1 sources

                                                catch (IOException var17_24) {
                                                    v1 = XMLDataObject.access$400();
                                                    XMLDataObject.access$400();
                                                    v1.notify(1, (Throwable)var17_24);
                                                }
                                                throw var15_42;
                                            }
                                        }
                                        ** try [egrp 11[TRYBLOCK] [22 : 762->775)] { 
lbl71:
                                        // 1 sources

                                        if (var7_7 == null) return var9_10;
                                        var7_7.close();
                                        break block59;
lbl74:
                                        // 1 sources

                                        catch (IOException var17_21) {
                                            v2 = XMLDataObject.access$400();
                                            XMLDataObject.access$400();
                                            v2.notify(1, (Throwable)var17_21);
                                        }
                                    }
                                    return var9_10;
                                }
                                try {
                                    block55: {
                                        try {
                                            var9_12 = XMLDataObject.access$500();
                                            synchronized (var9_12) {
                                                this.configureParser(var2_2, false, this);
                                                var2_2.setContentHandler(this);
                                                var2_2.setErrorHandler(this);
                                                var10_26 = new InputSource(var6_5.toExternalForm());
                                                var10_26.setByteStream(var7_7);
                                                var2_2.parse(var10_26);
                                                if (!XMLDataObject.access$300()) break block55;
                                            }
                                            XMLDataObject.access$400().log("Parse finished for " + XMLDataObject.this);
                                        }
                                        catch (StopSaxException var9_13) {
                                            var4_4 = this.parsedId;
                                            XMLDataObject.access$400().log("Parsing successfully stopped: " + this.parsedId + " for " + XMLDataObject.this);
                                            var13_29 = null;
                                            if (Boolean.getBoolean("netbeans.profile.memory")) {
                                                var2_2.setContentHandler(NullHandler.INSTANCE);
                                                var2_2.setErrorHandler(NullHandler.INSTANCE);
                                                try {
                                                    var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                }
                                                catch (SAXException var14_35 /* !! */ ) {
                                                    // empty catch block
                                                }
                                                try {
                                                    var2_2.parse((InputSource)null);
                                                }
                                                catch (Exception var14_35 /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            var2_2 = null;
                                            break block58;
                                        }
                                        catch (SAXException var9_14) {
                                            block60: {
                                                block61: {
                                                    if (XMLDataObject.access$600().getMessage().equals(var9_14.getMessage())) {
                                                        var4_4 = this.parsedId;
                                                        XMLDataObject.access$400().log("Parsing stopped with STOP message: " + this.parsedId + " for " + XMLDataObject.this);
                                                    } else {
                                                        var10_27 = "Thread:" + Thread.currentThread().getName();
                                                        XMLDataObject.access$400().annotate((Throwable)var9_14, "DocListener should not throw SAXException but STOP one.\n" + var10_27);
                                                        v3 = XMLDataObject.access$400();
                                                        XMLDataObject.access$400();
                                                        v3.notify(1, (Throwable)var9_14);
                                                        var11_40 = var9_14.getException();
                                                        if (var11_40 != null) {
                                                            v4 = XMLDataObject.access$400();
                                                            XMLDataObject.access$400();
                                                            v4.notify(1, (Throwable)var11_40);
                                                        }
                                                    }
                                                    var13_30 = null;
                                                    if (!Boolean.getBoolean("netbeans.profile.memory")) break block60;
                                                    var2_2.setContentHandler(NullHandler.INSTANCE);
                                                    var2_2.setErrorHandler(NullHandler.INSTANCE);
                                                    ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl141:
                                                    // 1 sources

                                                    var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                    break block61;
lbl143:
                                                    // 1 sources

                                                    catch (SAXException var14_36 /* !! */ ) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl147:
                                                // 1 sources

                                                var2_2.parse((InputSource)null);
                                                break block60;
lbl149:
                                                // 1 sources

                                                catch (Exception var14_36 /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            var2_2 = null;
                                            break block58;
                                        }
                                        catch (FileNotFoundException var9_15) {
                                            block62: {
                                                block63: {
                                                    v5 = XMLDataObject.access$400();
                                                    XMLDataObject.access$400();
                                                    v5.notify(1, (Throwable)var9_15);
                                                    var13_31 = null;
                                                    if (!Boolean.getBoolean("netbeans.profile.memory")) break block62;
                                                    var2_2.setContentHandler(NullHandler.INSTANCE);
                                                    var2_2.setErrorHandler(NullHandler.INSTANCE);
                                                    ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl165:
                                                    // 1 sources

                                                    var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                    break block63;
lbl167:
                                                    // 1 sources

                                                    catch (SAXException var14_37 /* !! */ ) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl171:
                                                // 1 sources

                                                var2_2.parse((InputSource)null);
                                                break block62;
lbl173:
                                                // 1 sources

                                                catch (Exception var14_37 /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            var2_2 = null;
                                            break block58;
                                        }
                                        catch (IOException var9_16) {
                                            block64: {
                                                block65: {
                                                    v6 = XMLDataObject.access$400();
                                                    XMLDataObject.access$400();
                                                    v6.notify(1, (Throwable)var9_16);
                                                    var13_32 = null;
                                                    if (!Boolean.getBoolean("netbeans.profile.memory")) break block64;
                                                    var2_2.setContentHandler(NullHandler.INSTANCE);
                                                    var2_2.setErrorHandler(NullHandler.INSTANCE);
                                                    ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl189:
                                                    // 1 sources

                                                    var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                    break block65;
lbl191:
                                                    // 1 sources

                                                    catch (SAXException var14_38 /* !! */ ) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl195:
                                                // 1 sources

                                                var2_2.parse((InputSource)null);
                                                break block64;
lbl197:
                                                // 1 sources

                                                catch (Exception var14_38 /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            var2_2 = null;
                                            break block58;
                                        }
                                    }
                                    var13_28 = null;
                                }
                                catch (Throwable var12_41) {
                                    block66: {
                                        block67: {
                                            var13_33 = null;
                                            if (!Boolean.getBoolean("netbeans.profile.memory")) break block66;
                                            var2_2.setContentHandler(NullHandler.INSTANCE);
                                            var2_2.setErrorHandler(NullHandler.INSTANCE);
                                            ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl212:
                                            // 1 sources

                                            var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                            break block67;
lbl214:
                                            // 1 sources

                                            catch (SAXException var14_39 /* !! */ ) {
                                                // empty catch block
                                            }
                                        }
                                        ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl218:
                                        // 1 sources

                                        var2_2.parse((InputSource)null);
                                        break block66;
lbl220:
                                        // 1 sources

                                        catch (Exception var14_39 /* !! */ ) {
                                            // empty catch block
                                        }
                                    }
                                    var2_2 = null;
                                    throw var12_41;
                                }
                                if (!Boolean.getBoolean("netbeans.profile.memory")) break block68;
                                var2_2.setContentHandler(NullHandler.INSTANCE);
                                var2_2.setErrorHandler(NullHandler.INSTANCE);
                                ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl229:
                                // 1 sources

                                var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                break block69;
lbl231:
                                // 1 sources

                                catch (SAXException var14_34 /* !! */ ) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl235:
                            // 1 sources

                            var2_2.parse((InputSource)null);
                            break block68;
lbl237:
                            // 1 sources

                            catch (Exception var14_34 /* !! */ ) {
                                // empty catch block
                            }
                        }
                        var2_2 = null;
                    }
                    var16_19 = null;
                    ** try [egrp 11[TRYBLOCK] [22 : 762->775)] { 
lbl244:
                    // 1 sources

                    if (var7_7 != null) {
                        var7_7.close();
                    }
                    break block70;
lbl248:
                    // 1 sources

                    catch (IOException var17_23) {
                        v7 = XMLDataObject.access$400();
                        XMLDataObject.access$400();
                        v7.notify(1, (Throwable)var17_23);
                    }
                }
                ** if (var1_1 == null || !var4_4.equals((Object)var1_1)) goto lbl258
            }
lbl-1000:
            // 1 sources

            {
                if (XMLDataObject.access$300() == false) return var4_4;
                XMLDataObject.access$400().log("No update to ID: " + var1_1 + " for " + XMLDataObject.this);
                return var4_4;
            }
lbl258:
            // 1 sources

            if (XMLDataObject.access$300()) {
                XMLDataObject.access$400().log("New id: " + var4_4 + " for " + XMLDataObject.this);
            }
            if (var4_4 == null) return var4_4;
            this.updateLookup(var5_6, var4_4);
            return var4_4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup updateLookup(String string, String string2) {
            InfoParser infoParser = this;
            synchronized (infoParser) {
                if (string != null && string.equals(string2) && this.lookup != null) {
                    ERR.log("No need to update lookup: " + string2 + " for " + XMLDataObject.this);
                    return this.lookup;
                }
            }
            Info info = XMLDataObject.getRegisteredInfo(string2);
            if (info != null) {
                infoParser = XMLDataObject.createInfoLookup(XMLDataObject.this, info);
                if (LOG) {
                    ERR.log("Lookup from info: " + infoParser + " for " + XMLDataObject.this);
                }
            } else {
                infoParser = Environment.findForOne(XMLDataObject.this);
                if (LOG) {
                    ERR.log("Lookup from env: " + infoParser + " for " + XMLDataObject.this);
                }
                if (infoParser == null) {
                    infoParser = Lookup.EMPTY;
                }
            }
            InfoParser infoParser2 = this;
            synchronized (infoParser2) {
                Lookup.Result result = this.result;
                this.lookup = infoParser;
                if (LOG) {
                    ERR.log("Shared lookup updated: " + this.lookup + " for " + XMLDataObject.this);
                }
                this.result = this.lookup.lookup(TEMPLATE);
                this.result.addLookupListener((LookupListener)this);
                if (result != null) {
                    result.removeLookupListener((LookupListener)this);
                    if (LOG) {
                        ERR.log("Firing property change for " + XMLDataObject.this);
                    }
                    XMLDataObject.this.firePropertyChange("cookie", null, null);
                    if (LOG) {
                        ERR.log("Firing done for " + XMLDataObject.this);
                    }
                }
                return infoParser;
            }
        }

        private void configureParser(XMLReader xMLReader, boolean bl, LexicalHandler lexicalHandler) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
            }
            catch (SAXException sAXException) {
                ERR.log("Warning: XML parser does not support validation feature.");
            }
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            }
            catch (SAXException sAXException) {
                ERR.log("Warning: XML parser does not support lexical-handler feature.");
            }
        }

        public void warning(Throwable throwable) {
            this.warning(throwable, null);
        }

        public void warning(Throwable throwable, String string) {
            ErrorManager errorManager = ERR;
            if (string != null) {
                errorManager.annotate(throwable, string);
            }
            errorManager.notify(1, throwable);
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.parsedId = string2 == null ? XMLDataObject.NULL : string2;
            ERR.log("Parsed to " + this.parsedId);
            this.stop();
        }

        public void endDTD() throws SAXException {
            this.stop();
        }

        public void startEntity(String string) throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.stop();
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.stop();
        }

        public void endDocument() throws SAXException {
            this.stop();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.stop();
        }

        private void stop() throws SAXException {
            throw STOP;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        private void fileCreated(FileObject fileObject) {
        }

        public void fileChanged(FileEvent fileEvent) {
            if (XMLDataObject.this.getPrimaryFile().equals(fileEvent.getFile())) {
                XMLDataObject.this.clearDocument();
                String string = this.parsedId;
                this.parsedId = null;
                ERR.log("cleared parsedId");
                this.waitFinished(string);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            XMLDataObject.this.firePropertyChange("cookie", null, null);
            Node node = XMLDataObject.this.getNodeDelegateOrNull();
            if (node instanceof XMLNode) {
                ((XMLNode)node).update();
            }
        }
    }

    private static class NullHandler
    extends DefaultHandler
    implements LexicalHandler {
        static final NullHandler INSTANCE = new NullHandler();

        NullHandler() {
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }

    static class ErrorPrinter
    implements ErrorHandler {
        ErrorPrinter() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            ErrorManager errorManager = ErrorManager.getDefault().getInstance("org.openide.loaders.XMLDataObject");
            if (!errorManager.isLoggable(1)) {
                return;
            }
            String string2 = NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlMessage", (Object[])new Object[]{string, sAXParseException.getMessage(), sAXParseException.getSystemId() == null ? XMLDataObject.NULL : sAXParseException.getSystemId(), XMLDataObject.NULL + sAXParseException.getLineNumber(), XMLDataObject.NULL + sAXParseException.getColumnNumber()});
            errorManager.log(string2);
        }

        public void error(SAXParseException sAXParseException) {
            this.message(NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlError"), sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) {
            this.message(NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlWarning"), sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.message(NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlFatalError"), sAXParseException);
        }
    }

    private static class XMLEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditorCookie.Observable,
    PrintCookie,
    CloseCookie {
        public XMLEditorSupport(XMLDataObject xMLDataObject) {
            super(xMLDataObject, new XMLEditorEnv(xMLDataObject));
            this.setMIMEType(XMLDataObject.MIME);
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            if (this.getDataObject().getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = XMLDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
                ((XMLDataObject)this.getDataObject()).addSaveCookie(new Save());
                this.getDataObject().setModified(true);
            }
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            SaveCookie saveCookie = (SaveCookie)this.getDataObject().getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = XMLDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (saveCookie != null) {
                ((XMLDataObject)this.getDataObject()).removeSaveCookie(saveCookie);
                this.getDataObject().setModified(false);
            }
        }

        private static class XMLEditorEnv
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = 6593415381104273008L;

            public XMLEditorEnv(DataObject dataObject) {
                super(dataObject);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((XMLDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = XMLDataObject.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            }
        }

        class Save
        implements SaveCookie {
            Save() {
            }

            public void save() throws IOException {
                XMLEditorSupport.this.saveDocument();
                XMLEditorSupport.this.getDataObject().setModified(false);
            }
        }
    }
}

