/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.SecuritySupport;

public class MailcapCommandMap
extends CommandMap {
    private static MailcapFile defDB = null;
    private MailcapFile[] DB;
    private static final int PROG = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapCommandMap() {
        Object object;
        Vector<MailcapFile> vector = new Vector<MailcapFile>(5);
        MailcapFile mailcapFile = null;
        vector.addElement(null);
        LogSupport.log("MailcapCommandMap: load HOME");
        try {
            String string;
            object = System.getProperty("user.home");
            if (object != null && (mailcapFile = this.loadFile(string = (String)object + File.separator + ".mailcap")) != null) {
                vector.addElement(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MailcapCommandMap: load SYS");
        try {
            object = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mailcap";
            mailcapFile = this.loadFile((String)object);
            if (mailcapFile != null) {
                vector.addElement(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MailcapCommandMap: load JAR");
        this.loadAllResources(vector, "META-INF/mailcap");
        LogSupport.log("MailcapCommandMap: load DEF");
        object = MailcapCommandMap.class;
        synchronized (object) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mailcap.default");
            }
        }
        if (defDB != null) {
            vector.addElement(defDB);
        }
        this.DB = new MailcapFile[vector.size()];
        vector.copyInto(this.DB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private MailcapFile loadResource(String string) {
        block23: {
            InputStream inputStream;
            block22: {
                block20: {
                    inputStream = null;
                    inputStream = SecuritySupport.getInstance().getResourceAsStream(this.getClass(), string);
                    if (inputStream == null) break block20;
                    MailcapFile mailcapFile = new MailcapFile(inputStream);
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: successfully loaded mailcap file: " + string);
                    }
                    MailcapFile mailcapFile2 = mailcapFile;
                    Object var6_7 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return mailcapFile2;
                }
                if (!LogSupport.isLoggable()) break block22;
                LogSupport.log("MailcapCommandMap: not loading mailcap file: " + string);
            }
            Object var6_8 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block23;
            }
            catch (IOException iOException) {}
            break block23;
            {
                catch (IOException iOException) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: can't load " + string, iOException);
                    }
                    Object var6_9 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block23;
                    }
                    catch (IOException iOException2) {}
                    break block23;
                }
                catch (SecurityException securityException) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: can't load " + string, securityException);
                    }
                    Object var6_10 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block23;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadAllResources(Vector vector, String string) {
        Object object;
        boolean bl;
        block24: {
            bl = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getInstance().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object = classLoader != null ? SecuritySupport.getInstance().getResources(classLoader, string) : SecuritySupport.getInstance().getSystemResources(string)) == null) break block24;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapCommandMap: getResources");
                }
                for (int i = 0; i < ((URL[])object).length; ++i) {
                    InputStream inputStream;
                    URL uRL;
                    block25: {
                        uRL = object[i];
                        inputStream = null;
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("MailcapCommandMap: URL " + uRL);
                        }
                        inputStream = SecuritySupport.getInstance().openStream(uRL);
                        if (inputStream != null) {
                            vector.addElement(new MailcapFile(inputStream));
                            bl = true;
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MailcapCommandMap: successfully loaded mailcap file from URL: " + uRL);
                            }
                            break block25;
                        }
                        if (!LogSupport.isLoggable()) break block25;
                        LogSupport.log("MailcapCommandMap: not loading mailcap file from URL: " + uRL);
                    }
                    Object var11_13 = null;
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                    {
                        catch (IOException iOException) {
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MailcapCommandMap: can't load " + uRL, iOException);
                            }
                            var11_13 = null;
                            try {
                                if (inputStream == null) continue;
                                inputStream.close();
                            }
                            catch (IOException iOException2) {}
                            continue;
                        }
                        catch (SecurityException securityException) {
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MailcapCommandMap: can't load " + uRL, securityException);
                            }
                            var11_13 = null;
                            try {
                                if (inputStream == null) continue;
                                inputStream.close();
                            }
                            catch (IOException iOException2) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var11_13 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block24;
                LogSupport.log("MailcapCommandMap: can't load " + string, exception);
            }
        }
        if (!bl) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: !anyLoaded");
            }
            if ((object = this.loadResource("/" + string)) != null) {
                vector.addElement(object);
            }
        }
    }

    private MailcapFile loadFile(String string) {
        MailcapFile mailcapFile = null;
        try {
            mailcapFile = new MailcapFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mailcapFile;
    }

    public MailcapCommandMap(String string) throws IOException {
        this();
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: load PROG from " + string);
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(string);
        }
    }

    public MailcapCommandMap(InputStream inputStream) {
        this();
        LogSupport.log("MailcapCommandMap: load PROG");
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.DB.length; ++i) {
            Hashtable hashtable;
            if (this.DB[i] == null || (hashtable = this.DB[i].getMailcapList(string)) == null) continue;
            this.appendPrefCmdsToVector(hashtable, vector);
        }
        Object[] objectArray = new CommandInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void appendPrefCmdsToVector(Hashtable hashtable, Vector vector) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.checkForVerb(vector, string)) continue;
            Vector vector2 = (Vector)hashtable.get(string);
            String string2 = (String)vector2.firstElement();
            vector.addElement(new CommandInfo(string, string2));
        }
    }

    private boolean checkForVerb(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = ((CommandInfo)enumeration.nextElement()).getCommandName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized CommandInfo[] getAllCommands(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.DB.length; ++i) {
            Hashtable hashtable;
            if (this.DB[i] == null || (hashtable = this.DB[i].getMailcapList(string)) == null) continue;
            this.appendCmdsToVector(hashtable, vector);
        }
        Object[] objectArray = new CommandInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void appendCmdsToVector(Hashtable hashtable, Vector vector) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(string);
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                vector.insertElementAt(new CommandInfo(string, string2), 0);
            }
        }
    }

    public synchronized CommandInfo getCommand(String string, String string2) {
        for (int i = 0; i < this.DB.length; ++i) {
            String string3;
            Vector vector;
            Hashtable hashtable;
            if (this.DB[i] == null || (hashtable = this.DB[i].getMailcapList(string)) == null || (vector = (Vector)hashtable.get(string2)) == null || (string3 = (String)vector.firstElement()) == null) continue;
            return new CommandInfo(string2, string3);
        }
        return null;
    }

    public synchronized void addMailcap(String string) {
        LogSupport.log("MailcapCommandMap: add to PROG");
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(string);
    }

    public synchronized DataContentHandler createDataContentHandler(String string) {
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: createDataContentHandler for " + string);
        }
        for (int i = 0; i < this.DB.length; ++i) {
            Vector vector;
            Hashtable hashtable;
            if (this.DB[i] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search DB #" + i);
            }
            if ((hashtable = this.DB[i].getMailcapList(string)) == null || (vector = (Vector)hashtable.get("content-handler")) == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("    got content-handler");
            }
            String string2 = (String)vector.firstElement();
            if (LogSupport.isLoggable()) {
                LogSupport.log("      class " + string2);
            }
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getInstance().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(string2);
                }
                catch (Exception exception) {
                    clazz = Class.forName(string2);
                }
                if (clazz == null) continue;
                return (DataContentHandler)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!LogSupport.isLoggable()) continue;
                LogSupport.log("Can't load DCH " + string2, illegalAccessException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!LogSupport.isLoggable()) continue;
                LogSupport.log("Can't load DCH " + string2, classNotFoundException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                if (!LogSupport.isLoggable()) continue;
                LogSupport.log("Can't load DCH " + string2, instantiationException);
            }
        }
        return null;
    }
}

