/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

public final class AttachingDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-AttachingDICookie";
    private AttachingConnector attachingConnector;
    private Map args;

    private AttachingDICookie(AttachingConnector attachingConnector, Map map) {
        this.attachingConnector = attachingConnector;
        this.args = map;
    }

    public static AttachingDICookie create(AttachingConnector attachingConnector, Map map) {
        return new AttachingDICookie(attachingConnector, map);
    }

    public static AttachingDICookie create(String string, int n) {
        return new AttachingDICookie(AttachingDICookie.findAttachingConnector("socket"), AttachingDICookie.getArgs(AttachingDICookie.findAttachingConnector("socket"), string, n));
    }

    public static AttachingDICookie create(String string) {
        return new AttachingDICookie(AttachingDICookie.findAttachingConnector("shmem"), AttachingDICookie.getArgs(AttachingDICookie.findAttachingConnector("shmem"), string));
    }

    public AttachingConnector getAttachingConnector() {
        return this.attachingConnector;
    }

    public Map getArgs() {
        return this.args;
    }

    public int getPortNumber() {
        Connector.Argument argument = (Connector.Argument)this.args.get("port");
        if (argument == null) {
            return -1;
        }
        String string = argument.value();
        if (string == null) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    public String getHostName() {
        Connector.Argument argument = (Connector.Argument)this.args.get("hostname");
        if (argument == null) {
            return null;
        }
        return argument.value();
    }

    public String getSharedMemoryName() {
        Connector.Argument argument = (Connector.Argument)this.args.get("name");
        if (argument == null) {
            return null;
        }
        return argument.value();
    }

    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException {
        return this.attachingConnector.attach(this.args);
    }

    private static Map getArgs(AttachingConnector attachingConnector, String string, int n) {
        Map<String, Connector.Argument> map = attachingConnector.defaultArguments();
        map.get("hostname").setValue(string);
        map.get("port").setValue("" + n);
        return map;
    }

    private static Map getArgs(AttachingConnector attachingConnector, String string) {
        Map<String, Connector.Argument> map = attachingConnector.defaultArguments();
        map.get("name").setValue(string);
        return map;
    }

    private static AttachingConnector findAttachingConnector(String string) {
        Iterator<AttachingConnector> iterator = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        while (iterator.hasNext()) {
            AttachingConnector attachingConnector = iterator.next();
            if (attachingConnector.transport() == null || attachingConnector.transport().name().toLowerCase().indexOf(string) <= -1) continue;
            return attachingConnector;
        }
        return null;
    }
}

