/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import org.netbeans.api.debugger.jpda.JPDABreakpoint;

public class LineBreakpoint
extends JPDABreakpoint {
    public static final String PROP_LINE_NUMBER = new String("lineNumber");
    public static final String PROP_URL = new String("url");
    public static final String PROP_CONDITION = new String("condition");
    public static final String PROP_SOURCE_NAME = new String("sourceName");
    public static final String PROP_SOURCE_PATH = new String("sourcePath");
    public static final String PROP_STRATUM = new String("stratum");
    private String url = "";
    private int lineNumber;
    private String condition = "";
    private String sourceName = null;
    private String sourcePath = null;
    private String stratum = "Java";

    private LineBreakpoint() {
    }

    public static LineBreakpoint create(String string, int n) {
        LineBreakpointImpl lineBreakpointImpl = new LineBreakpointImpl();
        lineBreakpointImpl.setURL(string);
        lineBreakpointImpl.setLineNumber(n);
        return lineBreakpointImpl;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string == null) {
                string = "";
            }
            if (string == this.url || string != null && this.url != null && string.equals(this.url)) {
                return;
            }
            string2 = string;
            this.url = string;
        }
        this.firePropertyChange(PROP_URL, string2, string);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int n) {
        int n2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (n == this.lineNumber) {
                return;
            }
            n2 = this.lineNumber;
            this.lineNumber = n;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(n2), new Integer(n));
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()) == this.condition || string != null && this.condition != null && this.condition.equals(string)) {
                return;
            }
            string2 = this.condition;
            this.condition = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getStratum() {
        return this.stratum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStratum(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()) == this.stratum || string != null && this.stratum != null && this.stratum.equals(string)) {
                return;
            }
            string2 = this.stratum;
            this.stratum = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceName(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string != null) {
                string = string.trim();
            }
            if (string == this.sourceName || string != null && this.sourceName != null && this.sourceName.equals(string)) {
                return;
            }
            string2 = this.sourceName;
            this.sourceName = string;
        }
        this.firePropertyChange(PROP_SOURCE_NAME, string2, string);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourcePath(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string != null) {
                string = string.trim();
            }
            if (string == this.sourcePath || string != null && string.equals(this.sourcePath)) {
                return;
            }
            string2 = this.sourcePath;
            this.sourcePath = string;
        }
        this.firePropertyChange(PROP_SOURCE_PATH, string2, string);
    }

    public String toString() {
        return "LineBreakpoint " + this.url + " : " + this.lineNumber;
    }

    private static class LineBreakpointImpl
    extends LineBreakpoint
    implements Comparable {
        public int compareTo(Object object) {
            if (object instanceof LineBreakpointImpl) {
                LineBreakpointImpl lineBreakpointImpl = this;
                LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
                int n = ((LineBreakpoint)lineBreakpointImpl).url.compareTo(lineBreakpoint.url);
                if (n != 0) {
                    return n;
                }
                return ((LineBreakpoint)lineBreakpointImpl).lineNumber - lineBreakpoint.lineNumber;
            }
            return -1;
        }
    }
}

