/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

public final class ListeningDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-ListeningDICookie";
    private ListeningConnector listeningConnector;
    private Map args;

    private ListeningDICookie(ListeningConnector listeningConnector, Map map) {
        this.listeningConnector = listeningConnector;
        this.args = map;
    }

    public static ListeningDICookie create(ListeningConnector listeningConnector, Map map) {
        return new ListeningDICookie(listeningConnector, map);
    }

    public static ListeningDICookie create(int n) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), n));
    }

    public static ListeningDICookie create(String string) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), string));
    }

    private static ListeningConnector findListeningConnector(String string) {
        Iterator<ListeningConnector> iterator = Bootstrap.virtualMachineManager().listeningConnectors().iterator();
        while (iterator.hasNext()) {
            ListeningConnector listeningConnector = iterator.next();
            if (listeningConnector.transport() == null || listeningConnector.transport().name().toLowerCase().indexOf(string) <= -1) continue;
            return listeningConnector;
        }
        return null;
    }

    private static Map getArgs(ListeningConnector listeningConnector, int n) {
        Map<String, Connector.Argument> map = listeningConnector.defaultArguments();
        map.get("port").setValue("" + n);
        return map;
    }

    private static Map getArgs(ListeningConnector listeningConnector, String string) {
        Map<String, Connector.Argument> map = listeningConnector.defaultArguments();
        map.get("name").setValue(string);
        return map;
    }

    public ListeningConnector getListeningConnector() {
        return this.listeningConnector;
    }

    public Map getArgs() {
        return this.args;
    }

    public int getPortNumber() {
        Connector.Argument argument = (Connector.Argument)this.args.get("port");
        if (argument == null) {
            return -1;
        }
        String string = argument.value();
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getSharedMemoryName() {
        Connector.Argument argument = (Connector.Argument)this.args.get("name");
        if (argument == null) {
            return null;
        }
        return argument.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException {
        try {
            try {
                this.listeningConnector.startListening(this.args);
            }
            catch (Exception exception) {
                // empty catch block
            }
            VirtualMachine virtualMachine = this.listeningConnector.accept(this.args);
            return virtualMachine;
        }
        finally {
            try {
                this.listeningConnector.stopListening(this.args);
            }
            catch (Exception exception) {}
        }
    }
}

