/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import org.netbeans.api.debugger.jpda.JPDABreakpoint;

public final class MethodBreakpoint
extends JPDABreakpoint {
    public static final String PROP_METHOD_NAME = "methodName";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointtType";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final int TYPE_METHOD_ENTRY = 1;
    public static final int TYPE_METHOD_EXIT = 2;
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];
    private String methodName = "";
    private int breakpointType = 1;
    private String condition = "";

    private MethodBreakpoint() {
    }

    public static MethodBreakpoint create(String string, String string2) {
        MethodBreakpoint methodBreakpoint = new MethodBreakpoint();
        methodBreakpoint.setClassFilters(new String[]{string});
        methodBreakpoint.setMethodName(string2);
        return methodBreakpoint;
    }

    public static MethodBreakpoint create() {
        MethodBreakpoint methodBreakpoint = new MethodBreakpoint();
        return methodBreakpoint;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.methodName || string != null && this.methodName != null && this.methodName.equals(string)) {
            return;
        }
        String string2 = this.methodName;
        this.methodName = string;
        this.firePropertyChange(PROP_METHOD_NAME, string2, string);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = this.condition;
        this.condition = string;
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public int getBreakpointType() {
        return this.breakpointType;
    }

    public void setBreakpointType(int n) {
        if (n == this.breakpointType) {
            return;
        }
        if ((n & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.breakpointType;
        this.breakpointType = n;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, new Integer(n2), new Integer(n));
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] stringArray) {
        if (stringArray == this.classFilters) {
            return;
        }
        String[] stringArray2 = this.classFilters;
        this.classFilters = stringArray;
        this.firePropertyChange(PROP_CLASS_FILTERS, stringArray2, stringArray);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] stringArray) {
        if (stringArray == this.classExclusionFilters) {
            return;
        }
        String[] stringArray2 = this.classExclusionFilters;
        this.classExclusionFilters = stringArray;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, stringArray2, stringArray);
    }

    public String toString() {
        return "MethodBreakpoint " + this.classFilters + "." + this.methodName;
    }
}

