/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class Notepad
extends JPanel {
    private static ResourceBundle resources;
    private static final String EXIT_AFTER_PAINT;
    private static boolean exitAfterFirstPaint;
    private JTextComponent editor;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private JComponent status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String exitAction = "exit";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private Action[] defaultActions = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new ExitAction(), new ShowElementTreeAction(), this.undoAction, this.redoAction};

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (exitAfterFirstPaint) {
            System.exit(0);
        }
    }

    Notepad() {
        super(true);
        Object object;
        Object object2;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.commands = new Hashtable();
        Action[] actionArray = this.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            object2 = actionArray[i];
            this.commands.put(object2.getValue("Name"), object2);
        }
        JScrollPane jScrollPane = new JScrollPane();
        object2 = jScrollPane.getViewport();
        ((Container)object2).add(this.editor);
        try {
            object = resources.getString("ViewportBackingStore");
            Boolean bl = Boolean.valueOf((String)object);
            ((JViewport)object2).setBackingStoreEnabled(bl);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.menuItems = new Hashtable();
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add("North", this.createToolbar());
        ((Container)object).add("Center", jScrollPane);
        this.add("Center", (Component)object);
        this.add("South", this.createStatusbar());
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("java.version");
            if (string.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing must be run with a 1.1.2 or higher version VM!!!");
            }
            if (stringArray.length > 0 && stringArray[0].equals(EXIT_AFTER_PAINT)) {
                exitAfterFirstPaint = true;
            }
            JFrame jFrame = new JFrame();
            jFrame.setTitle(resources.getString("Title"));
            jFrame.setBackground(Color.lightGray);
            jFrame.getContentPane().setLayout(new BorderLayout());
            Notepad notepad = new Notepad();
            jFrame.getContentPane().add("Center", notepad);
            jFrame.setJMenuBar(notepad.createMenubar());
            jFrame.addWindowListener(new AppCloser());
            jFrame.pack();
            jFrame.setSize(500, 600);
            jFrame.show();
        }
        catch (Throwable throwable) {
            System.out.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.editor.getActions(), this.defaultActions);
    }

    protected JTextComponent createEditor() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setDragEnabled(true);
        ((JComponent)jTextArea).setFont(new Font("monospaced", 0, 12));
        return jTextArea;
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    protected Frame getFrame() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String string) {
        String string2;
        JMenuItem jMenuItem = new JMenuItem(this.getResourceString(string + labelSuffix));
        URL uRL = this.getResource(string + imageSuffix);
        if (uRL != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(new ImageIcon(uRL));
        }
        if ((string2 = this.getResourceString(string + actionSuffix)) == null) {
            string2 = string;
        }
        jMenuItem.setActionCommand(string2);
        Action action = this.getAction(string2);
        if (action != null) {
            jMenuItem.addActionListener(action);
            action.addPropertyChangeListener(this.createActionChangeListener(jMenuItem));
            jMenuItem.setEnabled(action.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        this.menuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.menuItems.get(string);
    }

    protected Action getAction(String string) {
        return (Action)this.commands.get(string);
    }

    protected String getResourceString(String string) {
        String string2;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = null;
        }
        return string2;
    }

    protected URL getResource(String string) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            URL uRL = this.getClass().getResource(string2);
            return uRL;
        }
        return null;
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected Component createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = this.tokenize(this.getResourceString("toolbar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            this.toolbar.add(this.createTool(stringArray[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    protected JButton createToolbarButton(String string) {
        Action action;
        URL uRL = this.getResource(string + imageSuffix);
        JButton jButton = new JButton((Icon)new ImageIcon(uRL)){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        String string2 = this.getResourceString(string + actionSuffix);
        if (string2 == null) {
            string2 = string;
        }
        if ((action = this.getAction(string2)) != null) {
            jButton.setActionCommand(string2);
            jButton.addActionListener(action);
        } else {
            jButton.setEnabled(false);
        }
        String string3 = this.getResourceString(string + tipSuffix);
        if (string3 != null) {
            jButton.setToolTipText(string3);
        }
        return jButton;
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = this.tokenize(this.getResourceString("menubar"));
        for (int i = 0; i < stringArray.length; ++i) {
            JMenu jMenu = this.createMenu(stringArray[i]);
            if (jMenu == null) continue;
            jMenuBar.add(jMenu);
        }
        this.menubar = jMenuBar;
        return jMenuBar;
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize(this.getResourceString(string));
        JMenu jMenu = new JMenu(this.getResourceString(string + labelSuffix));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = this.createMenuItem(stringArray[i]);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    static {
        EXIT_AFTER_PAINT = new String("-exit");
        try {
            resources = ResourceBundle.getBundle("resources.Notepad", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("resources/Notepad.properties not found");
            System.exit(1);
        }
    }

    class FileSaver
    extends Thread {
        Document doc;
        File f;

        FileSaver(File file, Document document) {
            this.setPriority(4);
            this.f = file;
            this.doc = document;
        }

        @Override
        public void run() {
            try {
                Notepad.this.status.removeAll();
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setMinimum(0);
                jProgressBar.setMaximum(this.doc.getLength());
                Notepad.this.status.add(jProgressBar);
                Notepad.this.status.revalidate();
                FileWriter fileWriter = new FileWriter(this.f);
                Segment segment = new Segment();
                segment.setPartialReturn(true);
                int n = this.doc.getLength();
                int n2 = 0;
                while (n > 0) {
                    this.doc.getText(n2, Math.min(4096, n), segment);
                    ((Writer)fileWriter).write(segment.array, segment.offset, segment.count);
                    n -= segment.count;
                    jProgressBar.setValue(n2 += segment.count);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
            catch (IOException iOException) {
                final String string = iOException.getMessage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Notepad.this.getFrame(), "Could not save file: " + string, "Error saving file", 0);
                    }
                });
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException.getMessage());
            }
            Notepad.this.status.removeAll();
            Notepad.this.status.revalidate();
        }
    }

    class FileLoader
    extends Thread {
        Document doc;
        File f;

        FileLoader(File file, Document document) {
            this.setPriority(4);
            this.f = file;
            this.doc = document;
        }

        @Override
        public void run() {
            try {
                int n;
                Notepad.this.status.removeAll();
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setMinimum(0);
                jProgressBar.setMaximum((int)this.f.length());
                Notepad.this.status.add(jProgressBar);
                Notepad.this.status.revalidate();
                FileReader fileReader = new FileReader(this.f);
                char[] cArray = new char[4096];
                while ((n = ((Reader)fileReader).read(cArray, 0, cArray.length)) != -1) {
                    this.doc.insertString(this.doc.getLength(), new String(cArray, 0, n), null);
                    jProgressBar.setValue(jProgressBar.getValue() + n);
                }
            }
            catch (IOException iOException) {
                final String string = iOException.getMessage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Notepad.this.getFrame(), "Could not open file: " + string, "Error opening file", 0);
                    }
                });
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException.getMessage());
            }
            this.doc.addUndoableEditListener(Notepad.this.undoHandler);
            Notepad.this.status.removeAll();
            Notepad.this.status.revalidate();
            Notepad.this.resetUndoManager();
            if (Notepad.this.elementTreePanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Notepad.this.elementTreePanel.setEditor(Notepad.this.getEditor());
                    }
                });
            }
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(Notepad.showElementTreeAction);
        }

        ShowElementTreeAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Notepad.this.elementTreeFrame == null) {
                Object object;
                try {
                    object = resources.getString("ElementTreeFrameTitle");
                    Notepad.this.elementTreeFrame = new JFrame((String)object);
                }
                catch (MissingResourceException missingResourceException) {
                    Notepad.this.elementTreeFrame = new JFrame();
                }
                Notepad.this.elementTreeFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        Notepad.this.elementTreeFrame.setVisible(false);
                    }
                });
                object = Notepad.this.elementTreeFrame.getContentPane();
                ((Container)object).setLayout(new BorderLayout());
                Notepad.this.elementTreePanel = new ElementTreePanel(Notepad.this.getEditor());
                ((Container)object).add(Notepad.this.elementTreePanel);
                Notepad.this.elementTreeFrame.pack();
            }
            Notepad.this.elementTreeFrame.show();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Notepad.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Notepad.newAction);
        }

        NewAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Document document = Notepad.this.getEditor().getDocument();
            if (document != null) {
                document.removeUndoableEditListener(Notepad.this.undoHandler);
            }
            Notepad.this.getEditor().setDocument(new PlainDocument());
            Notepad.this.getEditor().getDocument().addUndoableEditListener(Notepad.this.undoHandler);
            Notepad.this.resetUndoManager();
            Notepad.this.getFrame().setTitle(resources.getString("Title"));
            Notepad.this.revalidate();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(Notepad.saveAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            Frame frame = Notepad.this.getFrame();
            int n = jFileChooser.showSaveDialog(frame);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            frame.setTitle(file.getName());
            FileSaver fileSaver = new FileSaver(file, Notepad.this.editor.getDocument());
            fileSaver.start();
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Notepad.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            Frame frame = Notepad.this.getFrame();
            int n = jFileChooser.showOpenDialog(frame);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file.isFile() && file.canRead()) {
                Document document = Notepad.this.getEditor().getDocument();
                if (document != null) {
                    document.removeUndoableEditListener(Notepad.this.undoHandler);
                }
                if (Notepad.this.elementTreePanel != null) {
                    Notepad.this.elementTreePanel.setEditor(null);
                }
                Notepad.this.getEditor().setDocument(new PlainDocument());
                frame.setTitle(file.getName());
                FileLoader fileLoader = new FileLoader(file, Notepad.this.editor.getDocument());
                fileLoader.start();
            } else {
                JOptionPane.showMessageDialog(Notepad.this.getFrame(), "Could not open file: " + file, "Error opening file", 0);
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Notepad.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Unable to redo: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.update();
            Notepad.this.undoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Notepad.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println("Unable to undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
            this.update();
            Notepad.this.redoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class StatusBar
    extends JComponent {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            Notepad.this.undo.addEdit(undoableEditEvent.getEdit());
            Notepad.this.undoAction.update();
            Notepad.this.redoAction.update();
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            }
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

