/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.xml.core.Util;
import org.netbeans.modules.xml.core.XMLDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;

public class XMLDataLoader
extends UniFileLoader {
    private static final long serialVersionUID = 3824119075670384804L;
    private static final String XML_EXT = "xml";
    private static final String XMLINFO_EXT = "xmlinfo";

    public XMLDataLoader() {
        super("org.netbeans.modules.xml.core.XMLDataObject");
    }

    protected void initialize() {
        super.initialize();
        ExtensionList extensionList = this.getExtensions();
        extensionList.addExtension(XML_EXT);
        extensionList.addMimeType("text/xml");
        extensionList.addMimeType("application/xml");
        this.setExtensions(extensionList);
    }

    protected String actionsContext() {
        return "Loaders/text/xml-mime/Actions/";
    }

    protected String defaultDisplayName() {
        return Util.THIS.getString("PROP_XmlLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        FileObject fileObject2 = null;
        if (super.findPrimaryFile(fileObject) != null) {
            fileObject2 = fileObject;
        } else if (XMLINFO_EXT.equals(fileObject.getExt())) {
            fileObject2 = FileUtil.findBrother((FileObject)fileObject, (String)XML_EXT);
        } else if (fileObject.getMIMEType().endsWith("+xml")) {
            fileObject2 = fileObject;
        }
        try {
            if (fileObject2 != null && fileObject2.getFileSystem().isDefault() && DataLoaderPool.getPreferredLoader((FileObject)fileObject2) != this && !XMLDataLoader.isTemplate(fileObject2)) {
                fileObject2 = null;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return fileObject2;
    }

    private static boolean isTemplate(FileObject fileObject) {
        Object object = fileObject.getAttribute("template");
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException {
        return new XMLDataObject(fileObject, (MultiFileLoader)this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new XMLFileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    public static class XMLFileEntry
    extends FileEntry.Format {
        private static final long serialVersionUID = -7300320795693949470L;
        boolean disableInputStream;
        private Collection activeReaders;

        public XMLFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Date date = new Date();
            hashMap.put("NAME", string + "." + string2);
            hashMap.put("ROOT", "root");
            hashMap.put("DATE", DateFormat.getDateInstance(1).format(date));
            hashMap.put("TIME", DateFormat.getTimeInstance(3).format(date));
            hashMap.put("USER", System.getProperty("user.name"));
            MapFormat mapFormat = new MapFormat(hashMap);
            mapFormat.setLeftBrace("__");
            mapFormat.setRightBrace("__");
            mapFormat.setExactMatch(false);
            return mapFormat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            Format format = this.createFormat(fileObject, string, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream(), "UTF8"));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock), "UTF8"));
                    try {
                        String string3;
                        String string4 = null;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            string4 = format.format(string3);
                            bufferedWriter.write(string4);
                            bufferedWriter.newLine();
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                bufferedReader.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            try {
                DataObject.find((FileObject)fileObject2).setTemplate(false);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
            return fileObject2;
        }

        private synchronized void addReader(InputStream inputStream) {
            if (this.activeReaders == null) {
                this.activeReaders = new LinkedList();
            }
            this.activeReaders.add(inputStream);
        }

        private synchronized void removeReader(InputStream inputStream) {
            if (this.activeReaders == null) {
                return;
            }
            this.activeReaders.remove(inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() throws IOException {
            XMLFileEntry xMLFileEntry = this;
            synchronized (xMLFileEntry) {
                if (this.activeReaders != null && this.activeReaders.size() > 0) {
                    Iterator iterator = this.activeReaders.iterator();
                    while (iterator.hasNext()) {
                        InputStream inputStream = (InputStream)iterator.next();
                        inputStream.close();
                        iterator.remove();
                    }
                }
                this.activeReaders = null;
                this.disableInputStream = true;
            }
            super.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws FileNotFoundException {
            FileObject fileObject = this.getFile();
            XMLFileEntry xMLFileEntry = this;
            synchronized (xMLFileEntry) {
                if (this.disableInputStream) {
                    throw new FileNotFoundException("File is being deleted.");
                }
                NotifyInputStream notifyInputStream = new NotifyInputStream(fileObject.getInputStream());
                this.addReader(notifyInputStream);
                return notifyInputStream;
            }
        }

        public FileLock takeLock() throws IOException {
            FileLock fileLock = super.takeLock();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("XMLDataLoader.XMLEntry.takeLock()/" + this.getFile() + "=" + fileLock);
            }
            return fileLock;
        }

        private class NotifyInputStream
        extends FilterInputStream {
            public NotifyInputStream(InputStream inputStream) {
                super(inputStream);
            }

            public void close() throws IOException {
                super.close();
                XMLFileEntry.this.removeReader(this);
            }
        }
    }
}

