/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.cookies;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.xml.core.cookies.CookieFactory;
import org.netbeans.modules.xml.core.cookies.CookieFactoryCreator;
import org.netbeans.modules.xml.core.lib.LookupManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.CookieSet;

public final class CookieManager
extends LookupManager {
    private final DataObject dataObject;
    private final CookieSet cookieSet;
    private final Map factoryMap;

    public CookieManager(DataObject dataObject, CookieSet cookieSet, Class clazz) {
        if (!CookieFactoryCreator.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Parameter class must extend CookieFactoryCreator class.");
        }
        this.dataObject = dataObject;
        this.cookieSet = cookieSet;
        this.factoryMap = new HashMap();
        this.register(clazz);
        this.addedToResult(this.getResult());
    }

    protected void removedFromResult(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CookieFactoryCreator cookieFactoryCreator = (CookieFactoryCreator)iterator.next();
            CookieFactory cookieFactory = (CookieFactory)this.factoryMap.remove(cookieFactoryCreator);
            if (cookieFactory == null) continue;
            cookieFactory.unregisterCookies(this.cookieSet);
        }
    }

    protected void addedToResult(Collection collection) {
        Iterator iterator = this.getResult().iterator();
        while (iterator.hasNext()) {
            CookieFactoryCreator cookieFactoryCreator = (CookieFactoryCreator)iterator.next();
            CookieFactory cookieFactory = cookieFactoryCreator.createCookieFactory(this.dataObject);
            if (cookieFactory == null) continue;
            this.factoryMap.put(cookieFactoryCreator, cookieFactory);
            cookieFactory.registerCookies(this.cookieSet);
        }
    }
}

