/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.cookies;

import java.awt.Dialog;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.xml.api.cookies.ScenarioCookie;
import org.netbeans.modules.xml.api.scenario.Scenario;
import org.netbeans.modules.xml.core.cookies.ScenarioData;
import org.netbeans.modules.xml.core.cookies.Util;
import org.netbeans.modules.xml.core.scenario.ScenarioPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;

public class ScenarioSupport
implements ScenarioCookie {
    public static final String SCENARIO_DATA_ATTRIBUTE = "org.netbeans.modules.xml.core.cookies.ScenarioData";
    private DataObject dataObject;
    private DefaultComboBoxModel scenarioModel;
    private ScenarioData data;

    public ScenarioSupport(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public boolean customizeScenarios() {
        DefaultComboBoxModel defaultComboBoxModel = this.getModel();
        ScenarioPanel scenarioPanel = new ScenarioPanel(this.dataObject, defaultComboBoxModel);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)scenarioPanel, Util.THIS.getString("NAME_customize_scenarios_title"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(ScenarioSupport.class), null);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (defaultComboBoxModel.getSize() == 0 && !scenarioPanel.createScenario()) {
            return false;
        }
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                Scenario scenario = (Scenario)defaultComboBoxModel.getElementAt(i);
                scenario.saveChanges();
            }
            this.saveData();
            return true;
        }
        scenarioPanel.rollBackAddedAndRemovedScenarios();
        return false;
    }

    public DefaultComboBoxModel getModel() {
        if (this.scenarioModel == null) {
            this.scenarioModel = new DefaultComboBoxModel(this.getData().getScenarios()){

                public void setSelectedItem(Object object) {
                    super.setSelectedItem(object);
                    ScenarioSupport.this.saveData();
                }
            };
            this.scenarioModel.setSelectedItem(this.scenarioModel.getElementAt(this.getData().getActiveScenarioIndex()));
            this.scenarioModel.addListDataListener(new ListDataListener(){

                public void contentsChanged(ListDataEvent listDataEvent) {
                    ScenarioSupport.this.saveData();
                }

                public void intervalAdded(ListDataEvent listDataEvent) {
                    ScenarioSupport.this.saveData();
                }

                public void intervalRemoved(ListDataEvent listDataEvent) {
                    ScenarioSupport.this.saveData();
                }
            });
        }
        return this.scenarioModel;
    }

    public void executeActiveScenario() {
        DefaultComboBoxModel defaultComboBoxModel = this.getModel();
        Scenario scenario = (Scenario)defaultComboBoxModel.getSelectedItem();
        if (scenario == null && this.customizeScenarios()) {
            scenario = (Scenario)defaultComboBoxModel.getSelectedItem();
        }
        if (scenario != null) {
            scenario.execute(this.dataObject);
        }
    }

    private void saveData() {
        if (this.scenarioModel == null || this.data == null) {
            return;
        }
        try {
            this.data.setActiveScenarioIndex(this.scenarioModel.getIndexOf(this.scenarioModel.getSelectedItem()));
            FileObject fileObject = this.dataObject.getPrimaryFile();
            if (fileObject != null) {
                fileObject.setAttribute(SCENARIO_DATA_ATTRIBUTE, (Object)this.data);
            }
        }
        catch (IOException iOException) {
            String string = Util.THIS.getString("MSG_Problems_saving_scenarios_persistently") + "\n" + iOException.getMessage();
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private ScenarioData getData() {
        if (this.data == null) {
            Object object;
            FileObject fileObject = this.dataObject.getPrimaryFile();
            if (fileObject != null && (object = fileObject.getAttribute(SCENARIO_DATA_ATTRIBUTE)) instanceof ScenarioData) {
                this.data = (ScenarioData)fileObject.getAttribute(SCENARIO_DATA_ATTRIBUTE);
            }
            if (this.data == null) {
                this.data = new ScenarioData();
            }
        }
        return this.data;
    }
}

