/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.scenario;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.api.scenario.Scenario;
import org.netbeans.modules.xml.api.scenario.ScenarioFactory;
import org.netbeans.modules.xml.core.scenario.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class NewScenarioPanel
extends JPanel {
    private static final String FOLDER = "Plugins/XML/ScenarioFactories";
    private JComboBox typeCombo;
    private JTextField nameField;
    private JLabel jLabel2;
    private JLabel jLabel1;

    public NewScenarioPanel(String string, DataObject dataObject) throws NoFactoriesException {
        this.initComponents();
        this.nameField.setText(string);
        this.nameField.setSelectionStart(0);
        this.nameField.setSelectionEnd(string.length());
        try {
            Vector<ScenarioFactory> vector;
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(FOLDER);
            if (fileObject == null) {
                throw new NoFactoriesException();
            }
            DataObject dataObject2 = DataObject.find((FileObject)fileObject);
            if (dataObject2 instanceof DataObject.Container) {
                FolderLookup folderLookup = new FolderLookup((DataObject.Container)dataObject2);
                Lookup.Template template = new Lookup.Template(ScenarioFactory.class);
                Lookup.Result result = folderLookup.getLookup().lookup(template);
                Collection collection = result.allInstances();
                vector = new Vector<ScenarioFactory>();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ScenarioFactory scenarioFactory = (ScenarioFactory)iterator.next();
                    if (!scenarioFactory.isEnabled(dataObject)) continue;
                    vector.add(scenarioFactory);
                }
                if (vector.size() == 0) {
                    throw new NoFactoriesException();
                }
            } else {
                throw new NoFactoriesException();
            }
            this.typeCombo.setModel(new DefaultComboBoxModel<Object>(vector.toArray()));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new NoFactoriesException();
        }
    }

    public static Scenario createScenario(DataObject dataObject, DefaultComboBoxModel defaultComboBoxModel) {
        NewScenarioPanel newScenarioPanel;
        String string = null;
        int n = 1;
        while (string == null) {
            string = Util.THIS.getString("NAME_Scenario_default", Integer.toString(n));
            for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                if (!string.equals(((Scenario)defaultComboBoxModel.getElementAt(i)).getName())) continue;
                string = null;
                break;
            }
            ++n;
        }
        try {
            newScenarioPanel = new NewScenarioPanel(string, dataObject);
        }
        catch (NoFactoriesException noFactoriesException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)noFactoriesException.getMessage(), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return null;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newScenarioPanel, Util.THIS.getString("NAME_New_scenario_dialog_title"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(NewScenarioPanel.class), null);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Scenario scenario = newScenarioPanel.createScenario();
            defaultComboBoxModel.addElement(scenario);
            return scenario;
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.typeCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameField.setToolTipText("null");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameField, gridBagConstraints);
        this.jLabel2.setText("Type:");
        this.jLabel2.setToolTipText("null");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.typeCombo, gridBagConstraints);
    }

    public Scenario createScenario() {
        ScenarioFactory scenarioFactory = (ScenarioFactory)this.typeCombo.getSelectedItem();
        if (scenarioFactory != null) {
            Scenario scenario = scenarioFactory.createScenario();
            scenario.setName(this.nameField.getText());
            return scenario;
        }
        return null;
    }

    public class NoFactoriesException
    extends Exception {
        public NoFactoriesException() {
            super(Util.THIS.getString("MSG_no_factories"));
        }
    }
}

