/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.scenario;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.xml.api.scenario.Scenario;
import org.netbeans.modules.xml.core.scenario.NewScenarioPanel;
import org.netbeans.modules.xml.core.scenario.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.loaders.DataObject;

public class ScenarioPanel
extends JPanel {
    private DefaultComboBoxModel scenarioModel;
    private Scenario selectedScenario;
    private Scenario selectedScenarioAtStartup;
    private DataObject dataObject;
    private HashMap uiCompMap = new HashMap();
    private Vector m_deletedScenarios = new Vector();
    private Vector m_addedScenarios = new Vector();
    private JScrollPane jScrollPane1;
    private JPanel curScenarioPanel;
    private JPanel jPanel2;
    private JList scenarioList;
    private JPanel jPanel1;
    private JButton addButton;
    private JButton renameButton;
    private JButton removeButton;

    public ScenarioPanel(DataObject dataObject, DefaultComboBoxModel defaultComboBoxModel) {
        this.scenarioModel = defaultComboBoxModel;
        this.dataObject = dataObject;
        this.initComponents();
        this.scenarioList.setModel(defaultComboBoxModel);
        this.selectedScenarioAtStartup = this.selectedScenario = (Scenario)defaultComboBoxModel.getSelectedItem();
        this.scenarioList.setSelectedValue(this.selectedScenario, true);
    }

    public boolean createScenario() {
        Scenario scenario = NewScenarioPanel.createScenario(this.dataObject, this.scenarioModel);
        if (scenario != null) {
            this.scenarioList.setSelectedValue(scenario, true);
            this.enableControls();
            this.m_addedScenarios.add(scenario);
            return true;
        }
        return false;
    }

    public void rollBackAddedAndRemovedScenarios() {
        Scenario scenario;
        int n;
        for (n = 0; n < this.m_deletedScenarios.size(); ++n) {
            scenario = (Scenario)this.m_deletedScenarios.get(n);
            this.scenarioModel.addElement(scenario);
        }
        this.m_deletedScenarios.clear();
        for (n = 0; n < this.m_addedScenarios.size(); ++n) {
            scenario = (Scenario)this.m_addedScenarios.get(n);
            this.scenarioModel.removeElement(scenario);
        }
        this.m_addedScenarios.clear();
        this.scenarioModel.setSelectedItem(this.selectedScenarioAtStartup);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.scenarioList = new JList();
        this.jPanel2 = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.renameButton = new JButton();
        this.curScenarioPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new TitledBorder("Scenarios"));
        this.jPanel1.setMinimumSize(new Dimension(172, 100));
        this.jPanel1.setPreferredSize(new Dimension(172, 150));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 70));
        this.scenarioList.setSelectionMode(0);
        this.scenarioList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ScenarioPanel.this.scenarioListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.scenarioList);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.setLayout(new GridLayout(2, 0));
        this.addButton.setText("New");
        this.addButton.setToolTipText("Create new scenario");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.addButton);
        this.removeButton.setText("Delete");
        this.removeButton.setToolTipText("Delete selected scenario");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.removeButton);
        this.renameButton.setText("Rename");
        this.renameButton.setToolTipText("Rename selected scenario");
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioPanel.this.renameButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.renameButton);
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.add((Component)this.jPanel1, "West");
        this.curScenarioPanel.setLayout(new BorderLayout());
        this.curScenarioPanel.setBorder(new TitledBorder("Options"));
        this.curScenarioPanel.setMinimumSize(new Dimension(450, 200));
        this.curScenarioPanel.setPreferredSize(new Dimension(450, 200));
        this.add((Component)this.curScenarioPanel, "Center");
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        if (this.selectedScenario != null) {
            NamePanel namePanel = new NamePanel();
            namePanel.setName(this.selectedScenario.getName());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)namePanel, "Enter new name");
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.show();
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                this.selectedScenario.setName(namePanel.getName());
                this.scenarioList.revalidate();
                this.scenarioList.repaint();
            }
        }
    }

    private void scenarioListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.curScenarioPanel.removeAll();
            Scenario scenario = (Scenario)this.scenarioList.getSelectedValue();
            if (scenario != null) {
                this.scenarioModel.setSelectedItem(scenario);
                this.selectedScenario = scenario;
                Component component = (Component)this.uiCompMap.get(this.selectedScenario);
                if (component == null) {
                    component = scenario.getCustomizer(this.dataObject, false);
                    this.uiCompMap.put(this.selectedScenario, component);
                }
                this.curScenarioPanel.add(component, "Center");
            } else {
                this.scenarioModel.setSelectedItem(null);
                this.selectedScenario = null;
            }
            this.revalidate();
            this.repaint();
            this.enableControls();
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Scenario scenario;
        int n = this.scenarioModel.getIndexOf(this.selectedScenario);
        if (n == this.scenarioModel.getSize() - 1) {
            --n;
        }
        if (!this.m_addedScenarios.contains(scenario = this.selectedScenario)) {
            this.m_deletedScenarios.add(scenario);
        } else {
            this.m_addedScenarios.remove(scenario);
        }
        this.scenarioList.clearSelection();
        this.scenarioModel.removeElement(scenario);
        if (n >= 0) {
            this.scenarioList.setSelectedIndex(n);
        }
        this.enableControls();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.createScenario();
    }

    private void enableControls() {
        this.removeButton.setEnabled(this.selectedScenario != null);
        this.renameButton.setEnabled(this.selectedScenario != null);
    }

    private class NamePanel
    extends JPanel {
        private JTextField nameField;

        public NamePanel() {
            this.add(new JLabel(Util.THIS.getString("LBL_Rename_panel_name")));
            this.nameField = new JTextField(30);
            this.add(this.nameField);
        }

        public void setName(String string) {
            this.nameField.setText(string);
        }

        public String getName() {
            return this.nameField.getText();
        }
    }
}

