/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.settings;

import org.netbeans.modules.xml.core.settings.Util;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public class CoreSettings
extends SystemOption {
    private static final long serialVersionUID = 45650374856L;
    private static CoreSettings defaultSettings = null;
    public static final String PROP_AUTO_PARSING_DELAY = "autoParsingDelay";
    private static int autoParsingDelay = 3000;
    public static final String PROP_DEFAULT_ACTION = "defaultAction";
    private static String defaultAction;
    public static final String PROP_PREFERED_SHORT_EMPTY_ELEMENT = "shortEmptyElement";
    private static boolean shortEmptyElement;

    public static CoreSettings getDefault() {
        if (defaultSettings == null) {
            defaultSettings = (CoreSettings)SharedClassObject.findObject((Class)CoreSettings.class, (boolean)true);
        }
        return defaultSettings;
    }

    protected CoreSettings() {
    }

    public String displayName() {
        String string = Util.THIS.getString("CTL_XML_option");
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::displayName = " + string);
        }
        return string;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public int getAutoParsingDelay() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::getAutoParsingDelay: " + autoParsingDelay);
        }
        return autoParsingDelay;
    }

    public void setAutoParsingDelay(int n) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::setAutoParsingDelay: " + n);
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = autoParsingDelay;
        autoParsingDelay = n;
        this.firePropertyChange(PROP_AUTO_PARSING_DELAY, new Integer(n2), new Integer(autoParsingDelay));
    }

    public String getDefaultAction() {
        return defaultAction;
    }

    public void setDefaultAction(String string) {
        String string2 = defaultAction;
        defaultAction = string;
        this.firePropertyChange(PROP_DEFAULT_ACTION, string2, string);
    }

    public SystemAction getDefaultAction(SystemAction[] systemActionArray, SystemAction systemAction) {
        String string = this.getDefaultAction();
        if (string == null) {
            return systemAction;
        }
        if (systemActionArray == null) {
            return systemAction;
        }
        for (int i = 0; i < systemActionArray.length; ++i) {
            Class<?> clazz;
            String string2;
            SystemAction systemAction2 = systemActionArray[i];
            if (systemAction2 == null || !(string2 = (clazz = systemAction2.getClass()).getName()).equals(string)) continue;
            return systemAction2;
        }
        return systemAction;
    }

    public boolean isPreferedShortEmptyElement() {
        return shortEmptyElement;
    }

    public void setPreferedShortEmptyElement(boolean bl) {
        boolean bl2 = shortEmptyElement;
        shortEmptyElement = bl;
        this.firePropertyChange(PROP_PREFERED_SHORT_EMPTY_ELEMENT, bl2, shortEmptyElement);
    }

    private void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }
}

