/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.sync;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.netbeans.modules.xml.core.lib.EncodingHelper;
import org.netbeans.modules.xml.core.sync.SyncRepresentation;
import org.netbeans.modules.xml.core.sync.Synchronizator;
import org.netbeans.modules.xml.core.sync.Util;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.xml.sax.InputSource;

public class FileRepresentation
extends SyncRepresentation {
    private final DataObject dataObject;
    private Date lastSave;

    public FileRepresentation(DataObject dataObject, Synchronizator synchronizator) {
        super(synchronizator);
        this.dataObject = dataObject;
        this.lastSave = this.getFileObject().lastModified();
    }

    private FileObject getFileObject() {
        return this.dataObject.getPrimaryFile();
    }

    public boolean represents(Class clazz) {
        return FileObject.class.isAssignableFrom(clazz);
    }

    public void update(Object object) {
    }

    public Class getUpdateClass() {
        return null;
    }

    public boolean isModified() {
        return this.lastSave.getTime() < this.getFileObject().lastModified().getTime();
    }

    public String getDisplayName() {
        return Util.THIS.getString("PROP_File_representation");
    }

    public Object getChange(Class clazz) {
        if (clazz == null || clazz.isAssignableFrom(InputSource.class)) {
            try {
                InputSource inputSource = new InputSource(this.getFileObject().getURL().toExternalForm());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getFileObject().getInputStream());
                String string = EncodingHelper.detectEncoding(bufferedInputStream);
                if (string == null) {
                    string = "UTF8";
                }
                inputSource.setCharacterStream(new InputStreamReader((InputStream)bufferedInputStream, string));
                return inputSource;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (clazz.isAssignableFrom(InputStream.class)) {
            try {
                return this.getFileObject().getInputStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        throw new RuntimeException("FileRepresentation does not support: " + clazz);
    }

    public int level() {
        return 0;
    }

    private class FileListener
    extends FileChangeAdapter {
        private FileListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            FileRepresentation.this.getSynchronizator().representationChanged(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = FileRepresentation.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject);
        }
    }
}

