/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.text;

import java.awt.Container;
import java.awt.Point;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.core.sync.Synchronizator;
import org.netbeans.modules.xml.core.text.TextEditorSupport;
import org.netbeans.modules.xml.core.text.TextRepresentation;
import org.netbeans.modules.xml.core.text.Util;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

public class XMLTextRepresentation
extends TextRepresentation {
    public XMLTextRepresentation(TextEditorSupport textEditorSupport, Synchronizator synchronizator) {
        super(textEditorSupport, synchronizator);
    }

    public void updateText(Object object) {
        block10: {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("XMLTextRepresentation::updateText");
            }
            final String string = (String)object;
            try {
                TextEditorSupport textEditorSupport = this.editor;
                if (textEditorSupport == null) break block10;
                StyledDocument styledDocument = textEditorSupport.getDocument();
                if (styledDocument == null) {
                    styledDocument = textEditorSupport.openDocument();
                }
                JEditorPane[] jEditorPaneArray = textEditorSupport.getOpenedPanes();
                JEditorPane jEditorPane = null;
                JViewport jViewport = null;
                int n = 0;
                Point point = null;
                if (jEditorPaneArray != null) {
                    jEditorPane = jEditorPaneArray[0];
                    n = jEditorPane.getCaretPosition();
                    jViewport = this.getParentViewport(jEditorPane);
                    if (jViewport != null) {
                        point = jViewport.getViewPosition();
                    }
                }
                final Exception[] exceptionArray = new Exception[]{null};
                final StyledDocument styledDocument2 = styledDocument;
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            styledDocument2.remove(0, styledDocument2.getLength());
                            styledDocument2.insertString(0, string, null);
                        }
                        catch (Exception exception) {
                            exceptionArray[0] = exception;
                        }
                    }
                };
                NbDocument.runAtomicAsUser((StyledDocument)styledDocument2, (Runnable)runnable);
                if (jEditorPaneArray != null) {
                    try {
                        jEditorPane.setCaretPosition(n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    jViewport.setViewPosition(point);
                }
                if (exceptionArray[0] != null) {
                    throw exceptionArray[0];
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    public void update(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            this.updateText(string);
        }
    }

    public boolean isModified() {
        return false;
    }

    private JViewport getParentViewport(JEditorPane jEditorPane) {
        Container container = jEditorPane.getParent();
        return container instanceof JViewport ? (JViewport)container : null;
    }
}

