/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.core.wizard.AbstractPanel;
import org.netbeans.modules.xml.core.wizard.DTDPanel;
import org.netbeans.modules.xml.core.wizard.DocumentModel;
import org.netbeans.modules.xml.core.wizard.DocumentPanel;
import org.netbeans.modules.xml.core.wizard.SchemaPanel;
import org.netbeans.modules.xml.core.wizard.Util;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

public class XMLWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 5070430920636117204L;
    private static final String XML_EXT = "xml";
    private transient TemplateWizard templateWizard;
    private transient DocumentModel model;
    private transient int current;
    private static final int TARGET_PANEL = 0;
    private transient WizardDescriptor.Panel targetPanel;
    private static final int DOCUMENT_PANEL = 1;
    private transient DocumentPanel documentPanel;
    private static final int CONSTRAINT_PANEL = 2;
    private transient SchemaPanel schemaPanel;
    private transient DTDPanel dtdPanel;
    private static XMLWizardIterator instance;
    private transient Map listenersMap = new HashMap(2);
    private transient String[] beforeSteps;
    private transient Object targetSteps;

    public static synchronized XMLWizardIterator singleton() {
        if (instance == null) {
            instance = new XMLWizardIterator();
        }
        return instance;
    }

    public void initialize(TemplateWizard templateWizard) {
        Object object;
        this.templateWizard = templateWizard;
        this.current = 0;
        URL uRL = null;
        try {
            object = templateWizard.getTargetFolder();
            uRL = object.getPrimaryFile().getURL();
            if (!uRL.toExternalForm().endsWith("/")) {
                uRL = new URL(uRL.toExternalForm() + "/");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.model = new DocumentModel(uRL);
        object = templateWizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            this.beforeSteps = (String[])object;
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (this.targetPanel != null) {
            ((JComponent)this.targetPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.targetSteps);
            this.targetPanel = null;
        }
        this.current = -1;
        this.model = null;
        templateWizard = null;
        this.schemaPanel = null;
        this.dtdPanel = null;
        this.documentPanel = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        DataFolder dataFolder = templateWizard.getTargetFolder();
        String string = templateWizard.getTargetName();
        if (string == null || "null".equals(string)) {
            string = "XMLDocument";
        }
        final FileObject fileObject = dataFolder.getPrimaryFile();
        String string2 = string;
        int n = 2;
        while (fileObject.getFileObject(string2, XML_EXT) != null) {
            string2 = string + n;
            ++n;
        }
        final String string3 = string2;
        FileSystem fileSystem = fileObject.getFileSystem();
        final FileObject[] fileObjectArray = new FileObject[1];
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject2 = fileObject.createData(string3, XMLWizardIterator.XML_EXT);
                FileLock fileLock = null;
                try {
                    fileLock = fileObject2.lock();
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    outputStream = new BufferedOutputStream(outputStream, 999);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
                    String string = XMLWizardIterator.this.model.getRoot();
                    if (string == null) {
                        string = "root";
                    }
                    outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    outputStreamWriter.write("\n");
                    String string2 = string3 + "." + XMLWizardIterator.XML_EXT;
                    Date date = new Date();
                    String string32 = DateFormat.getDateInstance(1).format(date);
                    String string4 = DateFormat.getTimeInstance(3).format(date);
                    String string5 = System.getProperty("user.name");
                    outputStreamWriter.write("<!--\n");
                    outputStreamWriter.write("    Document   : " + string2 + "\n");
                    outputStreamWriter.write("    Created on : " + string32 + ", " + string4 + "\n");
                    outputStreamWriter.write("    Author     : " + string5 + "\n");
                    outputStreamWriter.write("    Description:\n");
                    outputStreamWriter.write("        Purpose of the document follows.\n");
                    outputStreamWriter.write("-->\n");
                    outputStreamWriter.write("\n");
                    int n = XMLWizardIterator.this.model.getType();
                    XMLWizardIterator.this.model;
                    if (n == 1) {
                        if (XMLWizardIterator.this.model.getPublicID() == null) {
                            outputStreamWriter.write("<!DOCTYPE " + string + " SYSTEM '" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                        } else {
                            outputStreamWriter.write("<!DOCTYPE " + string + " PUBLIC '" + XMLWizardIterator.this.model.getPublicID() + "' '" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                        }
                        outputStreamWriter.write("<" + string + ">\n");
                    } else {
                        int n2 = XMLWizardIterator.this.model.getType();
                        XMLWizardIterator.this.model;
                        if (n2 == 2) {
                            String string6 = XMLWizardIterator.this.model.getNamespace();
                            if (string6 == null || "".equals(string6)) {
                                outputStreamWriter.write("<" + string + " xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                                outputStreamWriter.write("  xsi:noNamespaceSchemaLocation='" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                            } else {
                                outputStreamWriter.write("<" + string + " xmlns='" + string6 + "'\n");
                                outputStreamWriter.write("  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                                outputStreamWriter.write("  xsi:schemaLocation='" + string6 + " " + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                            }
                        } else {
                            outputStreamWriter.write("<" + string + ">\n");
                        }
                    }
                    outputStreamWriter.write("\n");
                    outputStreamWriter.write("</" + string + ">\n");
                    ((Writer)outputStreamWriter).flush();
                    ((Writer)outputStreamWriter).close();
                    fileLock.releaseLock();
                    fileLock = null;
                    fileObjectArray[0] = fileObject2;
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        };
        fileSystem.runAtomicAction(atomicAction);
        HashSet<DataObject> hashSet = new HashSet<DataObject>(1);
        DataObject dataObject = DataObject.find((FileObject)fileObjectArray[0]);
        Util.performDefaultAction(dataObject);
        hashSet.add(dataObject);
        return hashSet;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.currentComponent();
        if (panel.getComponent() instanceof JComponent) {
            ((JComponent)panel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.current));
        }
        return panel;
    }

    private WizardDescriptor.Panel currentComponent() {
        switch (this.current) {
            case 0: {
                return this.getTargetPanel();
            }
            case 1: {
                return this.getDocumentPanel();
            }
            case 2: {
                switch (this.model.getType()) {
                    case 1: {
                        return this.getDTDPanel();
                    }
                    case 2: {
                        return this.getSchemaPanel();
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        boolean bl = this.model.getType() == 0;
        int n = bl ? 1 : 2;
        return this.current < n;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public String name() {
        return "//TODO";
    }

    public void nextPanel() {
        ++this.current;
    }

    public void previousPanel() {
        --this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            Object v = this.listenersMap.remove(changeListener);
            if (v == null) {
                return;
            }
            if (this.model == null) {
                return;
            }
            this.model.removePropertyChangeListener((PropertyChangeListener)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(final ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
                final ChangeEvent EVENT;
                {
                    this.EVENT = new ChangeEvent(XMLWizardIterator.this);
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    changeListener.stateChanged(this.EVENT);
                }
            };
            if (this.listenersMap.put(changeListener, propertyChangeListener) == null) {
                this.model.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private WizardDescriptor.Panel getDocumentPanel() {
        if (this.documentPanel == null) {
            this.documentPanel = new DocumentPanel();
            this.documentPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString("MSG_unknown")};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.documentPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.documentPanel);
    }

    private WizardDescriptor.Panel getDTDPanel() {
        if (this.dtdPanel == null) {
            this.dtdPanel = new DTDPanel();
            this.dtdPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getDTDPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.dtdPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.dtdPanel);
    }

    private WizardDescriptor.Panel getSchemaPanel() {
        if (this.schemaPanel == null) {
            this.schemaPanel = new SchemaPanel();
            this.schemaPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.schemaPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.schemaPanel);
    }

    private WizardDescriptor.Panel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = this.templateWizard.targetChooser();
            if (this.targetPanel.getComponent() instanceof JComponent) {
                JComponent jComponent = (JComponent)this.targetPanel.getComponent();
                this.targetSteps = jComponent.getClientProperty("WizardPanel_contentData");
                String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString("MSG_unknown")};
                String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
                jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
            }
        }
        return this.targetPanel;
    }

    private String getTargetPanelName() {
        Component component = this.getTargetPanel().getComponent();
        if (component instanceof JComponent) {
            return ((JComponent)component).getName();
        }
        return "";
    }

    private String getDocumentPanelName() {
        return Util.THIS.getString("PROP_doc_panel_name");
    }

    private String getDTDPanelName() {
        return Util.THIS.getString("PROP_dtd_panel_name");
    }

    private String getSchemaPanelName() {
        return Util.THIS.getString("PROP_schema_panel_name");
    }

    private static String[] createSteps(String[] stringArray, String[] stringArray2) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray3 = new String[stringArray.length - n + stringArray2.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = i < stringArray.length - n ? stringArray[i] : stringArray2[i - stringArray.length + n];
        }
        return stringArray3;
    }
}

