/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.dtd.grammar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.dtd.grammar.DTDGrammar;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DTDParser {
    static final String SAX_PROPERTY = "http://xml.org/sax/properties/";
    static final String DECL_HANDLER = "declaration-handler";
    private boolean dtdOnly;

    public DTDParser() {
        this(false);
    }

    public DTDParser(boolean bl) {
        this.dtdOnly = bl;
    }

    public GrammarQuery parse(InputSource inputSource) {
        Handler handler = new Handler();
        try {
            EntityResolver entityResolver;
            XMLReader xMLReader = XMLUtil.createXMLReader((!this.dtdOnly ? 1 : 0) != 0);
            xMLReader.setContentHandler(handler);
            xMLReader.setErrorHandler(handler);
            xMLReader.setDTDHandler(handler);
            UserCatalog userCatalog = UserCatalog.getDefault();
            EntityResolver entityResolver2 = entityResolver = userCatalog == null ? null : userCatalog.getEntityResolver();
            if (entityResolver != null) {
                xMLReader.setEntityResolver(entityResolver);
            }
            xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            if (this.dtdOnly) {
                new SAXEntityParser(xMLReader, false).parse(inputSource);
            } else {
                xMLReader.parse(inputSource);
            }
            throw new IllegalStateException("How we can get here?");
        }
        catch (Stop stop) {
            return handler.getDTDGrammar();
        }
        catch (SAXException sAXException) {
            if (Boolean.getBoolean("netbeans.debug.xml") || Boolean.getBoolean("netbeans.debug.exceptions")) {
                sAXException.printStackTrace();
                if (sAXException.getException() instanceof RuntimeException) {
                    sAXException.getException().printStackTrace();
                }
            }
            return handler.getDTDGrammar();
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.xml")) {
                iOException.printStackTrace();
            }
            return handler.getDTDGrammar();
        }
    }

    private class Stop
    extends SAXException {
        private static final long serialVersionUID = -6466279601744402792L;

        Stop() {
            super("STOP");
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private class Handler
    extends DefaultHandler
    implements DeclHandler {
        private Map attrs = new HashMap();
        private Map elements = new HashMap();
        private Map models = new HashMap();
        private Map enums;
        private Map attrDefaults;
        private Set notations = new TreeSet();
        private Set entities = new TreeSet();
        private Set anys = new HashSet();
        private Set emptyElements;
        private DTDGrammar dtd;

        Handler() {
            this.enums = new HashMap();
            this.attrDefaults = new HashMap();
            this.emptyElements = new HashSet();
            this.dtd = new DTDGrammar(this.elements, this.models, this.attrs, this.attrDefaults, this.enums, this.entities, this.notations, this.emptyElements);
        }

        DTDGrammar getDTDGrammar() {
            Iterator iterator = this.anys.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.elements.put(string, this.elements.keySet());
            }
            return this.dtd;
        }

        public void elementDecl(String string, String string2) throws SAXException {
            if ("ANY".equals(string2)) {
                this.anys.add(string);
                this.elements.put(string, Collections.EMPTY_SET);
                return;
            }
            if ("EMPTY".equals(string2)) {
                this.elements.put(string, Collections.EMPTY_SET);
                this.emptyElements.add(string);
                return;
            }
            if ("(#PCDATA)".equals(string2)) {
                this.elements.put(string, Collections.EMPTY_SET);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n|,()?+*");
            TreeSet<String> treeSet = new TreeSet<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                if ("#PCDATA".equals(string3)) continue;
                treeSet.add(string3);
            }
            this.elements.put(string, treeSet);
            this.models.put(string, string2);
        }

        public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
            if (string.startsWith("%")) {
                return;
            }
            this.entities.add(string);
        }

        public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
            Object object;
            TreeSet<String> treeSet = (TreeSet<String>)this.attrs.get(string);
            if (treeSet == null) {
                treeSet = new TreeSet<String>();
                this.attrs.put(string, treeSet);
            }
            treeSet.add(string2);
            if (string3 != null && string3.startsWith("(")) {
                object = new StringTokenizer(string3, "()|", false);
                ArrayList<String> arrayList = new ArrayList<String>(7);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    arrayList.add(((StringTokenizer)object).nextToken());
                }
                this.enums.put(string + " " + string2, arrayList);
            }
            object = string + " " + string2;
            this.attrDefaults.put(object, string4);
        }

        public void internalEntityDecl(String string, String string2) throws SAXException {
            if (string.startsWith("%")) {
                return;
            }
            this.entities.add(string);
        }

        public void notationDecl(String string, String string2, String string3) throws SAXException {
            this.notations.add(string);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            throw new Stop();
        }
    }
}

