/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Iterator;
import org.openidex.search.CompoundSearchIterator;
import org.openidex.search.SearchInfo;

class CompoundSearchInfo
implements SearchInfo {
    private final SearchInfo[] elements;

    CompoundSearchInfo(SearchInfo[] searchInfoArray) {
        if (searchInfoArray == null) {
            throw new IllegalArgumentException();
        }
        this.elements = searchInfoArray.length != 0 ? searchInfoArray : null;
    }

    public boolean canSearch() {
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].canSearch()) continue;
            return true;
        }
        return false;
    }

    public Iterator objectsToSearch() {
        ArrayList<SearchInfo> arrayList = new ArrayList<SearchInfo>(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].canSearch()) continue;
            arrayList.add(this.elements[i]);
        }
        return new CompoundSearchIterator(arrayList.toArray(new SearchInfo[arrayList.size()]));
    }
}

