/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SimpleSearchIterator;

final class SimpleSearchInfo
implements SearchInfo {
    static final SearchInfo EMPTY_SEARCH_INFO;
    private final DataFolder rootFolder;
    private final boolean recursive;
    private final FileObjectFilter[] filters;
    static final /* synthetic */ boolean $assertionsDisabled;

    SimpleSearchInfo(DataFolder dataFolder, boolean bl, FileObjectFilter[] fileObjectFilterArray) {
        if (dataFolder == null) {
            throw new IllegalArgumentException();
        }
        if (fileObjectFilterArray != null && fileObjectFilterArray.length == 0) {
            fileObjectFilterArray = null;
        }
        this.rootFolder = dataFolder;
        this.recursive = bl;
        this.filters = fileObjectFilterArray;
    }

    public boolean canSearch() {
        return this.filters != null ? this.checkFolderAgainstFilters(this.rootFolder.getPrimaryFile()) : true;
    }

    public Iterator objectsToSearch() {
        return new SimpleSearchIterator(this.rootFolder, this.recursive, this.filters != null ? Arrays.asList(this.filters) : null);
    }

    private boolean checkFolderAgainstFilters(FileObject fileObject) {
        if (!$assertionsDisabled && !fileObject.isFolder()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i].traverseFolder(fileObject) != 0) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !SimpleSearchInfo.class.desiredAssertionStatus();
        EMPTY_SEARCH_INFO = new SearchInfo(){

            public boolean canSearch() {
                return true;
            }

            public Iterator objectsToSearch() {
                return Collections.EMPTY_LIST.iterator();
            }
        };
    }
}

