/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openidex.search.FileObjectFilter;

class SimpleSearchIterator
implements Iterator {
    private Enumeration childrenEnum;
    private List filters;
    private List filtersCopy;
    private final boolean recursive;
    private final ArrayList enums = new ArrayList();
    private final ArrayList filterLists = new ArrayList();
    private boolean upToDate = false;
    private DataObject nextObject;
    static final /* synthetic */ boolean $assertionsDisabled;

    SimpleSearchIterator(DataFolder dataFolder, boolean bl, List list) {
        this.childrenEnum = dataFolder.children(false);
        this.recursive = bl;
        this.filters = list != null ? new ArrayList(list) : null;
    }

    public boolean hasNext() {
        if (!this.upToDate) {
            this.update();
        }
        return this.nextObject != null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        if (!$assertionsDisabled && this.upToDate) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.childrenEnum == null) {
            throw new AssertionError();
        }
        do {
            if (this.childrenEnum.hasMoreElements()) {
                Object e = this.childrenEnum.nextElement();
                DataObject dataObject = (DataObject)e;
                FileObject fileObject = dataObject.getPrimaryFile();
                if (fileObject.isFolder()) {
                    if (!this.recursive) continue;
                    if (this.filters != null) {
                        List list = this.checkFolderFilters(fileObject);
                        if (list == null) continue;
                        this.filterLists.add(this.filters);
                        if (list.size() != this.filters.size()) {
                            this.filters = !list.isEmpty() ? list : null;
                        }
                    } else {
                        this.filterLists.add(null);
                    }
                    this.enums.add(this.childrenEnum);
                    this.childrenEnum = ((DataFolder)dataObject).children(false);
                    continue;
                }
                if (this.filters != null && !this.checkFileFilters(fileObject)) continue;
                this.nextObject = dataObject;
                break;
            }
            if (!$assertionsDisabled && this.enums.isEmpty() != this.filterLists.isEmpty()) {
                throw new AssertionError();
            }
            this.nextObject = null;
            if (this.enums.isEmpty()) {
                this.childrenEnum = null;
                continue;
            }
            this.childrenEnum = (Enumeration)this.enums.remove(this.enums.size() - 1);
            this.filters = (List)this.filterLists.remove(this.filterLists.size() - 1);
            if (this.filtersCopy == null || this.filtersCopy.size() == this.filters.size()) continue;
            this.filtersCopy = null;
        } while (this.childrenEnum != null);
        this.upToDate = true;
    }

    private List checkFolderFilters(FileObject fileObject) {
        if (!$assertionsDisabled && !fileObject.isFolder()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.filters == null) {
            throw new AssertionError();
        }
        if (this.filtersCopy == null) {
            this.filtersCopy = new ArrayList(this.filters);
        }
        List list = this.filtersCopy;
        Iterator iterator = list.iterator();
        block5: while (iterator.hasNext()) {
            FileObjectFilter fileObjectFilter = (FileObjectFilter)iterator.next();
            int n = fileObjectFilter.traverseFolder(fileObject);
            switch (n) {
                case 1: {
                    continue block5;
                }
                case 0: {
                    list = null;
                    break block5;
                }
                case 2: {
                    iterator.remove();
                    this.filtersCopy = null;
                    continue block5;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block5;
                }
            }
        }
        return list;
    }

    private boolean checkFileFilters(FileObject fileObject) {
        if (!$assertionsDisabled && fileObject.isFolder()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.filters == null) {
            throw new AssertionError();
        }
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            FileObjectFilter fileObjectFilter = (FileObjectFilter)iterator.next();
            if (fileObjectFilter.searchFile(fileObject)) continue;
            return false;
        }
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !SimpleSearchIterator.class.desiredAssertionStatus();
    }
}

