/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.FindPerformer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertiesTableCellEditor;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.PropertyPanel;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class BundleEditPanel
extends JPanel
implements PropertyChangeListener {
    private PropertiesDataObject obj;
    private DocumentListener listener;
    private static TableViewSettings settings;
    static final long serialVersionUID = -843810329041244483L;
    private JButton addButton;
    private JCheckBox autoResizeCheck;
    private JPanel buttonPanel;
    private JLabel commentLabel;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JTable table;
    private JPanel tablePanel;
    private JTextArea textComment;
    private JTextArea textValue;
    private JLabel valueLabel;
    private JPanel valuePanel;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public BundleEditPanel(final PropertiesDataObject propertiesDataObject, PropertiesTableModel propertiesTableModel) {
        this.obj = propertiesDataObject;
        this.initComponents();
        this.initAccessibility();
        this.initSettings();
        this.table.setColumnModel(new TableViewColumnModel());
        this.table.setModel(propertiesTableModel);
        JTextField jTextField = new JTextField();
        jTextField.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        jTextField.setBorder(new LineBorder(Color.black));
        jTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSN_CellEditor"));
        jTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSD_CellEditor"));
        this.listener = new ModifiedListener();
        this.table.setDefaultEditor(PropertiesTableModel.StringPair.class, new PropertiesTableCellEditor(jTextField, this.textComment, this.textValue, this.valueLabel, this.listener));
        this.table.setDefaultRenderer(PropertiesTableModel.StringPair.class, new TableViewRenderer());
        this.updateAddButton();
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("tableCellEditor")) {
                    BundleEditPanel.this.updateEnabled();
                } else if (propertyChangeEvent.getPropertyName().equals("model")) {
                    BundleEditPanel.this.updateAddButton();
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = BundleEditPanel.this.table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n < 0) {
                    return;
                }
                int n2 = tableColumnModel.getColumn(n).getModelIndex();
                if (n2 < 0) {
                    return;
                }
                propertiesDataObject.getBundleStructure().sort(n2);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        BundleEditPanel.access$700(3.access$600(this.this$1));
                    }
                });
            }

            static /* synthetic */ BundleEditPanel access$600(3 var0) {
                return var0.BundleEditPanel.this;
            }
        });
    }

    protected void stopEditing() {
        if (!this.table.isEditing()) {
            return;
        }
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private void updateEnabled() {
        this.textValue.setEditable(this.table.isEditing());
        this.textValue.setEnabled(this.table.isEditing());
        if (this.table.isEditing()) {
            PropertiesTableModel.StringPair stringPair = (PropertiesTableModel.StringPair)this.table.getCellEditor().getCellEditorValue();
            this.textComment.setEditable(stringPair.isCommentEditable());
            this.textComment.setEnabled(stringPair.isCommentEditable());
        } else {
            this.textComment.setEditable(false);
            this.textComment.setEnabled(false);
        }
    }

    private void updateSelection() {
        String string;
        String string2;
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        BundleStructure bundleStructure = this.obj.getBundleStructure();
        this.removeButton.setEnabled(n >= 0 && !bundleStructure.isReadOnly());
        if (n2 == -1) {
            string2 = "";
            string = "";
        } else if (n2 == 0) {
            Element.ItemElem itemElem = bundleStructure.getItem(0, n);
            string2 = bundleStructure.keyAt(n);
            string = itemElem.getComment();
        } else {
            Element.ItemElem itemElem = bundleStructure.getItem(n2 - 1, n);
            string2 = itemElem.getValue();
            string = itemElem.getComment();
        }
        this.textValue.getDocument().removeDocumentListener(this.listener);
        this.textComment.getDocument().removeDocumentListener(this.listener);
        this.textValue.setText(string2);
        this.textComment.setText(string);
        this.textValue.getDocument().addDocumentListener(this.listener);
        this.textComment.getDocument().addDocumentListener(this.listener);
    }

    private void updateAddButton() {
        this.addButton.setEnabled(!this.obj.getBundleStructure().isReadOnly());
    }

    public JTable getTable() {
        return this.table;
    }

    private void initSettings() {
        settings = TableViewSettings.getDefault();
        settings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)settings));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_BundleEditPanel"));
        this.commentLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_CommentLabel_Mnem").charAt(0));
        this.valueLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_ValueLabel_Mnem").charAt(0));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSN_CTL_Table"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSD_CTL_Table"));
        this.textValue.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_CTL_TEXTVALUE"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_LBL_AddPropertyButton"));
        this.textComment.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_CTL_TEXTCOMMENT"));
        this.autoResizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_CTL_AutoResize"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_LBL_RemovePropertyButton"));
    }

    public boolean requestFocusInWindow() {
        return this.table.requestFocusInWindow();
    }

    private void initComponents() {
        this.tablePanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new BundleTable();
        this.valuePanel = new JPanel();
        this.commentLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textComment = new JTextArea();
        this.valueLabel = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.textValue = new JTextArea();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.autoResizeCheck = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setFocusCycleRoot(true);
        this.tablePanel.setLayout(new GridBagLayout());
        this.table.setCellSelectionEnabled(true);
        this.scrollPane.setViewportView(this.table);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.tablePanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tablePanel, gridBagConstraints);
        this.valuePanel.setLayout(new GridBagLayout());
        this.commentLabel.setLabelFor(this.textComment);
        this.commentLabel.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_CommentLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.commentLabel, gridBagConstraints);
        this.textComment.setEditable(false);
        this.textComment.setLineWrap(true);
        this.textComment.setRows(3);
        this.textComment.setEnabled(false);
        this.jScrollPane2.setViewportView(this.textComment);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.valueLabel.setLabelFor(this.textValue);
        this.valueLabel.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_ValueLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.valuePanel.add((Component)this.valueLabel, gridBagConstraints);
        this.textValue.setEditable(false);
        this.textValue.setLineWrap(true);
        this.textValue.setRows(3);
        this.textValue.setEnabled(false);
        this.jScrollPane3.setViewportView(this.textValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 11, 11, 0);
        this.valuePanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.valuePanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_AddPropertyButton_Mnem").charAt(0));
        this.addButton.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_AddPropertyButton"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleEditPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_RemovePropertyButton_Mnem").charAt(0));
        this.removeButton.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_RemovePropertyButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleEditPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 11, 11, 11);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.autoResizeCheck.setMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("CTL_AutoResize_Mnem").charAt(0));
        this.autoResizeCheck.setSelected(true);
        this.autoResizeCheck.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("CTL_AutoResize"));
        this.autoResizeCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleEditPanel.this.autoResizeCheckActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.buttonPanel.add((Component)this.autoResizeCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void autoResizeCheckActionPerformed(ActionEvent actionEvent) {
        if (this.autoResizeCheck.isSelected()) {
            this.table.setAutoResizeMode(4);
        } else {
            this.table.setAutoResizeMode(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        this.stopEditing();
        String string = ((PropertiesTableModel.StringPair)this.table.getModel().getValueAt(n, 0)).getValue();
        if (string == null) {
            return;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getBundle((Class)BundleEditPanel.class).getString("MSG_DeleteKeyQuestion"), string), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.OK_OPTION)) {
            try {
                this.obj.getOpenSupport().atomicUndoRedoFlag = new Object();
                for (int i = 0; i < this.obj.getBundleStructure().getEntryCount(); ++i) {
                    PropertiesStructure propertiesStructure;
                    PropertiesFileEntry propertiesFileEntry = this.obj.getBundleStructure().getNthEntry(i);
                    if (propertiesFileEntry == null || (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) == null) continue;
                    propertiesStructure.deleteItem(string);
                }
            }
            finally {
                this.obj.getOpenSupport().atomicUndoRedoFlag = null;
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        final Dialog[] dialogArray = new Dialog[1];
        final Element.ItemElem itemElem = new Element.ItemElem(null, new Element.KeyElem(null, ""), new Element.ValueElem(null, ""), new Element.CommentElem(null, ""));
        PropertyPanel propertyPanel = new PropertyPanel(itemElem);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyPanel, NbBundle.getBundle((Class)BundleEditPanel.class).getString("CTL_NewPropertyTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                    String string = itemElem.getKey();
                    String string2 = itemElem.getValue();
                    String string3 = itemElem.getComment();
                    boolean bl = false;
                    try {
                        ((BundleEditPanel)BundleEditPanel.this).obj.getOpenSupport().atomicUndoRedoFlag = new Object();
                        for (int i = 0; i < BundleEditPanel.this.obj.getBundleStructure().getEntryCount(); ++i) {
                            PropertiesFileEntry propertiesFileEntry = BundleEditPanel.this.obj.getBundleStructure().getNthEntry(i);
                            if (propertiesFileEntry != null && !propertiesFileEntry.getHandler().getStructure().addItem(string, string2, string3)) {
                                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$BundleEditPanel == null ? BundleEditPanel.class$("org.netbeans.modules.properties.BundleEditPanel") : class$org$netbeans$modules$properties$BundleEditPanel)).getString("MSG_KeyExists"), itemElem.getKey(), Util.getLocaleLabel((MultiDataObject.Entry)propertiesFileEntry)), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                                continue;
                            }
                            bl = true;
                        }
                    }
                    finally {
                        ((BundleEditPanel)BundleEditPanel.this).obj.getOpenSupport().atomicUndoRedoFlag = null;
                    }
                    if (bl) {
                        PropertiesRequestProcessor.getInstance().post(new Runnable(this, string){
                            private final /* synthetic */ String val$key;
                            private final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$key = string;
                            }

                            public void run() {
                                int n = BundleEditPanel.access$1100(8.access$1200(this.this$1)).getBundleStructure().getKeyIndexByName(this.val$key);
                                if (n != -1) {
                                    int n2 = n;
                                    SwingUtilities.invokeLater(new Runnable(this, n2){
                                        private final /* synthetic */ int val$row;
                                        private final /* synthetic */ 9 this$2;
                                        {
                                            this.this$2 = var1_1;
                                            this.val$row = n;
                                        }

                                        public void run() {
                                            Rectangle rectangle;
                                            if (BundleEditPanel.access$500(8.access$1200(9.access$1300(this.this$2))).getAutoscrolls() && (rectangle = BundleEditPanel.access$500(8.access$1200(9.access$1300(this.this$2))).getCellRect(this.val$row, 1, false)) != null) {
                                                BundleEditPanel.access$500(8.access$1200(9.access$1300(this.this$2))).scrollRectToVisible(rectangle);
                                            }
                                            BundleEditPanel.access$500(8.access$1200(9.access$1300(this.this$2))).getColumnModel().getSelectionModel().setSelectionInterval(1, 1);
                                            BundleEditPanel.access$500(8.access$1200(9.access$1300(this.this$2))).getSelectionModel().setSelectionInterval(this.val$row, this.val$row);
                                            BundleEditPanel.access$500(8.access$1200(9.access$1300(this.this$2))).requestFocusInWindow();
                                            BundleEditPanel.access$500(8.access$1200(9.access$1300(this.this$2))).editCellAt(this.val$row, 1);
                                        }
                                    });
                                }
                            }

                            static /* synthetic */ 8 access$1300(9 var0) {
                                return var0.this$1;
                            }
                        });
                    }
                } else if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION) {
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                }
            }

            static /* synthetic */ BundleEditPanel access$1200(8 var0) {
                return var0.BundleEditPanel.this;
            }
        });
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].show();
    }

    static /* synthetic */ void access$700(BundleEditPanel bundleEditPanel) {
        bundleEditPanel.updateSelection();
    }

    private class ModifiedListener
    implements DocumentListener {
        private ModifiedListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentModified();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentModified();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentModified();
        }

        private void documentModified() {
            BundleEditPanel.this.obj.setModified(true);
        }
    }

    static class BundleTable
    extends JTable {
        public BundleTable() {
            this.setRowHeight(this.getCellFontHeight() + 1);
        }

        public void removeEditorSilent() {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.removeCellEditorListener(this);
                if (this.editorComp != null) {
                    this.remove(this.editorComp);
                }
                Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(rectangle);
            }
        }

        private int getCellFontHeight() {
            FontMetrics fontMetrics;
            Font font = UIManager.getFont("TextField.font");
            if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
                return fontMetrics.getHeight();
            }
            return 14;
        }
    }

    private class TableViewRenderer
    extends DefaultTableCellRenderer {
        private TableViewRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            PropertiesTableModel.StringPair stringPair = (PropertiesTableModel.StringPair)object;
            this.setFont(settings.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            String string = null;
            if (stringPair.getValue() != null) {
                string = stringPair.getValue();
            }
            if (BasicHTML.isHTMLString(string)) {
                string = " " + string;
            }
            this.setValue(string == null ? "" : string);
            if (stringPair.isKeyType()) {
                this.setBackground(settings.getKeyBackground());
            } else if (stringPair.getValue() != null) {
                this.setBackground(settings.getValueBackground());
            } else {
                this.setBackground(settings.getShadowColor());
            }
            if (stringPair.isKeyType()) {
                this.setForeground(settings.getKeyColor());
            } else {
                this.setForeground(settings.getValueColor());
            }
            Color color = this.getBackground();
            boolean bl3 = color != null && color.equals(jTable.getBackground()) && jTable.isOpaque();
            this.setOpaque(!bl3);
            return this;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (FindPerformer.getFindPerformer(BundleEditPanel.this.table).isHighlightSearch()) {
                String string = this.getText();
                String string2 = FindPerformer.getFindPerformer(BundleEditPanel.this.table).getFindString();
                if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                    int n = 0;
                    int n2 = (int)graphics.getFontMetrics().getStringBounds(string2, graphics).getWidth();
                    Color color = graphics.getColor();
                    while ((n = string.indexOf(string2, n)) >= 0) {
                        int n3 = (int)graphics.getFontMetrics().getStringBounds(string.substring(0, n), graphics).getWidth() + this.getInsets().left;
                        graphics.setColor(settings.getHighlightBackground());
                        graphics.fillRect(n3, 0, n2, graphics.getClipBounds().height);
                        graphics.setColor(settings.getHighlightColor());
                        graphics.drawString(string2, n3, -((int)graphics.getFontMetrics().getStringBounds(string2, graphics).getY()));
                        n += string2.length();
                    }
                    graphics.setColor(color);
                }
            }
        }
    }

    private class TableViewColumnModel
    extends DefaultTableColumnModel {
        private AncestorListener ancestorListener;
        private final TableCellRenderer headerRenderer;

        private TableViewColumnModel() {
            this.headerRenderer = new TableViewHeaderRenderer();
        }

        public void addColumn(TableColumn tableColumn) {
            if (tableColumn == null) {
                throw new IllegalArgumentException("Object is null");
            }
            this.tableColumns.addElement(tableColumn);
            tableColumn.addPropertyChangeListener(this);
            this.adjustColumnWidths();
            tableColumn.setHeaderRenderer(this.headerRenderer);
            this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
        }

        private void adjustColumnWidths() {
            int n;
            Rectangle rectangle = Utilities.getUsableScreenBounds();
            int n2 = rectangle.width / 10;
            int n3 = 0;
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = BundleEditPanel.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, BundleEditPanel.this.table);
            if (topComponent != null) {
                n3 = topComponent.getBounds().width;
            } else if (this.ancestorListener == null) {
                this.ancestorListener = new AncestorListener(this){
                    private final /* synthetic */ TableViewColumnModel this$1;
                    {
                        this.this$1 = tableViewColumnModel;
                    }

                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        if (ancestorEvent.getAncestor() instanceof TopComponent) {
                            TableViewColumnModel.access$1500(this.this$1);
                            BundleEditPanel.access$500(TableViewColumnModel.access$1700(this.this$1)).removeAncestorListener(TableViewColumnModel.access$1600(this.this$1));
                            TableViewColumnModel.access$1602(this.this$1, null);
                        }
                    }

                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }

                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }
                };
                BundleEditPanel.this.table.addAncestorListener(this.ancestorListener);
            }
            int n4 = 0;
            if ((n3 -= ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().left + ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().right + 12 + 11) > 0 && (n = n3 / BundleEditPanel.this.table.getColumnCount()) > n2) {
                n2 = n - BundleEditPanel.this.table.getColumnModel().getColumnMargin();
                n4 = n3 % BundleEditPanel.this.table.getColumnCount();
            }
            for (n = 0; n < BundleEditPanel.this.table.getColumnCount(); ++n) {
                TableColumn tableColumn = BundleEditPanel.this.table.getColumnModel().getColumn(n);
                if (n == 0) {
                    tableColumn.setPreferredWidth(n2 + n4);
                    tableColumn.setWidth(n2 + n4);
                    continue;
                }
                tableColumn.setPreferredWidth(n2);
                tableColumn.setWidth(n2);
            }
            this.recalcWidthCache();
            BundleEditPanel.this.table.revalidate();
            BundleEditPanel.this.table.getTableHeader().repaint();
        }

        static /* synthetic */ void access$1500(TableViewColumnModel tableViewColumnModel) {
            tableViewColumnModel.adjustColumnWidths();
        }

        static /* synthetic */ AncestorListener access$1600(TableViewColumnModel tableViewColumnModel) {
            return tableViewColumnModel.ancestorListener;
        }

        static /* synthetic */ BundleEditPanel access$1700(TableViewColumnModel tableViewColumnModel) {
            return tableViewColumnModel.BundleEditPanel.this;
        }

        static /* synthetic */ AncestorListener access$1602(TableViewColumnModel tableViewColumnModel, AncestorListener ancestorListener) {
            tableViewColumnModel.ancestorListener = ancestorListener;
            return tableViewColumnModel.ancestorListener;
        }
    }

    private class TableViewHeaderRenderer
    extends DefaultTableCellRenderer {
        private int column;

        private TableViewHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            this.column = n2;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = BundleEditPanel.this.table.convertColumnIndexToView(BundleEditPanel.this.obj.getBundleStructure().getSortIndex());
            if (this.column == n) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                Color color = graphics.getColor();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                Rectangle rectangle = fontMetrics.getStringBounds(" ", graphics).getBounds();
                Rectangle rectangle2 = fontMetrics.getStringBounds("\u25b2", graphics).getBounds();
                Rectangle rectangle3 = this.getBounds();
                Insets insets = this.getInsets();
                BorderUIResource.BevelBorderUIResource bevelBorderUIResource = (BorderUIResource.BevelBorderUIResource)BorderUIResource.getLoweredBevelBorderUIResource();
                boolean bl = BundleEditPanel.this.obj.getBundleStructure().getSortOrder();
                if (bl) {
                    n7 = rectangle.width + rectangle2.width / 2;
                    n6 = rectangle.width;
                    n5 = rectangle.width + rectangle2.width;
                    n4 = rectangle3.y + insets.top + 2;
                    n2 = n3 = rectangle3.y + rectangle3.height - insets.bottom - 2;
                } else {
                    n7 = rectangle.width;
                    n6 = rectangle.width + rectangle2.width;
                    n5 = rectangle.width + rectangle2.width / 2;
                    n3 = n4 = rectangle3.y + insets.top + 2;
                    n2 = rectangle3.y + rectangle3.height - insets.bottom - 2;
                }
                graphics.setColor(bevelBorderUIResource.getShadowOuterColor(this));
                if (bl) {
                    graphics.drawLine(n7, n4, n6, n3);
                } else {
                    graphics.drawPolyline(new int[]{n6, n7, n5}, new int[]{n3, n4, n2}, 3);
                }
                graphics.setColor(bevelBorderUIResource.getShadowInnerColor(this));
                if (bl) {
                    graphics.drawLine(n7, n4 + 1, n6 + 1, n3 - 1);
                } else {
                    graphics.drawPolyline(new int[]{n6 - 1, n7 + 1, n5}, new int[]{n3 + 1, n4 + 1, n2 - 1}, 3);
                }
                graphics.setColor(bevelBorderUIResource.getHighlightOuterColor(this));
                if (bl) {
                    graphics.drawPolyline(new int[]{n7, n5, n6}, new int[]{n4, n2, n3}, 3);
                } else {
                    graphics.drawLine(n6, n3, n5, n2);
                }
                graphics.setColor(bevelBorderUIResource.getHighlightInnerColor(this));
                if (bl) {
                    graphics.drawPolyline(new int[]{n7, n5 - 1, n6 + 1}, new int[]{n4 + 1, n2 - 1, n3 - 1}, 3);
                } else {
                    graphics.drawLine(n6 - 1, n3 + 1, n5, n2 - 1);
                }
                graphics.setColor(color);
            }
        }
    }
}

