/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.PropertyBundleSupport;
import org.netbeans.modules.properties.StructHandler;
import org.openide.util.WeakListeners;

public class BundleStructure {
    PropertiesDataObject obj;
    private PropertiesFileEntry[] entries;
    private List keyList;
    private KeyComparator comparator = new KeyComparator();
    private PropertyBundleSupport propBundleSupport = new PropertyBundleSupport(this);
    private PropertyChangeListener propListener;

    public BundleStructure(PropertiesDataObject propertiesDataObject) {
        this.obj = propertiesDataObject;
        this.updateEntries();
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("files")) {
                    BundleStructure.this.updateEntries();
                    BundleStructure.this.propBundleSupport.fireBundleStructureChanged();
                }
            }
        };
        propertiesDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)propertiesDataObject)));
    }

    public PropertiesFileEntry getNthEntry(int n) {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        if (n >= 0 && n < this.entries.length) {
            return this.entries[n];
        }
        return null;
    }

    public int getEntryIndexByFileName(String string) {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!this.entries[i].getFile().getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public PropertiesFileEntry getEntryByFileName(String string) {
        int n = this.getEntryIndexByFileName(string);
        return n == -1 ? null : this.entries[n];
    }

    public int getEntryCount() {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        return this.entries.length;
    }

    public String[] getKeys() {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        return this.keyList.toArray(new String[0]);
    }

    public String keyAt(int n) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        if (n < 0 || n >= this.keyList.size()) {
            return null;
        }
        return (String)this.keyList.get(n);
    }

    public int getKeyIndexByName(String string) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        return this.keyList.indexOf(string);
    }

    public Element.ItemElem getItem(int n, int n2) {
        String string = this.keyAt(n2);
        return this.getItem(n, string);
    }

    public Element.ItemElem getItem(int n, String string) {
        if (string == null) {
            return null;
        }
        PropertiesFileEntry propertiesFileEntry = this.getNthEntry(n);
        if (propertiesFileEntry == null) {
            return null;
        }
        PropertiesStructure propertiesStructure = propertiesFileEntry.getHandler().getStructure();
        if (propertiesStructure != null) {
            return propertiesStructure.getItem(string);
        }
        return null;
    }

    public int getKeyCount() {
        if (this.keyList != null) {
            return this.keyList.size();
        }
        this.notifyKeyListNotInitialized();
        return 0;
    }

    public void sort(int n) {
        if (n >= 0) {
            this.comparator.setIndex(n);
        }
        Collections.sort(this.keyList, this.comparator);
        this.propBundleSupport.fireBundleDataChanged();
    }

    public int getSortIndex() {
        return this.comparator.getIndex();
    }

    public boolean getSortOrder() {
        return this.comparator.isAscending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries() {
        TreeMap<String, PropertiesFileEntry> treeMap = new TreeMap<String, PropertiesFileEntry>(PropertiesDataObject.getSecondaryFilesComparator());
        Object object = this.obj.secondaryEntries().iterator();
        while (object.hasNext()) {
            PropertiesFileEntry propertiesFileEntry = (PropertiesFileEntry)((Object)object.next());
            treeMap.put(propertiesFileEntry.getFile().getName(), propertiesFileEntry);
        }
        object = this;
        synchronized (object) {
            int n = treeMap.size();
            this.entries = new PropertiesFileEntry[n + 1];
            this.entries[0] = (PropertiesFileEntry)this.obj.getPrimaryEntry();
            int n2 = 0;
            Iterator iterator = treeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                this.entries[++n2] = (PropertiesFileEntry)((Object)iterator.next().getValue());
            }
        }
        this.buildKeySet();
    }

    private synchronized void buildKeySet() {
        ArrayList arrayList = new ArrayList(){

            public boolean equals(Object object) {
                if (!(object instanceof ArrayList)) {
                    return false;
                }
                ArrayList arrayList = (ArrayList)object;
                if (this.size() != arrayList.size()) {
                    return false;
                }
                for (int i = 0; i < this.size(); ++i) {
                    if (this.contains(arrayList.get(i)) && arrayList.contains(this.get(i))) continue;
                    return false;
                }
                return true;
            }
        };
        int n = this.getEntryCount();
        for (int i = 0; i < n; ++i) {
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            PropertiesStructure propertiesStructure = propertiesFileEntry.getHandler().getStructure();
            if (propertiesStructure == null) continue;
            Iterator iterator = propertiesStructure.allItems();
            while (iterator.hasNext()) {
                String string;
                Element.ItemElem itemElem = (Element.ItemElem)iterator.next();
                if (itemElem == null || (string = itemElem.getKey()) == null || arrayList.contains(string)) continue;
                arrayList.add(itemElem.getKey());
            }
        }
        Collections.sort(arrayList, this.comparator);
        this.keyList = arrayList;
    }

    boolean isReadOnly() {
        boolean bl = false;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            bl |= propertiesFileEntry.getFile().canWrite();
        }
        return !bl;
    }

    public void addPropertyBundleListener(PropertyBundleListener propertyBundleListener) {
        this.propBundleSupport.addPropertyBundleListener(propertyBundleListener);
    }

    public void removePropertyBundleListener(PropertyBundleListener propertyBundleListener) {
        this.propBundleSupport.removePropertyBundleListener(propertyBundleListener);
    }

    void notifyItemChanged(PropertiesStructure propertiesStructure, Element.ItemElem itemElem) {
        this.propBundleSupport.fireItemChanged(propertiesStructure.getParent().getEntry().getFile().getName(), itemElem.getKey());
    }

    void notifyOneFileChanged(StructHandler structHandler) {
        List list = this.keyList;
        this.buildKeySet();
        if (!((Object)this.keyList).equals(list)) {
            this.propBundleSupport.fireBundleDataChanged();
        } else {
            this.propBundleSupport.fireFileChanged(structHandler.getEntry().getFile().getName());
        }
    }

    void notifyOneFileChanged(StructHandler structHandler, Map map, Map map2, Map map3) {
        this.buildKeySet();
        this.propBundleSupport.fireBundleDataChanged();
    }

    private void notifyKeyListNotInitialized() {
        throw new IllegalStateException("Resource Bundles: KeyList not initialized");
    }

    private void notifyEntriesNotInitialized() {
        throw new IllegalStateException("Resource Bundles: Entries not initialized");
    }

    private final class KeyComparator
    implements Comparator {
        private int index = -1;
        private boolean ascending = false;

        public void setIndex(int n) {
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            if (this.index == n) {
                if (this.ascending) {
                    this.ascending = false;
                } else {
                    n = -1;
                    this.ascending = true;
                }
            } else {
                this.ascending = true;
            }
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public int compare(Object object, Object object2) {
            String string;
            String string2;
            Element.ItemElem itemElem;
            Element.ItemElem itemElem2;
            if (this.index < 0) {
                itemElem2 = BundleStructure.this.getItem(0, (String)object);
                itemElem = BundleStructure.this.getItem(0, (String)object2);
                if (itemElem2 != null && itemElem != null) {
                    int n = itemElem2.getBounds().getBegin().getOffset();
                    int n2 = itemElem.getBounds().getBegin().getOffset();
                    return n - n2;
                }
                if (itemElem2 != null) {
                    return -1;
                }
                if (itemElem != null) {
                    return 1;
                }
                string2 = (String)object;
                string = (String)object2;
            }
            if (this.index == 0) {
                string2 = (String)object;
                string = (String)object2;
            } else {
                itemElem2 = BundleStructure.this.getItem(this.index - 1, (String)object);
                itemElem = BundleStructure.this.getItem(this.index - 1, (String)object2);
                if (itemElem2 == null) {
                    if (itemElem == null) {
                        return 0;
                    }
                    return this.ascending ? 1 : -1;
                }
                if (itemElem == null) {
                    return this.ascending ? -1 : 1;
                }
                string2 = itemElem2.getValue();
                string = itemElem.getValue();
            }
            if (string2 == null) {
                if (string == null) {
                    return 0;
                }
                return this.ascending ? 1 : -1;
            }
            if (string == null) {
                return this.ascending ? -1 : 1;
            }
            int n = string2.compareToIgnoreCase(string);
            return this.ascending ? n : -n;
        }
    }
}

