/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public abstract class PresentableFileEntry
extends FileEntry
implements Node.Cookie {
    static final long serialVersionUID = 3328227388376142699L;
    private transient Node nodeDelegate;
    private boolean modif = false;
    private transient PropertyChangeSupport changeSupport;
    private ChangeListener cookieL = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            PresentableFileEntry.this.firePropertyChange("cookie", null, null);
        }
    };
    private transient CookieSet cookieSet;
    private transient Object nodeDelegateMutex = new Object();

    public PresentableFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        super(multiDataObject, fileObject);
    }

    protected abstract Node createNodeDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node getNodeDelegate() {
        Object object = this.nodeDelegateMutex;
        synchronized (object) {
            if (this.nodeDelegate == null) {
                this.nodeDelegate = this.createNodeDelegate();
            }
            return this.nodeDelegate;
        }
    }

    private static boolean setTemplate(FileObject fileObject, boolean bl) throws IOException {
        Object object = fileObject.getAttribute("template");
        boolean bl2 = Boolean.TRUE.equals(object);
        if (bl == bl2) {
            return false;
        }
        fileObject.setAttribute("template", (Object)(bl ? Boolean.TRUE : null));
        return true;
    }

    public final void setTemplate(boolean bl) throws IOException {
        if (!PresentableFileEntry.setTemplate(this.getFile(), bl)) {
            return;
        }
        this.firePropertyChange("template", !bl, bl);
    }

    public boolean isTemplate() {
        Object object = this.getFile().getAttribute("template");
        return Boolean.TRUE.equals(object);
    }

    public FileObject rename(String string) throws IOException {
        String string2 = this.getName();
        FileObject fileObject = super.rename(string);
        this.firePropertyChange("name", string2, string);
        return fileObject;
    }

    public FileObject renameEntry(String string) throws IOException {
        return this.rename(string);
    }

    public void delete() throws IOException {
        super.delete();
        this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean bl) {
        if (this.modif != bl) {
            this.modif = bl;
            this.firePropertyChange("modified", !bl, bl);
        }
    }

    public abstract HelpCtx getHelpCtx();

    public String getName() {
        return this.getFile().getName();
    }

    public final DataFolder getFolder() {
        FileObject fileObject = this.getFile().getParent();
        return fileObject == null ? null : DataFolder.findFolder((FileObject)fileObject);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.getChangeSupport().firePropertyChange(string, object, object2);
    }

    private final synchronized PropertyChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.changeSupport;
    }

    protected final synchronized void setCookieSet(CookieSet cookieSet) {
        if (this.cookieSet != null) {
            this.cookieSet.removeChangeListener(this.cookieL);
        }
        cookieSet.addChangeListener(this.cookieL);
        this.cookieSet = cookieSet;
        this.firePropertyChange("cookie", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null) {
            return cookieSet;
        }
        PresentableFileEntry presentableFileEntry = this;
        synchronized (presentableFileEntry) {
            if (this.cookieSet != null) {
                return this.cookieSet;
            }
            this.setCookieSet(new CookieSet());
            return this.cookieSet;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie;
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null && (cookie = cookieSet.getCookie(clazz)) != null) {
            return cookie;
        }
        if (clazz.isInstance((Object)this)) {
            return this;
        }
        return null;
    }
}

