/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public final class PropertiesDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = 4795737295255253334L;
    public static final String MIME_PROPERTIES = "text/x-properties";
    private transient BundleStructure bundleStructure;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();
    private transient String pasteSuffix;

    public PropertiesDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.initialize();
    }

    private void initialize() {
        this.bundleStructure = null;
        this.getCookieSet().add(new Class[]{PropertiesOpen.class, PropertiesEditorSupport.class}, (CookieSet.Factory)this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return this.getOpenSupport();
        }
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return ((PropertiesFileEntry)this.getPrimaryEntry()).getPropertiesEditor();
        }
        return null;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DataObject handleCopy(DataFolder dataFolder) throws IOException {
        try {
            this.pasteSuffix = this.createPasteSuffix(dataFolder);
            DataObject dataObject = super.handleCopy(dataFolder);
            return dataObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        try {
            this.pasteSuffix = this.createPasteSuffix(dataFolder);
            FileObject fileObject = super.handleMove(dataFolder);
            return fileObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    String getPasteSuffix() {
        return this.pasteSuffix;
    }

    void removeSecondaryEntry2(MultiDataObject.Entry entry) {
        this.removeSecondaryEntry(entry);
    }

    private String createPasteSuffix(DataFolder dataFolder) {
        String string = this.getPrimaryFile().getName();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (true) {
            String string2 = n == 0 ? string : string + n;
            boolean bl = false;
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (!(dataObjectArray[i] instanceof PropertiesDataObject) || !string2.equals(dataObjectArray[i].getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (n == 0) {
                    return "";
                }
                return "" + n;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesOpen getOpenSupport() {
        Object object = this.OPEN_SUPPORT_LOCK;
        synchronized (object) {
            if (this.openSupport == null) {
                this.openSupport = new PropertiesOpen(this);
            }
            return this.openSupport;
        }
    }

    void updateModificationStatus() {
        boolean bl = false;
        if (((PresentableFileEntry)this.getPrimaryEntry()).isModified()) {
            bl = true;
        } else {
            Iterator iterator = this.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                if (!((PresentableFileEntry)((Object)iterator.next())).isModified()) continue;
                bl = true;
                break;
            }
        }
        super.setModified(bl);
    }

    protected Node createNodeDelegate() {
        PropertiesChildren propertiesChildren = new PropertiesChildren();
        PropertiesDataNode propertiesDataNode = new PropertiesDataNode((DataObject)this, (Children)propertiesChildren);
        return propertiesDataNode;
    }

    public BundleStructure getBundleStructure() {
        if (this.bundleStructure == null) {
            this.bundleStructure = new BundleStructure(this);
        }
        return this.bundleStructure;
    }

    public static Comparator getSecondaryFilesComparator() {
        return new KeyComparator();
    }

    void fireNameChange() {
        this.firePropertyChange("name", null, null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }

    private class PropertiesChildren
    extends Children.Keys {
        private PropertyChangeListener propertyListener = null;

        PropertiesChildren() {
        }

        protected void mySetKeys() {
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator(this){
                private final /* synthetic */ PropertiesChildren this$1;
                {
                    this.this$1 = propertiesChildren;
                }

                public int compare(Object object, Object object2) {
                    if (object == object2) {
                        return 0;
                    }
                    if (object == null) {
                        return -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    if (object instanceof String) {
                        return ((String)object).compareTo((String)object2);
                    }
                    return -1;
                }
            });
            treeSet.add(PropertiesDataObject.this.getPrimaryEntry().getFile().getName());
            Iterator iterator = PropertiesDataObject.this.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                FileEntry fileEntry = (FileEntry)iterator.next();
                treeSet.add(fileEntry.getFile().getName());
            }
            this.setKeys(treeSet);
        }

        protected void addNotify() {
            this.mySetKeys();
            if (this.propertyListener == null) {
                this.propertyListener = new PropertyChangeListener(this){
                    private final /* synthetic */ PropertiesChildren this$1;
                    {
                        this.this$1 = propertiesChildren;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("files".equals(propertyChangeEvent.getPropertyName())) {
                            this.this$1.mySetKeys();
                        }
                    }
                };
                PropertiesDataObject.this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyListener, (Object)((Object)PropertiesDataObject.this)));
            }
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(Object object) {
            if (object == null) {
                return null;
            }
            if (!(object instanceof String)) {
                return null;
            }
            String string = (String)object;
            PropertiesFileEntry propertiesFileEntry = (PropertiesFileEntry)PropertiesDataObject.this.getPrimaryEntry();
            if (string.equals(propertiesFileEntry.getFile().getName())) {
                return new Node[]{propertiesFileEntry.getNodeDelegate()};
            }
            Iterator iterator = PropertiesDataObject.this.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                propertiesFileEntry = (PropertiesFileEntry)((Object)iterator.next());
                if (!string.equals(propertiesFileEntry.getFile().getName())) continue;
                return new Node[]{propertiesFileEntry.getNodeDelegate()};
            }
            return null;
        }
    }
}

