/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.Util;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.TopComponent;

public class PropertiesEditorSupport
extends CloneableEditorSupport
implements EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie,
Serializable {
    private static final byte NEW_LINE_N = 0;
    private static final byte NEW_LINE_R = 1;
    private static final byte NEW_LINE_RN = 2;
    private FileStatusListener fsStatusListener;
    private byte newLineType = 0;
    transient PropertiesFileEntry myEntry;
    static final long serialVersionUID = 1787354011149868490L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public PropertiesEditorSupport(PropertiesFileEntry propertiesFileEntry) {
        super((CloneableEditorSupport.Env)new Environment(propertiesFileEntry), Lookups.singleton((Object)propertiesFileEntry.getDataObject()));
        this.myEntry = propertiesFileEntry;
        this.initialize();
    }

    public void initialize() {
        this.setMIMEType("text/x-properties");
    }

    protected boolean canClose() {
        if (this.hasOpenedTableComponent()) {
            return true;
        }
        MultiDataObject multiDataObject = this.myEntry.getDataObject();
        if (multiDataObject == null || !multiDataObject.isModified()) {
            return true;
        }
        return super.canClose();
    }

    protected CloneableEditor createCloneableEditor() {
        return new PropertiesEditor(this);
    }

    private void attachStatusListener() {
        FileSystem fileSystem;
        if (this.fsStatusListener != null) {
            return;
        }
        try {
            fileSystem = this.myEntry.getFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(65536, (Throwable)fileStateInvalidException);
            return;
        }
        this.fsStatusListener = new FsStatusListener();
        fileSystem.addFileStatusListener(FileUtil.weakFileStatusListener((FileStatusListener)this.fsStatusListener, (Object)fileSystem));
    }

    private void updateEditorDisplayNames() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        String string = this.messageName();
        String string2 = this.messageHtmlName();
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            TopComponent topComponent = (TopComponent)enumeration.nextElement();
            topComponent.setDisplayName(string);
            topComponent.setHtmlDisplayName(string2);
        }
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        ((PropertiesEditor)cloneableEditor).initialize(this.myEntry);
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = super.createStyledDocument(editorKit);
        styledDocument.putProperty("title", this.myEntry.getFile().toString());
        styledDocument.putProperty("stream", this.myEntry.getDataObject());
        styledDocument.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            private void changed() {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return styledDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        NewLineReader newLineReader = new NewLineReader(inputStream);
        try {
            editorKit.read(newLineReader, (Document)styledDocument, 0);
            this.newLineType = newLineReader.getNewLineType();
        }
        finally {
            newLineReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        NewLineWriter newLineWriter = new NewLineWriter(outputStream, this.newLineType);
        try {
            editorKit.write(newLineWriter, (Document)styledDocument, 0, styledDocument.getLength());
        }
        finally {
            ((Writer)newLineWriter).flush();
            ((Writer)newLineWriter).close();
        }
    }

    protected boolean notifyModified() {
        this.myEntry.getHandler().autoParse();
        if (super.notifyModified()) {
            ((Environment)this.env).addSaveCookie();
            return true;
        }
        return false;
    }

    protected Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return task;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ((Environment)this.env).removeSaveCookie();
    }

    public void open() {
        super.open();
        this.attachStatusListener();
    }

    protected void notifyClosed() {
        if (!this.hasOpenedTableComponent()) {
            boolean bl = this.isModified();
            super.notifyClosed();
            if (bl && this.myEntry.getFile().isValid() && !this.myEntry.getFile().isVirtual()) {
                this.myEntry.getHandler().reparseNowBlocking();
            }
        }
    }

    protected String messageOpening() {
        String string = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage((Class)PropertiesEditorSupport.class, (String)"LBL_ObjectOpen", (Object)string);
    }

    protected String messageOpened() {
        String string = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage((Class)PropertiesEditorSupport.class, (String)"LBL_ObjectOpened", (Object)string);
    }

    private String getRawMessageName() {
        return this.myEntry.getDataObject().getName() + '(' + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ')';
    }

    private String addModifiedInfo(String string) {
        int n = this.isModified() ? (this.myEntry.getFile().canWrite() ? 1 : 2) : (this.myEntry.getFile().canWrite() ? 3 : 0);
        return NbBundle.getMessage((Class)PropertiesEditorSupport.class, (String)"LBL_EditorName", (Object)new Integer(n), (Object)string);
    }

    protected String messageName() {
        if (!this.myEntry.getDataObject().isValid()) {
            return "";
        }
        return this.addModifiedInfo(this.getRawMessageName());
    }

    protected String messageHtmlName() {
        Object object;
        if (!this.myEntry.getDataObject().isValid()) {
            return null;
        }
        String string = this.getRawMessageName();
        String string2 = null;
        FileObject fileObject = this.myEntry.getFile();
        try {
            object = fileObject.getFileSystem().getStatus();
            if (object != null) {
                Set<FileObject> set = Collections.singleton(fileObject);
                if (object instanceof FileSystem.HtmlStatus) {
                    FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)object;
                    string2 = htmlStatus.annotateNameHtml(string, set);
                    if (string.equals(string2)) {
                        string2 = null;
                    }
                    if (string2 != null && !string2.startsWith("<html>")) {
                        string2 = "<html>" + string2;
                    }
                }
                if (string2 == null) {
                    string2 = object.annotateName(string, set);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        object = string2 != null ? string2 : string;
        return this.addModifiedInfo((String)object);
    }

    protected String messageSave() {
        String string = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage((Class)PropertiesEditorSupport.class, (String)"MSG_SaveFile", (Object)string);
    }

    protected String messageToolTip() {
        FileObject fileObject = this.myEntry.getFile();
        return FileUtil.getFileDisplayName((FileObject)fileObject);
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoStampFlagManager();
    }

    UndoRedo.Manager getUndoRedoManager() {
        return super.getUndoRedo();
    }

    void forceNotifyClosed() {
        super.notifyClosed();
    }

    byte getNewLineType() {
        return this.newLineType;
    }

    private void saveThisEntry() throws IOException {
        super.saveDocument();
        if (!this.env.isModified()) {
            this.myEntry.setModified(false);
        }
    }

    public synchronized boolean hasOpenedTableComponent() {
        return ((PropertiesDataObject)this.myEntry.getDataObject()).getOpenSupport().hasOpenedTableComponent();
    }

    public synchronized boolean hasOpenedEditorComponent() {
        Enumeration enumeration = this.allEditors.getComponents();
        return enumeration.hasMoreElements();
    }

    static {
        $assertionsDisabled = !PropertiesEditorSupport.class.desiredAssertionStatus();
    }

    static class StampFlag {
        private long timeStamp;
        private Object atomicFlag;

        public StampFlag(long l, Object object) {
            this.timeStamp = l;
            this.atomicFlag = object;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long l) {
            this.timeStamp = l;
        }

        public Object getAtomicFlag() {
            return this.atomicFlag;
        }
    }

    class UndoRedoStampFlagManager
    extends UndoRedo.Manager {
        WeakHashMap stampFlags = new WeakHashMap(5);

        UndoRedoStampFlagManager() {
        }

        public synchronized boolean addEdit(UndoableEdit undoableEdit) {
            this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), ((PropertiesDataObject)PropertiesEditorSupport.this.myEntry.getDataObject()).getOpenSupport().atomicUndoRedoFlag));
            return super.addEdit(undoableEdit);
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), ((PropertiesDataObject)PropertiesEditorSupport.this.myEntry.getDataObject()).getOpenSupport().atomicUndoRedoFlag));
            return super.replaceEdit(undoableEdit);
        }

        public synchronized void undo() throws CannotUndoException {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit != null) {
                Object object = ((StampFlag)this.stampFlags.get(undoableEdit)).getAtomicFlag();
                super.undo();
                this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), object));
            }
        }

        public synchronized void redo() throws CannotRedoException {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit != null) {
                Object object = ((StampFlag)this.stampFlags.get(undoableEdit)).getAtomicFlag();
                super.redo();
                this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), object));
            }
        }

        public long getTimeStampOfEditToBeUndone() {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                return 0L;
            }
            return ((StampFlag)this.stampFlags.get(undoableEdit)).getTimeStamp();
        }

        public long getTimeStampOfEditToBeRedone() {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                return 0L;
            }
            return ((StampFlag)this.stampFlags.get(undoableEdit)).getTimeStamp();
        }

        public Object getAtomicFlagOfEditToBeUndone() {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                return null;
            }
            return ((StampFlag)this.stampFlags.get(undoableEdit)).getAtomicFlag();
        }

        public Object getAtomicFlagOfEditToBeRedone() {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                return null;
            }
            return ((StampFlag)this.stampFlags.get(undoableEdit)).getAtomicFlag();
        }
    }

    static class NewLineWriter
    extends BufferedWriter {
        byte newLineType;

        public NewLineWriter(OutputStream outputStream, byte by) throws UnsupportedEncodingException {
            super(new OutputStreamWriter(outputStream, "8859_1"));
            this.newLineType = by;
        }

        public void write(int n) throws IOException {
            if (n == 13) {
                return;
            }
            if (n == 10) {
                if (this.newLineType == 1) {
                    super.write(13);
                } else if (this.newLineType == 0) {
                    super.write(10);
                } else if (this.newLineType == 2) {
                    super.write(13);
                    super.write(10);
                }
            } else {
                super.write(n);
            }
        }
    }

    static class NewLineReader
    extends BufferedReader {
        int[] newLineTypes = new int[]{0, 0, 0};

        public NewLineReader(InputStream inputStream) throws IOException {
            super(new InputStreamReader(inputStream, "8859_1"));
        }

        public int read() throws IOException {
            int n = super.read();
            if (n == -1) {
                return -1;
            }
            if (n == 13) {
                n = super.read();
                while (n == 13) {
                    n = super.read();
                }
                if (n == 10) {
                    n = super.read();
                    this.newLineTypes[2] = this.newLineTypes[2] + 1;
                    return 10;
                }
                this.newLineTypes[1] = this.newLineTypes[1] + 1;
                return 10;
            }
            if (n == 10) {
                n = super.read();
                this.newLineTypes[0] = this.newLineTypes[0] + 1;
                return 10;
            }
            return n;
        }

        public byte getNewLineType() {
            if (this.newLineTypes[0] > this.newLineTypes[1]) {
                return this.newLineTypes[0] > this.newLineTypes[2] ? (byte)0 : 2;
            }
            return this.newLineTypes[1] > this.newLineTypes[2] ? (byte)1 : 2;
        }
    }

    public static class PropertiesEditor
    extends CloneableEditor {
        protected transient PropertiesFileEntry entry;
        private transient PropertyChangeListener saveCookieLNode;
        static final long serialVersionUID = -2702087884943509637L;

        public PropertiesEditor() {
        }

        public PropertiesEditor(PropertiesEditorSupport propertiesEditorSupport) {
            super((CloneableEditorSupport)propertiesEditorSupport);
        }

        private void initialize(PropertiesFileEntry propertiesFileEntry) {
            this.entry = propertiesFileEntry;
            Node node = propertiesFileEntry.getNodeDelegate();
            this.setActivatedNodes(new Node[]{node});
            this.updateName();
            this.saveCookieLNode = new PropertyChangeListener(this){
                private final /* synthetic */ PropertiesEditor this$0;
                {
                    this.this$0 = propertiesEditor;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("cookie".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName())) {
                        PropertiesEditor.access$1001(this.this$0);
                    }
                }
            };
            this.entry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.saveCookieLNode, (Object)((Object)this.entry)));
        }

        protected boolean closeLast() {
            return super.closeLast();
        }

        public Image getIcon() {
            return Utilities.loadImage((String)"org/netbeans/modules/properties/propertiesLocale.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.editlocale");
        }

        private JEditorPane getPane() {
            return this.pane;
        }

        static /* synthetic */ void access$1001(PropertiesEditor propertiesEditor) {
            super.updateName();
        }
    }

    public class PropertiesEditAt
    implements EditCookie {
        private String key;

        PropertiesEditAt(String string) {
            this.key = string;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void edit() {
            PropertiesEditor propertiesEditor = (PropertiesEditor)PropertiesEditorSupport.super.openCloneableTopComponent();
            propertiesEditor.requestActive();
            Element.ItemElem itemElem = PropertiesEditorSupport.this.myEntry.getHandler().getStructure().getItem(this.key);
            if (itemElem != null) {
                int n = itemElem.getKeyElem().getBounds().getBegin().getOffset();
                if (propertiesEditor.getPane() != null && propertiesEditor.getPane().getCaret() != null) {
                    propertiesEditor.getPane().getCaret().setDot(n);
                }
            }
        }
    }

    private static final class EnvironmentListener
    extends FileChangeAdapter {
        private Reference reference;

        public EnvironmentListener(Environment environment) {
            this.reference = new WeakReference<Environment>(environment);
        }

        public void fileChanged(FileEvent fileEvent) {
            Environment environment = (Environment)this.reference.get();
            if (environment != null) {
                if (!environment.entry.getFile().equals(fileEvent.getFile())) {
                    fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)new EnvironmentListener(environment));
                    return;
                }
                if (fileEvent.getFile().isVirtual()) {
                    environment.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.fileRemoved();
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)this);
                } else {
                    environment.fileChanged(fileEvent.isExpected(), fileEvent.getTime());
                }
            }
        }
    }

    private static class Environment
    implements CloneableEditorSupport.Env,
    PropertyChangeListener,
    SaveCookie {
        static final long serialVersionUID = 354528097109874355L;
        protected PropertiesFileEntry entry;
        private transient FileLock fileLock;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;

        public Environment(PropertiesFileEntry propertiesFileEntry) {
            this.entry = propertiesFileEntry;
            propertiesFileEntry.getFile().addFileChangeListener((FileChangeListener)new EnvironmentListener(this));
            propertiesFileEntry.addPropertyChangeListener(this);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().addPropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.FALSE.equals(propertyChangeEvent.getOldValue())) {
                    return;
                }
                PropertiesEditorSupport propertiesEditorSupport = (PropertiesEditorSupport)this.findCloneableOpenSupport();
                if (propertiesEditorSupport != null) {
                    this.unmarkModified();
                    propertiesEditorSupport.close(false);
                }
            } else {
                this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().removePropertyChangeListener(propertyChangeListener);
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().addVetoableChangeListener(vetoableChangeListener);
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().removeVetoableChangeListener(vetoableChangeListener);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (PropertiesEditorSupport)this.entry.getCookieSet().getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = PropertiesEditorSupport.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
        }

        public boolean isValid() {
            return this.entry.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.entry.isModified();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.entry.takeLock();
            }
            this.entry.setModified(true);
        }

        public void unmarkModified() {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.entry.setModified(false);
        }

        public String getMimeType() {
            return this.entry.getFile().getMIMEType();
        }

        public Date getTime() {
            this.entry.getFile().refresh(false);
            return this.entry.getFile().lastModified();
        }

        public InputStream inputStream() throws IOException {
            return this.entry.getFile().getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            return this.entry.getFile().getOutputStream(this.fileLock);
        }

        public void save() throws IOException {
            ((PropertiesEditorSupport)this.findCloneableOpenSupport()).saveThisEntry();
        }

        private void firePropertyChange(String string, Object object, Object object2) {
            this.prop().firePropertyChange(string, object, object2);
        }

        private void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
            this.veto().fireVetoableChange(string, object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            if (this.propSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.propSupp == null) {
                        this.propSupp = new PropertyChangeSupport(this);
                    }
                }
            }
            return this.propSupp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            if (this.vetoSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.vetoSupp == null) {
                        this.vetoSupp = new VetoableChangeSupport(this);
                    }
                }
            }
            return this.vetoSupp;
        }

        private void addSaveCookie() {
            if (this.entry.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PropertiesEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
                this.entry.getCookieSet().add((Node.Cookie)this);
            }
            ((PropertiesDataObject)this.entry.getDataObject()).updateModificationStatus();
        }

        private void removeSaveCookie() {
            SaveCookie saveCookie = (SaveCookie)this.entry.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PropertiesEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (saveCookie != null && saveCookie.equals(this)) {
                this.entry.getCookieSet().remove((Node.Cookie)this);
            }
            PropertiesRequestProcessor.getInstance().post(new Runnable(this){
                private final /* synthetic */ Environment this$0;
                {
                    this.this$0 = environment;
                }

                public void run() {
                    ((PropertiesDataObject)this.this$0.entry.getDataObject()).updateModificationStatus();
                }
            });
        }

        private void fileChanged(boolean bl, long l) {
            if (bl) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(l));
            }
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }

    private static final class Env
    extends Environment {
        static final long serialVersionUID = -9218186467757330339L;
        private PropertiesFileEntry entry;

        public Env(PropertiesFileEntry propertiesFileEntry) {
            super(propertiesFileEntry);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.entry != null) {
                ((Environment)this).entry = this.entry;
            }
        }
    }

    final class FsStatusListener
    implements FileStatusListener,
    Runnable {
        FsStatusListener() {
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (fileStatusEvent.isNameChange() && fileStatusEvent.hasChanged(PropertiesEditorSupport.this.myEntry.getFile())) {
                Mutex.EVENT.writeAccess((Runnable)this);
            }
        }

        public void run() {
            PropertiesEditorSupport.this.updateEditorDisplayNames();
        }
    }
}

