/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.ErrorManager;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

class PropertiesParser {
    PropertiesFileEntry pfe;
    PropertiesEditorSupport editor;
    PropertiesReader propertiesReader;
    private boolean stop = false;

    public PropertiesParser(PropertiesFileEntry propertiesFileEntry) {
        this.pfe = propertiesFileEntry;
    }

    void initParser() throws IOException {
        this.editor = this.pfe.getPropertiesEditor();
        this.propertiesReader = this.createReader();
    }

    private PropertiesReader createReader() throws IOException {
        StyledDocument styledDocument = null;
        if (this.editor.isDocumentLoaded()) {
            styledDocument = this.editor.getDocument();
        }
        if (styledDocument == null) {
            styledDocument = this.editor.openDocument();
        }
        final StyledDocument styledDocument2 = styledDocument;
        final String[] stringArray = new String[1];
        styledDocument2.render(new Runnable(){

            public void run() {
                try {
                    stringArray[0] = styledDocument2.getText(0, styledDocument2.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        return new PropertiesReader(stringArray[0]);
    }

    public PropertiesStructure parseFile() {
        try {
            PropertiesStructure propertiesStructure = this.parseFileMain();
            return propertiesStructure;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void stop() {
        this.stop = true;
        this.clean();
    }

    public void clean() {
        if (this.propertiesReader != null) {
            try {
                this.propertiesReader.close();
                this.propertiesReader = null;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    private PropertiesStructure parseFileMain() throws IOException {
        HashMap<String, Element.ItemElem> hashMap = new HashMap<String, Element.ItemElem>(25, 1.0f);
        PropertiesReader propertiesReader = null;
        while (true) {
            if (this.stop) {
                return null;
            }
            propertiesReader = this.propertiesReader;
            if (propertiesReader == null) {
                return null;
            }
            Element.ItemElem itemElem = this.readNextElem(propertiesReader);
            if (itemElem == null) break;
            hashMap.put(itemElem.getKey(), itemElem);
        }
        return new PropertiesStructure(this.createBiasBounds(0L, propertiesReader.position), hashMap);
    }

    private Element.ItemElem readNextElem(PropertiesReader propertiesReader) throws IOException {
        Element.ValueElem valueElem;
        Element.KeyElem keyElem;
        int n;
        int n2 = n = propertiesReader.position;
        FlaggedLine flaggedLine = propertiesReader.readLineExpectComment();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (flaggedLine != null) {
            bl = false;
            if (!flaggedLine.flag) break;
            stringBuffer.append(this.trimComment(flaggedLine.line));
            stringBuffer.append(flaggedLine.lineSep);
            n2 = propertiesReader.position;
            flaggedLine = propertiesReader.readLineExpectComment();
        }
        if (bl) {
            return null;
        }
        String string = stringBuffer.toString();
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            string = stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        Element.CommentElem commentElem = new Element.CommentElem(this.createBiasBounds(n, n2), UtilConvert.loadConvert(string));
        if (flaggedLine == null) {
            keyElem = null;
            valueElem = null;
        } else {
            String string2;
            int n3;
            int n4;
            int n5;
            ArrayList<FlaggedLine> arrayList = new ArrayList<FlaggedLine>(2);
            flaggedLine.startPosition = n2;
            flaggedLine.stringValue = flaggedLine.line.toString();
            arrayList.add(flaggedLine);
            while (PropertiesParser.isPartialLine(flaggedLine.line)) {
                flaggedLine.stringValue = flaggedLine.stringValue.substring(0, flaggedLine.stringValue.length() - 1);
                int n6 = propertiesReader.position;
                flaggedLine = propertiesReader.readLineNoFrills();
                if (flaggedLine == null) break;
                int n7 = 0;
                for (n7 = 0; n7 < flaggedLine.line.length() && " \t\r\n\f".indexOf(flaggedLine.line.charAt(n7)) != -1; ++n7) {
                }
                flaggedLine.stringValue = flaggedLine.line.substring(n7, flaggedLine.line.length());
                flaggedLine.startPosition = n6 + n7;
                arrayList.add(flaggedLine);
            }
            PositionMap positionMap = new PositionMap(arrayList);
            String string3 = positionMap.getString();
            int n8 = string3.length();
            for (n5 = 0; n5 < n8 && " \t\r\n\f".indexOf(string3.charAt(n5)) != -1; ++n5) {
            }
            for (n4 = n5; n4 < n8; ++n4) {
                n3 = string3.charAt(n4);
                if (n3 == 92) {
                    ++n4;
                    continue;
                }
                if ("=: \t\r\n\f".indexOf(n3) != -1) break;
            }
            for (n3 = n4; n3 < n8 && " \t\r\n\f".indexOf(string3.charAt(n3)) != -1; ++n3) {
            }
            if (n3 < n8 && "=:".indexOf(string3.charAt(n3)) != -1) {
                ++n3;
            }
            while (n3 < n8 && " \t\r\n\f".indexOf(string3.charAt(n3)) != -1) {
                ++n3;
            }
            String string4 = string3.substring(n5, n4);
            String string5 = string2 = n4 < n8 ? string3.substring(n3, n8) : "";
            if (string4 == null) {
                // empty if block
            }
            int n9 = propertiesReader.position;
            int n10 = 0;
            try {
                n10 = positionMap.getFilePosition(n3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n10 = n9;
            }
            keyElem = new Element.KeyElem(this.createBiasBounds(n2, n10), UtilConvert.loadConvert(string4));
            valueElem = new Element.ValueElem(this.createBiasBounds(n10, n9), UtilConvert.loadConvert(string2));
        }
        return new Element.ItemElem(this.createBiasBounds(n, propertiesReader.position), keyElem, valueElem, commentElem);
    }

    private StringBuffer trimComment(StringBuffer stringBuffer) {
        char c;
        while (stringBuffer.length() > 0 && ((c = stringBuffer.charAt(0)) == '#' || c == '!')) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer;
    }

    private static int position(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    private PositionBounds createBiasBounds(long l, long l2) {
        PositionRef positionRef = this.editor.createPositionRef(PropertiesParser.position(l), Position.Bias.Forward);
        PositionRef positionRef2 = this.editor.createPositionRef(PropertiesParser.position(l2), Position.Bias.Backward);
        return new PositionBounds(positionRef, positionRef2);
    }

    private static boolean isPartialLine(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length() - 1;
        while (n2 >= 0 && stringBuffer.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private static class FlaggedLine {
        StringBuffer line = new StringBuffer();
        boolean flag = false;
        String lineSep = "\n";
        int startPosition = 0;
        String stringValue;

        FlaggedLine() {
        }
    }

    private static class PositionMap {
        private ArrayList list;

        PositionMap(ArrayList arrayList) {
            this.list = arrayList;
        }

        public String getString() {
            String string = ((FlaggedLine)this.list.get((int)0)).stringValue;
            for (int i = 1; i < this.list.size(); ++i) {
                string = string + ((FlaggedLine)this.list.get((int)i)).stringValue;
            }
            return string;
        }

        public int getFilePosition(int n) throws ArrayIndexOutOfBoundsException {
            int n2;
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < this.list.size(); ++n2) {
                n4 = n3;
                if (n2 == this.list.size() - 1 ? n3 >= n : (n3 += ((FlaggedLine)this.list.get((int)n2)).stringValue.length()) > n) break;
            }
            if (n > n3) {
                throw new ArrayIndexOutOfBoundsException("not in scope");
            }
            return ((FlaggedLine)this.list.get((int)n2)).startPosition + n - n4;
        }
    }

    private static class PropertiesReader
    extends BufferedReader {
        private static final String LINE_SEPARATOR = "line.separator";
        private int peekChar = -1;
        public int position = 0;

        private PropertiesReader(String string) {
            super(new StringReader(string));
        }

        private PropertiesReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n = this.peek();
            this.peekChar = -1;
            if (n != -1) {
                ++this.position;
            }
            return n;
        }

        private int peek() throws IOException {
            if (this.peekChar == -1) {
                this.peekChar = super.read();
            }
            return this.peekChar;
        }

        public FlaggedLine readLineExpectComment() throws IOException {
            int n = this.read();
            if (n == -1) {
                return null;
            }
            boolean bl = false;
            FlaggedLine flaggedLine = new FlaggedLine();
            while (n != -1 && n != 10 && n != 13) {
                if (!bl && " \t\r\n\f".indexOf((char)n) == -1) {
                    flaggedLine.flag = (char)n == '!' || (char)n == '#';
                    bl = true;
                }
                flaggedLine.line.append((char)n);
                n = this.read();
            }
            if (!bl) {
                flaggedLine.flag = true;
            }
            if (n == 13) {
                if (this.peek() == 10) {
                    n = this.read();
                    flaggedLine.lineSep = "\r\n";
                } else {
                    flaggedLine.lineSep = "\r";
                }
            } else {
                flaggedLine.lineSep = n == 10 ? "\n" : System.getProperty(LINE_SEPARATOR);
            }
            return flaggedLine;
        }

        public FlaggedLine readLineNoFrills() throws IOException {
            int n = this.read();
            if (n == -1) {
                return null;
            }
            FlaggedLine flaggedLine = new FlaggedLine();
            while (n != -1 && n != 10 && n != 13) {
                flaggedLine.line.append((char)n);
                n = this.read();
            }
            if (n == 13) {
                if (this.peek() == 10) {
                    n = this.read();
                    flaggedLine.lineSep = "\r\n";
                } else {
                    flaggedLine.lineSep = "\r";
                }
            } else {
                flaggedLine.lineSep = n == 10 ? "\n" : System.getProperty(LINE_SEPARATOR);
            }
            return flaggedLine;
        }
    }
}

