/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesParser;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesStructure;
import org.openide.util.RequestProcessor;

public class StructHandler {
    private PropertiesFileEntry propFileEntry;
    private WeakReference parsingTaskWRef = new WeakReference<Object>(null);
    private SoftReference propStructureSRef = new SoftReference<Object>(null);
    private WeakReference parserWRef = new WeakReference<Object>(null);
    private boolean parsingAllowed = true;
    static final long serialVersionUID = -3367087822606643886L;

    public StructHandler(PropertiesFileEntry propertiesFileEntry) {
        this.propFileEntry = propertiesFileEntry;
    }

    PropertiesStructure reparseNowBlocking() {
        return this.reparseNowBlocking(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PropertiesStructure reparseNowBlocking(boolean bl) {
        if (!this.parsingAllowed) {
            return null;
        }
        PropertiesParser propertiesParser = new PropertiesParser(this.propFileEntry);
        try {
            this.parserWRef = new WeakReference<PropertiesParser>(propertiesParser);
            propertiesParser.initParser();
            PropertiesStructure propertiesStructure = propertiesParser.parseFile();
            this.updatePropertiesStructure(propertiesStructure, bl);
            PropertiesStructure propertiesStructure2 = propertiesStructure;
            return propertiesStructure2;
        }
        catch (IOException iOException) {
            this.updatePropertiesStructure(null, bl);
            PropertiesStructure propertiesStructure = null;
            return propertiesStructure;
        }
        finally {
            propertiesParser.clean();
        }
    }

    synchronized void stopParsing() {
        this.parsingAllowed = false;
        PropertiesParser propertiesParser = (PropertiesParser)this.parserWRef.get();
        if (propertiesParser != null) {
            propertiesParser.stop();
        }
    }

    synchronized void allowParsing() {
        this.parsingAllowed = true;
    }

    public PropertiesFileEntry getEntry() {
        return this.propFileEntry;
    }

    void autoParse() {
        if (!this.isStructureLoaded()) {
            return;
        }
        RequestProcessor.Task task = (RequestProcessor.Task)this.parsingTaskWRef.get();
        if (task != null) {
            task.schedule(500);
        } else {
            this.parsingTaskWRef = new WeakReference<RequestProcessor.Task>(PropertiesRequestProcessor.getInstance().post(new Runnable(){

                public void run() {
                    StructHandler.this.reparseNowBlocking();
                }
            }));
        }
    }

    private void updatePropertiesStructure(PropertiesStructure propertiesStructure, boolean bl) {
        if (propertiesStructure == null) {
            this.propStructureSRef = new SoftReference<Object>(null);
            return;
        }
        PropertiesStructure propertiesStructure2 = (PropertiesStructure)this.propStructureSRef.get();
        if (propertiesStructure2 == null) {
            propertiesStructure.setParent(this);
            propertiesStructure2 = propertiesStructure;
            this.propStructureSRef = new SoftReference<PropertiesStructure>(propertiesStructure2);
            if (bl) {
                propertiesStructure2.structureChanged();
            }
        } else {
            propertiesStructure2.update(propertiesStructure);
        }
    }

    public PropertiesStructure getStructure() {
        PropertiesStructure propertiesStructure = (PropertiesStructure)this.propStructureSRef.get();
        if (propertiesStructure != null) {
            return propertiesStructure;
        }
        return this.reparseNowBlocking(false);
    }

    private boolean isStructureLoaded() {
        return this.propStructureSRef.get() != null;
    }
}

