/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class TableViewSettings {
    public static final Color KEY_DEFAULT_COLOR = Color.blue;
    public static final Color KEY_DEFAULT_BACKGROUND = Color.white;
    public static final Color VALUE_DEFAULT_COLOR = Color.magenta;
    public static final Color VALUE_DEFAULT_BACKGROUND = Color.white;
    public static final Color HIGHLIGHT_DEFAULT_COLOR = Color.black;
    public static final Color HIGHLIGHT_DEFAULT_BACKGROUND = Color.yellow;
    public static final Color SHADOW_DEFAULT_COLOR = new Color(SystemColor.controlHighlight.getRGB());
    public static final KeyStroke[] FIND_NEXT_DEFAULT_KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(114, 0)};
    public static final KeyStroke[] FIND_PREVIOUS_DEFAULT_KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(114, 1)};
    public static final KeyStroke[] TOGGLE_HIGHLIGHT_DEFAULT_KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(72, 9)};
    private static DelegatingSettings delegatingSettings;
    private static Lookup.Result registrations;

    protected TableViewSettings() {
    }

    public static synchronized TableViewSettings getDefault() {
        if (delegatingSettings == null) {
            Lookup lookup = Lookup.getDefault();
            Lookup.Template template = new Lookup.Template(TableViewSettings.class);
            registrations = lookup.lookup(template);
            registrations.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    TableViewSettings tableViewSettings = null;
                    tableViewSettings = registrations.allInstances().isEmpty() ? new HardcodedSettings() : (TableViewSettings)registrations.allInstances().iterator().next();
                    delegatingSettings.setPeer(tableViewSettings);
                }
            });
            TableViewSettings tableViewSettings = null;
            tableViewSettings = registrations.allInstances().isEmpty() ? new HardcodedSettings() : (TableViewSettings)registrations.allInstances().iterator().next();
            delegatingSettings = new DelegatingSettings(tableViewSettings);
        }
        return delegatingSettings;
    }

    public abstract Color getKeyColor();

    public abstract Color getKeyBackground();

    public abstract Color getValueColor();

    public abstract Color getValueBackground();

    public abstract Color getHighlightColor();

    public abstract Color getHighlightBackground();

    public abstract Color getShadowColor();

    public abstract Font getFont();

    public abstract KeyStroke[] getKeyStrokesFindNext();

    public abstract KeyStroke[] getKeyStrokesFindPrevious();

    public abstract KeyStroke[] getKeyStrokesToggleHighlight();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    private static class HardcodedSettings
    extends TableViewSettings {
        private HardcodedSettings() {
        }

        public Color getKeyColor() {
            return KEY_DEFAULT_COLOR;
        }

        public Color getKeyBackground() {
            return KEY_DEFAULT_BACKGROUND;
        }

        public Color getValueColor() {
            return VALUE_DEFAULT_COLOR;
        }

        public Color getValueBackground() {
            return VALUE_DEFAULT_BACKGROUND;
        }

        public Color getHighlightColor() {
            return HIGHLIGHT_DEFAULT_COLOR;
        }

        public Color getHighlightBackground() {
            return HIGHLIGHT_DEFAULT_BACKGROUND;
        }

        public Color getShadowColor() {
            return SHADOW_DEFAULT_COLOR;
        }

        public Font getFont() {
            return UIManager.getFont("TextField.font");
        }

        public KeyStroke[] getKeyStrokesFindNext() {
            return FIND_NEXT_DEFAULT_KEYSTROKES;
        }

        public KeyStroke[] getKeyStrokesFindPrevious() {
            return FIND_PREVIOUS_DEFAULT_KEYSTROKES;
        }

        public KeyStroke[] getKeyStrokesToggleHighlight() {
            return TOGGLE_HIGHLIGHT_DEFAULT_KEYSTROKES;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    private static class DelegatingSettings
    extends TableViewSettings
    implements PropertyChangeListener {
        private PropertyChangeSupport events = new PropertyChangeSupport(this);
        private TableViewSettings peer;

        DelegatingSettings(TableViewSettings tableViewSettings) {
            this.peer = tableViewSettings;
            tableViewSettings.addPropertyChangeListener(this);
        }

        void setPeer(TableViewSettings tableViewSettings) {
            this.peer.removePropertyChangeListener(this);
            this.peer = tableViewSettings;
            this.peer.addPropertyChangeListener(this);
            this.events.firePropertyChange(null, null, null);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.events.addPropertyChangeListener(propertyChangeListener);
        }

        public Color getHighlightBackground() {
            return this.peer.getHighlightBackground();
        }

        public Color getHighlightColor() {
            return this.peer.getHighlightColor();
        }

        public Color getKeyBackground() {
            return this.peer.getKeyBackground();
        }

        public Color getKeyColor() {
            return this.peer.getKeyColor();
        }

        public Font getFont() {
            return this.peer.getFont();
        }

        public KeyStroke[] getKeyStrokesFindNext() {
            return this.peer.getKeyStrokesFindNext();
        }

        public KeyStroke[] getKeyStrokesFindPrevious() {
            return this.peer.getKeyStrokesFindPrevious();
        }

        public KeyStroke[] getKeyStrokesToggleHighlight() {
            return this.peer.getKeyStrokesToggleHighlight();
        }

        public Color getShadowColor() {
            return this.peer.getShadowColor();
        }

        public Color getValueBackground() {
            return this.peer.getValueBackground();
        }

        public Color getValueColor() {
            return this.peer.getValueColor();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.events.removePropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.events.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

