/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.Storage;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

class FileMapStorage
implements Storage {
    private FileChannel writeChannel;
    private FileChannel readChannel;
    private static final int BASE_BUFFER_SIZE = 8196;
    private ByteBuffer master;
    private ByteBuffer contents;
    private long mappedRange;
    private final long MAX_MAP_RANGE = 0x1400000L;
    private long mappedStart;
    private ByteBuffer buffer = null;
    protected int bytesWritten = 0;
    private File outfile = null;
    private int outstandingBufferCount = 0;

    FileMapStorage() {
        this.init();
    }

    private void init() {
        this.contents = null;
        this.mappedRange = -1L;
        this.mappedStart = 0L;
        this.master = ByteBuffer.allocateDirect(8196);
        this.readChannel = null;
        this.writeChannel = null;
        this.buffer = null;
        this.bytesWritten = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFileExists() throws IOException {
        if (this.outfile == null) {
            File file;
            String string = System.getProperty("java.io.tmpdir");
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            if (!(file = new File(string)).exists() || !file.canWrite()) {
                IllegalStateException illegalStateException = new IllegalStateException("Cannot write to " + string);
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, NbBundle.getMessage((Class)OutWriter.class, (String)"FMT_CannotWrite", (Object)string));
                throw illegalStateException;
            }
            Class clazz = FileMapStorage.class;
            synchronized (clazz) {
                String string2 = string + "output" + Long.toString(System.currentTimeMillis());
                this.outfile = new File(string2);
                while (this.outfile.exists()) {
                    string2 = string2 + "x";
                    this.outfile = new File(string2);
                }
                this.outfile.createNewFile();
                this.outfile.deleteOnExit();
            }
        }
    }

    public String toString() {
        return this.outfile == null ? "[unused or disposed FileMapStorage]" : this.outfile.getPath();
    }

    private FileChannel writeChannel() {
        try {
            if (this.writeChannel == null) {
                this.ensureFileExists();
                FileOutputStream fileOutputStream = new FileOutputStream(this.outfile, true);
                this.writeChannel = fileOutputStream.getChannel();
            }
            return this.writeChannel;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private FileChannel readChannel() {
        if (this.readChannel == null) {
            try {
                this.ensureFileExists();
                FileInputStream fileInputStream = new FileInputStream(this.outfile);
                this.readChannel = fileInputStream.getChannel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.readChannel;
    }

    public synchronized ByteBuffer getWriteBuffer(int n) throws IOException {
        int n2;
        if (this.master.capacity() - this.master.position() < n) {
            n2 = Math.max(16392, n + 8196);
            this.master = ByteBuffer.allocateDirect(n2);
        }
        if (this.buffer == null) {
            this.buffer = this.master.slice();
        } else {
            n2 = AbstractLines.toCharIndex(this.buffer.capacity() - this.buffer.position());
            if (n2 < n) {
                this.buffer.flip();
                this.buffer = this.master.slice();
            }
        }
        ++this.outstandingBufferCount;
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, boolean bl) throws IOException {
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            if (byteBuffer == this.buffer) {
                this.buffer = null;
            }
        }
        int n = this.size();
        int n2 = byteBuffer.position();
        byteBuffer.flip();
        if (this.writeChannel().isOpen()) {
            this.writeChannel().write(byteBuffer);
            if (bl) {
                this.writeChannel().write(ByteBuffer.wrap(OutWriter.lineSepBytes));
            }
            FileMapStorage fileMapStorage2 = this;
            synchronized (fileMapStorage2) {
                this.bytesWritten += n2 + (bl ? OutWriter.lineSepBytes.length : 0);
                --this.outstandingBufferCount;
            }
        }
        return n;
    }

    public synchronized void dispose() {
        if (Controller.log) {
            Controller.log("Disposing file map storage");
            Controller.logStack();
        }
        if (this.writeChannel != null && this.writeChannel.isOpen()) {
            try {
                this.writeChannel.close();
                this.writeChannel = null;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        if (this.readChannel != null && this.readChannel.isOpen()) {
            try {
                this.readChannel.close();
                this.readChannel = null;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        if (this.outfile != null && this.outfile.exists()) {
            try {
                this.outfile.delete();
                this.outfile = null;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        this.buffer = null;
        this.contents = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getReadBuffer(int n, int n2) throws IOException {
        Object object;
        ByteBuffer byteBuffer;
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            byteBuffer = this.contents;
            if (byteBuffer == null || (long)(n + n2) > this.mappedRange || (long)n < this.mappedStart) {
                object = this.readChannel();
                long l = n + n2;
                this.mappedStart = Math.max(0L, (long)n - 0x1400000L);
                long l2 = this.mappedRange;
                this.mappedRange = ((FileChannel)object).size();
                try {
                    try {
                        this.contents = byteBuffer = ((FileChannel)object).position(this.mappedStart).map(FileChannel.MapMode.READ_ONLY, this.mappedStart, this.mappedRange - this.mappedStart);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().log("Failed to memory map output file for reading.  Trying to read it normally.");
                        byteBuffer = ByteBuffer.allocate((int)(this.mappedRange - this.mappedStart));
                        ((FileChannel)object).position(this.mappedStart).read(byteBuffer);
                        this.contents = byteBuffer;
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log("Failed to read output file. Start:" + n + " bytes reqd=" + n2 + " mapped range=" + this.mappedRange + " previous mapped range=" + l2 + " channel size: " + ((FileChannel)object).size());
                    throw iOException;
                }
            }
            if ((long)n - this.mappedStart > (long)(byteBuffer.limit() - n2)) {
                byteBuffer.position(Math.max(0, byteBuffer.limit() - n2));
            } else {
                byteBuffer.position((int)((long)n - this.mappedStart));
            }
        }
        int n3 = Math.min(byteBuffer.limit(), n2);
        try {
            object = (ByteBuffer)byteBuffer.slice().limit(n3);
            return object;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error setting limit to " + n3 + " contents size = " + byteBuffer.limit() + " requested: read " + "buffer from " + n + " to be " + n2 + " bytes");
        }
    }

    public synchronized int size() {
        return this.bytesWritten;
    }

    public void flush() throws IOException {
        if (this.buffer != null) {
            if (Controller.log) {
                Controller.log("FILEMAP STORAGE flush(): " + this.outstandingBufferCount);
            }
            this.write(this.buffer, false);
            this.writeChannel.force(false);
            this.buffer = null;
        }
    }

    public void close() throws IOException {
        if (this.writeChannel != null) {
            this.flush();
            this.writeChannel.close();
            this.writeChannel = null;
            if (Controller.log) {
                Controller.log("FILEMAP STORAGE CLOSE.  Outstanding buffer count: " + this.outstandingBufferCount);
            }
        }
    }

    public boolean isClosed() {
        return this.writeChannel == null || !this.writeChannel.isOpen();
    }
}

