/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.StringTokenizer;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ErrWriter;
import org.netbeans.core.output2.FileMapStorage;
import org.netbeans.core.output2.HeapStorage;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.Storage;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class OutWriter
extends PrintWriter {
    private boolean trouble = false;
    private NbIO owner;
    private boolean disposed = false;
    private static final boolean USE_HEAP_STORAGE = Boolean.getBoolean("nb.output.heap") || Utilities.getOperatingSystem() == 4 || Utilities.getOperatingSystem() == 2;
    static byte[] lineSepBytes = Utilities.isWindows() ? new byte[]{0, 13, 0, 10} : new byte[]{0, 10};
    private Storage storage;
    private AbstractLines lines = new LinesImpl();
    private boolean terminated = false;
    static boolean lowDiskSpace = false;
    private int lineStart = -1;
    private int lineLength = 0;
    private boolean closed = false;

    OutWriter(NbIO nbIO) {
        this();
        this.owner = nbIO;
    }

    OutWriter() {
        super(new DummyWriter());
    }

    Storage getStorage() {
        if (this.disposed) {
            throw new IllegalStateException("Output file has been disposed!");
        }
        if (this.storage == null) {
            this.storage = USE_HEAP_STORAGE || lowDiskSpace ? new HeapStorage() : new FileMapStorage();
        }
        return this.storage;
    }

    boolean hasStorage() {
        return this.storage != null;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    boolean isEmpty() {
        return this.storage == null ? true : (this.lines == null ? true : this.lines.getLineCount() == 0);
    }

    public String toString() {
        return "OutWriter@" + System.identityHashCode(this) + " for " + this.owner + " closed ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doPrintln(String string) {
        try {
            int n = string.indexOf("\n");
            int n2 = 1;
            if (n != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
                n2 = 0;
                boolean bl = true;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("\n")) {
                        if (bl) {
                            this.doPrintln("");
                            ++n2;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                    this.doPrintln(string2);
                    ++n2;
                }
            } else {
                OutWriter outWriter = this;
                synchronized (outWriter) {
                    if (string.startsWith("\t")) {
                        char[] cArray = string.toCharArray();
                        boolean bl = false;
                        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
                        for (int i = 0; i < cArray.length; ++i) {
                            if ('\t' == cArray[i]) {
                                stringBuffer.append("        ");
                                continue;
                            }
                            stringBuffer.append(cArray[i]);
                        }
                        string = stringBuffer.toString();
                    }
                    ByteBuffer byteBuffer = this.getStorage().getWriteBuffer(AbstractLines.toByteIndex(string.length()));
                    byteBuffer.asCharBuffer().put(string);
                    byteBuffer.position(byteBuffer.position() + AbstractLines.toByteIndex(string.length()));
                    this.write(byteBuffer, true);
                }
            }
            return n2;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return 0;
        }
    }

    private void handleException(Exception exception) {
        this.setError();
        ErrorManager errorManager = ErrorManager.getDefault();
        if (errorManager.findAnnotations((Throwable)exception) == null || errorManager.findAnnotations((Throwable)exception).length == 0) {
            errorManager.annotate((Throwable)exception, NbBundle.getMessage((Class)OutWriter.class, (String)"MSG_GenericError"));
        }
        if (Controller.log) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            Controller.log("EXCEPTION: " + exception.getClass() + exception.getMessage());
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                Controller.log(stackTraceElementArray[i].toString());
            }
        }
        errorManager.notify((Throwable)exception);
    }

    public synchronized void write(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (this.checkError() || this.terminated) {
            return;
        }
        this.lines.markDirty();
        int n = byteBuffer.limit();
        this.closed = false;
        int n2 = -1;
        try {
            n2 = this.getStorage().write(byteBuffer, bl);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.threadDeathClose();
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.threadDeathClose();
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("There is not enough space on the disk") != -1) {
                lowDiskSpace = true;
                String string = NbBundle.getMessage((Class)OutWriter.class, (String)"MSG_DiskSpace", (Object)this.storage);
                ErrorManager.getDefault().annotate((Throwable)iOException, 256, iOException.getMessage(), string, (Throwable)iOException, null);
                ErrorManager.getDefault().notify((Throwable)iOException);
                this.setError();
                this.storage.dispose();
            }
            ErrorManager.getDefault().notify((Throwable)iOException);
            this.threadDeathClose();
        }
        boolean bl2 = false;
        if (n2 >= 0 && this.lineStart == -1) {
            this.lineStart = n2;
            this.lineLength += n;
            bl2 = true;
        }
        if (bl) {
            if (this.lineStart >= 0 && !this.terminated && this.lines != null) {
                if (Controller.verbose) {
                    Controller.log(this + ": Wrote " + ((ByteBuffer)byteBuffer.flip()).asCharBuffer() + " at " + n2);
                }
                if (bl2) {
                    this.lines.lineWritten(this.lineStart, this.lineLength);
                } else {
                    this.lines.lineFinished(this.lineLength);
                }
                this.lineStart = -1;
                this.lineLength = 0;
                if (this.owner != null && this.owner.hasStreamClosed()) {
                    this.owner.setStreamClosed(false);
                    this.lines.fire();
                }
            }
        } else if (bl2 && this.lineStart >= 0 && !this.terminated && this.lines != null) {
            this.lines.lineStarted(this.lineStart);
            if (this.owner != null && this.owner.hasStreamClosed()) {
                this.owner.setStreamClosed(false);
                this.lines.fire();
            }
        }
    }

    void threadDeathClose() {
        ErrWriter errWriter;
        this.terminated = true;
        if (Controller.log) {
            Controller.log(this + " Close due to termination");
        }
        if ((errWriter = this.owner.writer().err()) != null) {
            errWriter.closed = true;
        }
        this.owner.setStreamClosed(true);
        this.close();
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        if (Controller.log) {
            Controller.log(this + ": OutWriter.dispose - owner is " + (this.owner == null ? "null" : this.owner.getName()));
        }
        this.clearListeners();
        if (this.storage != null) {
            this.storage.dispose();
            this.storage = null;
        }
        if (this.lines != null) {
            this.lines.clear();
        }
        this.trouble = true;
        if (Controller.log) {
            Controller.log(this + ": Setting owner to null, trouble to true, dirty to false.  This OutWriter is officially dead.");
        }
        this.owner = null;
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        if (Controller.log) {
            Controller.log(this + ": Sending outputLineCleared to all listeners");
        }
        if (this.owner == null) {
            return;
        }
        OutWriter outWriter = this;
        synchronized (outWriter) {
            if (this.lines != null && this.lines.hasHyperlinks()) {
                int[] nArray = this.lines.allListenerLines();
                Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.owner, 0);
                for (int i = 0; i < nArray.length; ++i) {
                    OutputListener outputListener = this.lines.getListenerForLine(nArray[i]);
                    if (Controller.log) {
                        Controller.log("Clearing listener " + outputListener);
                    }
                    controllerOutputEvent.setLine(nArray[i]);
                    if (outputListener != null) {
                        outputListener.outputLineCleared((OutputEvent)controllerOutputEvent);
                        continue;
                    }
                    ErrorManager.getDefault().log(1, "Warning: issue #56826 - There was a null OutputListener on line:" + nArray[i]);
                }
            } else if (Controller.log) {
                Controller.log(this + ": No listeners to clear");
            }
        }
    }

    public synchronized boolean isClosed() {
        if (this.checkError() || this.storage == null || this.storage.isClosed()) {
            return true;
        }
        return this.closed;
    }

    public Lines getLines() {
        return this.lines;
    }

    public synchronized void close() {
        this.closed = true;
        try {
            if (this.storage != null) {
                this.storage.close();
            }
            if (this.lines != null) {
                this.lines.fire();
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public synchronized void println(String string) {
        if (this.checkError()) {
            return;
        }
        this.doPrintln(string);
    }

    public synchronized void flush() {
        if (this.checkError()) {
            return;
        }
        try {
            this.getStorage().flush();
            if (this.lines != null) {
                this.lines.fire();
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public boolean checkError() {
        return this.disposed || this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    public synchronized void write(int n) {
        if (this.checkError()) {
            return;
        }
        try {
            ByteBuffer byteBuffer = this.getStorage().getWriteBuffer(AbstractLines.toByteIndex(1));
            byteBuffer.asCharBuffer().put((char)n);
            byteBuffer.position(byteBuffer.position() + AbstractLines.toByteIndex(1));
            this.write(byteBuffer, false);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.checkError()) {
            return;
        }
        if (n2 > 0 && cArray[n] == '\t') {
            StringBuffer stringBuffer = new StringBuffer(cArray.length + 10);
            n5 = 0;
            for (n4 = 0; n4 < cArray.length; ++n4) {
                if (cArray[n4] == '\t') {
                    stringBuffer.append("        ");
                    ++n5;
                    continue;
                }
                stringBuffer.append(cArray[n4]);
            }
            cArray = stringBuffer.toString().toCharArray();
            n2 += n5 * 4;
        }
        n5 = n;
        for (n3 = n; n3 < n2 + n; ++n3) {
            n4 = cArray[n3];
            if (n4 != 10) continue;
            String string = new String(cArray, n5, n3 + 1 - n5);
            this.println(string);
            n5 = n3 + 1;
            if (n5 < n2 + n) continue;
            return;
        }
        try {
            OutWriter outWriter = this;
            synchronized (outWriter) {
                int n6 = n3 - n5;
                ByteBuffer byteBuffer = this.getStorage().getWriteBuffer(AbstractLines.toByteIndex(n6));
                byteBuffer.asCharBuffer().put(cArray, n5, n6);
                byteBuffer.position(byteBuffer.position() + AbstractLines.toByteIndex(n6));
                this.write(byteBuffer, false);
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return;
        }
    }

    public synchronized void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public synchronized void println() {
        this.doPrintln("");
    }

    public synchronized void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    public synchronized void write(String string) {
        this.write(string.toCharArray());
    }

    public synchronized void println(String string, OutputListener outputListener) throws IOException {
        this.println(string, outputListener, false);
    }

    public synchronized void println(String string, OutputListener outputListener, boolean bl) throws IOException {
        if (this.checkError()) {
            return;
        }
        int n = this.doPrintln(string);
        int n2 = this.lines.getLineCount();
        for (int i = n2 - n; i < n2; ++i) {
            this.lines.addListener(i, outputListener, bl);
            this.lines.fire();
        }
    }

    private class LinesImpl
    extends AbstractLines {
        LinesImpl() {
        }

        protected Storage getStorage() {
            return OutWriter.this.getStorage();
        }

        protected boolean isDisposed() {
            return OutWriter.this.disposed;
        }

        protected boolean isTrouble() {
            return OutWriter.this.trouble;
        }

        public Object readLock() {
            return OutWriter.this;
        }

        public boolean isGrowing() {
            return !OutWriter.this.isClosed();
        }

        protected void handleException(Exception exception) {
            OutWriter.this.handleException(exception);
        }
    }

    static class DummyWriter
    extends Writer {
        DummyWriter() {
            super(new Object());
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
        }
    }
}

