/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import org.netbeans.core.output2.OutputDocument;
import org.openide.ErrorManager;

public class WrappedTextView
extends View {
    private JTextComponent comp;
    private int charsPerLine = -1;
    private int fontDescent = -1;
    private static final Segment SEGMENT = new Segment();
    private int width = -1;
    private boolean changed = true;
    private int charWidth = -1;
    private int charHeight = -1;
    static final int[] ln = new int[3];
    private boolean aa = false;
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    static Color selectedFg;
    static Color unselectedFg;
    static Color selectedLinkFg;
    static Color unselectedLinkFg;
    static Color selectedImportantLinkFg;
    static Color unselectedImportantLinkFg;
    static Color selectedErr;
    static Color unselectedErr;
    static final Color arrowColor;
    private static Map hintsMap;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    public WrappedTextView(Element element, JTextComponent jTextComponent) {
        super(element);
        this.comp = jTextComponent;
    }

    public float getPreferredSpan(int n) {
        OutputDocument outputDocument = this.odoc();
        float f = 0.0f;
        if (outputDocument != null) {
            switch (n) {
                case 0: {
                    f = this.getCharsPerLine();
                    break;
                }
                case 1: {
                    this.updateInfo(null);
                    f = outputDocument.getLines().getLogicalLineCountIfWrappedAt(this.getCharsPerLine()) * this.charHeight() + this.fontDescent();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(n));
                }
            }
        }
        return f;
    }

    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    private int charWidth() {
        if (this.charWidth == -1) {
            return 12;
        }
        return this.charWidth;
    }

    private int charHeight() {
        if (this.charHeight == -1) {
            return 7;
        }
        return this.charHeight;
    }

    private OutputDocument odoc() {
        Document document = this.comp.getDocument();
        if (document instanceof OutputDocument) {
            return (OutputDocument)document;
        }
        return null;
    }

    public void setChanged() {
        this.changed = true;
        this.updateInfo(null);
        this.preferenceChanged(this, true, true);
    }

    private int getCharsPerLine() {
        if (this.charsPerLine == -1) {
            return 80;
        }
        return this.getWidth() / this.charWidth();
    }

    private int getWidth() {
        if (this.comp.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.comp.getParent();
            this.width = jViewport.getExtentSize().width - (this.aa ? 18 : 17);
        } else {
            this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
        }
        return this.width;
    }

    private int fontDescent() {
        if (this.fontDescent == -1) {
            return 4;
        }
        return this.fontDescent;
    }

    public void updateInfo(Graphics graphics) {
        if (this.charWidth == -1 || this.changed) {
            Serializable serializable;
            if (graphics != null) {
                this.aa = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
                serializable = graphics.getFontMetrics(this.comp.getFont());
                this.charWidth = ((FontMetrics)serializable).charWidth('m');
                this.charHeight = ((FontMetrics)serializable).getHeight();
                this.fontDescent = ((FontMetrics)serializable).getMaxDescent();
                this.charsPerLine = this.width / this.charWidth;
            }
            if (this.comp.getParent() instanceof JViewport) {
                serializable = (JViewport)this.comp.getParent();
                this.width = ((JViewport)serializable).getExtentSize().width - (this.aa ? 18 : 17);
            } else {
                this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
            }
        }
    }

    private static int margin() {
        return 9;
    }

    public void paint(Graphics graphics, Shape shape) {
        ((Graphics2D)graphics).addRenderingHints(WrappedTextView.getHints());
        this.updateInfo(graphics);
        this.comp.getHighlighter().paint(graphics);
        Rectangle rectangle = this.comp.getVisibleRect();
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n;
            Rectangle rectangle2 = graphics.getClipBounds();
            rectangle2.y = Math.max(0, rectangle2.y - this.charHeight());
            rectangle2.height += this.charHeight() * 2;
            int n2 = outputDocument.getElementCount();
            if (n2 == 0) {
                return;
            }
            int n3 = this.getCharsPerLine();
            WrappedTextView.ln[0] = n = rectangle2.y / this.charHeight;
            outputDocument.getLines().toLogicalLineIndex(ln, n3);
            int n4 = ln[0];
            int n5 = n2 - n4;
            graphics.setColor(this.comp.getForeground());
            Segment segment = SwingUtilities.isEventDispatchThread() ? SEGMENT : new Segment();
            int n6 = this.comp.getSelectionStart();
            int n7 = this.comp.getSelectionEnd();
            int n8 = rectangle2.y - rectangle2.y % this.charHeight() + this.charHeight();
            try {
                for (int i = 0; i < n5; ++i) {
                    int n9;
                    int n10;
                    int n11 = outputDocument.getLineStart(i + n4);
                    int n12 = outputDocument.getLineEnd(i + n4);
                    int n13 = n12 - n11;
                    graphics.setColor(WrappedTextView.getColorForLocation(n11, outputDocument, true));
                    outputDocument.getText(n11, n13, segment);
                    int n14 = segment.count <= n3 ? 1 : 1 + n13 / n3;
                    int n15 = 0;
                    if (i == 0 && n14 > 0) {
                        while (ln[1] > n15) {
                            this.drawArrow(graphics, n8 - (n14 - ++n15) * this.charHeight(), n15 == ln[1]);
                        }
                    }
                    while (n15 < n14 && (n10 = Math.min(n3, n13 - (n9 = n15 * n3))) > 0) {
                        this.drawLogicalLine(segment, n15, n14, graphics, n8, n11, n9, n6, n10, n7);
                        if (graphics.getColor() == unselectedLinkFg || graphics.getColor() == unselectedImportantLinkFg) {
                            this.underline(graphics, segment, n9, n10, n15, n8);
                        }
                        n8 += this.charHeight();
                        ++n15;
                    }
                    if (n8 <= rectangle2.y + rectangle2.height && i + n4 != n2 - 1) {
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
    }

    private void drawLogicalLine(Segment segment, int n, int n2, Graphics graphics, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        if (n != n2 - 1) {
            this.drawArrow(graphics, n3, n == n2 - 2);
        }
        if ((n9 = n4 + n5) >= n6 && n9 + n7 <= n8) {
            Color color = graphics.getColor();
            graphics.setColor(this.comp.getSelectionColor());
            graphics.fillRect(WrappedTextView.margin(), n3 + this.fontDescent() - this.charHeight(), n7 * this.charWidth(), this.charHeight());
            graphics.setColor(color);
        } else if (n9 <= n6 && n9 + n7 >= n6) {
            int n10 = WrappedTextView.margin() + this.charWidth() * (n6 - n9);
            int n11 = n8 > n9 + n7 ? (n7 + n9 - n6) * this.charWidth() : (n8 - n6) * this.charWidth();
            Color color = graphics.getColor();
            graphics.setColor(this.comp.getSelectionColor());
            graphics.fillRect(n10, n3 + this.fontDescent() - this.charHeight(), n11, this.charHeight());
            graphics.setColor(color);
        } else if (n9 > n6 && n9 + n7 >= n8) {
            int n12 = (n8 - n9) * this.charWidth();
            Color color = graphics.getColor();
            graphics.setColor(this.comp.getSelectionColor());
            graphics.fillRect(WrappedTextView.margin(), n3 + this.fontDescent() - this.charHeight(), n12, this.charHeight());
            graphics.setColor(color);
        }
        graphics.drawChars(segment.array, n5, n7, WrappedTextView.margin(), n3);
    }

    private void underline(Graphics graphics, Segment segment, int n, int n2, int n3, int n4) {
        int n5 = WrappedTextView.margin();
        int n6 = n5 + graphics.getFontMetrics().charsWidth(segment.array, n, n2);
        if (n3 == 0) {
            for (int i = 1; i < n2 && Character.isWhitespace(segment.array[n + i]); ++i) {
                n5 += this.charWidth();
                n6 -= this.charWidth();
            }
        } else {
            n5 = WrappedTextView.margin();
        }
        graphics.drawLine(n5, n4 + 1, n6, n4 + 1);
    }

    private void drawArrow(Graphics graphics, int n, boolean bl) {
        int n2;
        int n3 = this.charHeight();
        Color color = graphics.getColor();
        graphics.setColor(WrappedTextView.arrowColor());
        int n4 = this.getWidth() + 15;
        n += 2;
        int n5 = n2 = this.aa ? 8 : 4;
        if (this.aa) {
            graphics.drawArc(n4 - n2, n - n3 / 2, n2 + 1, n3, 265, 185);
        } else {
            graphics.drawLine(n4 - n2, n - n3 / 2, n4, n - n3 / 2);
            graphics.drawLine(n4, n - n3 / 2 + 1, n4, n + n3 / 2 - 1);
            graphics.drawLine(n4 - n2, n + n3 / 2, n4, n + n3 / 2);
        }
        if (this.aa) {
            ++n4;
        }
        if (bl) {
            n2 = this.aa ? 7 : 8;
            int[] nArray = new int[]{n4 - n2, n4 - n2 + 5, n4 - n2 + 5};
            int[] nArray2 = new int[]{n + n3 / 2, n + n3 / 2 - 5, n + n3 / 2 + 5};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        graphics.setColor(WrappedTextView.arrowColor());
        graphics.drawLine(1, n - n3 / 2, 5, n - n3 / 2);
        graphics.drawLine(1, n - n3 / 2, 1, n + n3 / 2);
        graphics.drawLine(1, n + n3 / 2, 5, n + n3 / 2);
        graphics.setColor(color);
    }

    private static Color arrowColor() {
        return arrowColor;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(0, 0, this.charWidth(), this.charHeight());
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n2 = outputDocument.getElementIndex(n);
            int n3 = outputDocument.getLineStart(n2);
            int n4 = n - n3;
            int n5 = this.getCharsPerLine();
            int n6 = outputDocument.getLines().getLogicalLineCountAbove(n2, n5);
            if (n4 > n5) {
                n6 += n4 / n5;
                n4 %= n5;
            }
            rectangle.y = n6 * this.charHeight() + this.fontDescent();
            rectangle.x = WrappedTextView.margin() + n4 * this.charWidth();
        }
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n;
            int n2 = (int)f - WrappedTextView.margin();
            int n3 = (int)f2 - this.fontDescent();
            int n4 = this.getCharsPerLine();
            WrappedTextView.ln[0] = n = n3 / this.charHeight;
            outputDocument.getLines().toLogicalLineIndex(ln, n4);
            int n5 = ln[0];
            int n6 = ln[2] - 1;
            int n7 = outputDocument.getElementCount();
            if (n7 == 0) {
                return 0;
            }
            if (n5 >= n7) {
                return outputDocument.getLength() - 1;
            }
            int n8 = outputDocument.getLineStart(n5);
            int n9 = outputDocument.getLines().length(n5);
            int n10 = n2 / this.charWidth();
            if (n10 > n9 - 1) {
                n10 = n9 - 1;
            }
            int n11 = n6 > 0 ? Math.min(outputDocument.getLineEnd(n5) - 1, n8 + ln[1] * n4 + n10) : n8 + n10;
            return n11;
        }
        return 0;
    }

    private static Color getColorForLocation(int n, Document document, boolean bl) {
        OutputDocument outputDocument = (OutputDocument)document;
        int n2 = outputDocument.getElementIndex(n);
        boolean bl2 = outputDocument.getLines().isHyperlink(n2);
        boolean bl3 = bl2 ? outputDocument.getLines().isImportantHyperlink(n2) : false;
        boolean bl4 = outputDocument.getLines().isErr(n2);
        return bl2 ? (bl3 ? (bl ? selectedImportantLinkFg : unselectedImportantLinkFg) : (bl ? selectedLinkFg : unselectedLinkFg)) : (bl ? (bl4 ? selectedErr : selectedFg) : (bl4 ? unselectedErr : unselectedFg));
    }

    static {
        arrowColor = new Color(80, 162, 80);
        hintsMap = null;
        selectedFg = UIManager.getColor("nb.output.foreground.selected");
        if (selectedFg == null) {
            Color color = selectedFg = UIManager.getColor("textText") == null ? Color.BLACK : UIManager.getColor("textText");
        }
        if ((unselectedFg = UIManager.getColor("nb.output.foreground")) == null) {
            unselectedFg = selectedFg;
        }
        if ((selectedLinkFg = UIManager.getColor("nb.output.link.foreground.selected")) == null) {
            selectedLinkFg = Color.BLUE.darker();
        }
        if ((unselectedLinkFg = UIManager.getColor("nb.output.link.foreground")) == null) {
            unselectedLinkFg = selectedLinkFg;
        }
        if ((selectedImportantLinkFg = UIManager.getColor("nb.output.link.foreground.important.selected")) == null) {
            selectedImportantLinkFg = selectedLinkFg.brighter();
        }
        if ((unselectedImportantLinkFg = UIManager.getColor("nb.output.link.foreground.important")) == null) {
            unselectedImportantLinkFg = selectedImportantLinkFg;
        }
        if ((selectedErr = UIManager.getColor("nb.output.err.foreground.selected")) == null) {
            selectedErr = new Color(164, 0, 0);
        }
        if ((unselectedErr = UIManager.getColor("nb.output.err.foreground")) == null) {
            unselectedErr = selectedErr;
        }
    }
}

