/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;

public class AquaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private Insets taInsets = new Insets(0, 0, 2, 80);
    private Color lineMiddleColor = null;
    private Color lineHlColor = null;
    private static final int BUTTON_SIZE = 19;
    private final Border cborder = new RadioButtonPseudoBorder();
    static boolean aqua14204offByOneError = System.getProperty("java.version") != null && System.getProperty("java.version").indexOf("1.4.2_04") > -1;
    private static final int ICON_WIDTH = 11;
    private static final int ICON_HEIGHT = 8;
    private static final int[] xpoints = new int[20];
    private static final int[] ypoints = new int[20];
    private static BufferedImage img = null;
    static /* synthetic */ Class class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon;
    static /* synthetic */ Class class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon;

    public AquaEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public void install() {
        super.install();
        this.scroll().setMinimumXposition(10);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new AquaEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new OSXTabLayout();
    }

    public Insets getTabAreaInsets() {
        return this.taInsets;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected boolean isAntialiased() {
        return true;
    }

    protected Font createFont() {
        return UIManager.getFont("Label.font");
    }

    protected int createRepaintPolicy() {
        return 95;
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        boolean bl;
        boolean bl2 = this.selectionModel.getSelectedIndex() >= this.getFirstVisibleTab() && this.selectionModel.getSelectedIndex() <= this.getLastVisibleTab();
        super.processMouseWheelEvent(mouseWheelEvent);
        boolean bl3 = bl = this.selectionModel.getSelectedIndex() >= this.getFirstVisibleTab() && this.selectionModel.getSelectedIndex() <= this.getLastVisibleTab();
        if (bl2 != bl) {
            Component[] componentArray = this.displayer.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].repaint();
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 7;
        }
        if (n % 2 == 0) {
            ++n;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] abstractButtonArray = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        AquaEditorTabDisplayerUI.configureButton(abstractButtonArray[0], new LeftIcon());
        AquaEditorTabDisplayerUI.configureButton(abstractButtonArray[1], new RightIcon());
        AquaEditorTabDisplayerUI.configureButton(abstractButtonArray[2], new DownIcon());
        abstractButtonArray[0].setPreferredSize(new Dimension(19, 19));
        abstractButtonArray[1].setPreferredSize(new Dimension(19, 19));
        abstractButtonArray[2].setPreferredSize(new Dimension(19, 19));
        abstractButtonArray[0].setBorder(this.cborder);
        abstractButtonArray[1].setBorder(this.cborder);
        abstractButtonArray[2].setBorder(this.cborder);
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return abstractButtonArray;
    }

    private static void configureButton(JButton jButton, Icon icon) {
        jButton.setIcon(icon);
        jButton.setText(null);
        jButton.putClientProperty("hideActionText", Boolean.TRUE);
        jButton.setFocusable(false);
        jButton.setRolloverEnabled(false);
        jButton.setOpaque(false);
    }

    protected void paintAfterTabs(Graphics graphics) {
        int n = (this.displayer.getHeight() - 2) / 2 + 0 - 1 + this.getTabAreaInsets().top + 1;
        if (this.lineMiddleColor == null) {
            this.lineMiddleColor = ColorUtil.getMiddle(UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        }
        graphics.setColor(this.lineMiddleColor);
        int n2 = this.getTabsAreaWidth() - 14;
        int n3 = this.displayer.getWidth() - 9;
        if (this.displayer.getModel().size() > 0 && !this.scroll().isLastTabClipped()) {
            int n4 = this.scroll().getLastVisibleTab(this.displayer.getWidth());
            n2 = this.scroll().getX(n4) + this.scroll().getW(n4) + 1;
        } else if (this.displayer.getModel().size() == 0) {
            n2 = 6;
        }
        if (this.scroll().getOffset() >= 0) {
            graphics.drawLine(6, n, 13, n);
        }
        graphics.drawLine(n2, n, n3, n);
        if (this.lineHlColor == null) {
            this.lineHlColor = ColorUtil.getMiddle(this.lineMiddleColor, UIManager.getColor("control"));
        }
        graphics.setColor(this.lineHlColor);
        graphics.drawLine(n2, n + 1, n3, n + 1);
        if (this.scroll().getOffset() > 0) {
            graphics.drawLine(6, n + 1, 10, n + 1);
        }
    }

    private static final void createImages() {
        img = new BufferedImage(60, 20, 3);
        JRadioButton jRadioButton = new JRadioButton();
        CellRendererPane cellRendererPane = new CellRendererPane();
        cellRendererPane.add(jRadioButton);
        jRadioButton.setBounds(0, 0, 80, 20);
        jRadioButton.setBackground(null);
        jRadioButton.setOpaque(false);
        jRadioButton.getModel().setRollover(false);
        jRadioButton.setRolloverEnabled(false);
        jRadioButton.getModel().setPressed(true);
        jRadioButton.setSelected(false);
        Graphics graphics = img.getGraphics();
        jRadioButton.paint(graphics);
        graphics.translate(20, 0);
        jRadioButton.setSelected(true);
        jRadioButton.paint(graphics);
        graphics.translate(20, 0);
        jRadioButton.setEnabled(false);
        jRadioButton.paint(graphics);
    }

    private class RadioButtonPseudoBorder
    implements Border {
        public RadioButtonPseudoBorder() {
            if (img == null) {
                AquaEditorTabDisplayerUI.createImages();
            }
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(3, 3, 3, 3);
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Icon icon = ((JButton)component).getIcon();
            int n5 = 0;
            if (!component.isEnabled()) {
                n5 = 40;
            } else {
                boolean bl;
                boolean bl2 = AquaEditorTabDisplayerUI.this.selectionModel.getSelectedIndex() != -1 && AquaEditorTabDisplayerUI.this.displayer.isActive() && (icon.getClass() == (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon == null ? (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon = AquaEditorTabDisplayerUI.class$("org.netbeans.swing.tabcontrol.plaf.AquaEditorTabDisplayerUI$LeftIcon")) : class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$LeftIcon) && AquaEditorTabDisplayerUI.this.selectionModel.getSelectedIndex() < AquaEditorTabDisplayerUI.this.getFirstVisibleTab() || icon.getClass() == (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon == null ? (class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon = AquaEditorTabDisplayerUI.class$("org.netbeans.swing.tabcontrol.plaf.AquaEditorTabDisplayerUI$RightIcon")) : class$org$netbeans$swing$tabcontrol$plaf$AquaEditorTabDisplayerUI$RightIcon) && AquaEditorTabDisplayerUI.this.selectionModel.getSelectedIndex() > AquaEditorTabDisplayerUI.this.getLastVisibleTab()) ? true : (bl = false);
                if (bl) {
                    n5 = 20;
                }
                if (bl) {
                    component.setForeground(new Color(0, 64, 128));
                } else {
                    component.setForeground(UIManager.getColor("controlDkShadow"));
                }
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(-n5, -1.0);
            graphics2D.drawRenderedImage(img, affineTransform);
            ((LeftIcon)icon).dontpaint = false;
            icon.paintIcon(component, graphics, n + n3 / 4 + 2, n2 + n3 / 4 + 3);
            ((LeftIcon)icon).dontpaint = true;
        }
    }

    private static class DownIcon
    extends LeftIcon {
        private DownIcon() {
        }

        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            if (this.dontpaint) {
                return;
            }
            n2 -= 5;
            if (aqua14204offByOneError) {
                ++n;
            }
            if ((n3 = this.getIconWidth()) % 2 == 0) {
                --n3;
            }
            int n4 = this.getIconHeight();
            xpoints[0] = n - 1;
            ypoints[0] = n2 + n4 / 2;
            xpoints[1] = n + n3 - 2;
            ypoints[1] = n2 + n4 / 2;
            xpoints[2] = n + n3 / 2 - 1;
            ypoints[2] = n2 + n4;
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class RightIcon
    extends LeftIcon {
        private RightIcon() {
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 7;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.dontpaint) {
                return;
            }
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight() + 1;
            xpoints[0] = n + 3;
            ypoints[0] = n2 -= 2;
            xpoints[1] = n + 3;
            ypoints[1] = n2 + n4 + 1;
            xpoints[2] = n + (n3 - 4) + 1;
            ypoints[2] = n2 + n4 / 2;
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class LeftIcon
    implements Icon {
        protected boolean dontpaint = true;

        private LeftIcon() {
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.dontpaint) {
                return;
            }
            if (!aqua14204offByOneError) {
                --n;
            }
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight() + 1;
            xpoints[0] = n + (n3 - 4);
            ypoints[0] = (n2 -= 3) + 1;
            xpoints[1] = xpoints[0];
            ypoints[1] = n2 + n4 + 1;
            xpoints[2] = n + 2;
            ypoints[2] = n2 + n4 / 2 + 1;
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private class OSXTabLayout
    implements LayoutManager {
        private OSXTabLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Insets insets = AquaEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] componentArray = container.getComponents();
            int n = container.getWidth() - insets.right + 3;
            int n2 = 0;
            int n3 = (AquaEditorTabDisplayerUI.this.displayer.getHeight() - 2) / 2 + 0 + AquaEditorTabDisplayerUI.this.getTabAreaInsets().top;
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = componentArray[i].getPreferredSize();
                n2 = n3 - dimension.height / 2;
                int n4 = Math.min(dimension.width, container.getWidth() - n);
                componentArray[i].setBounds(n, n2, n4, Math.min(dimension.height, container.getHeight()));
                n += dimension.width;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return AquaEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return AquaEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

