/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BasicTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ScrollingTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabState;

public abstract class BasicScrollingTabDisplayerUI
extends BasicTabDisplayerUI {
    protected AbstractButton[] controlButtons;
    protected LayoutManager layoutManager;
    private Rectangle scratch = new Rectangle();
    private int lastKnownModelSize = Integer.MAX_VALUE;
    static SoftReference ctx = null;

    public BasicScrollingTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    protected final TabLayoutModel createLayoutModel() {
        DefaultTabLayoutModel defaultTabLayoutModel = new DefaultTabLayoutModel(this.displayer.getModel(), this.displayer);
        return new ScrollingTabLayoutModel(defaultTabLayoutModel, this.selectionModel, this.displayer.getModel());
    }

    protected TabState createTabState() {
        return new ScrollingTabState();
    }

    protected HierarchyListener createHierarchyListener() {
        return new ScrollingHierarchyListener();
    }

    public void makeTabVisible(int n) {
        if (this.scroll().makeVisible(n, this.getTabsAreaWidth())) {
            this.getTabsVisibleArea(this.scratch);
            this.displayer.repaint(this.scratch.x, this.scratch.y, this.scratch.width, this.scratch.height);
        }
    }

    protected final int getTabsAreaWidth() {
        int n = this.displayer.getWidth();
        Insets insets = this.getTabAreaInsets();
        return n - (insets.left + insets.right);
    }

    protected final int getLastVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getLastVisibleTab(this.getTabsAreaWidth());
    }

    protected final int getFirstVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getFirstVisibleTab(this.getTabsAreaWidth());
    }

    protected void install() {
        super.install();
        this.layoutManager = this.createLayout();
        this.controlButtons = this.createControlButtons();
        this.installControlButtons();
        ((ScrollingTabLayoutModel)this.layoutModel).setPixelsToAddToSelection(this.defaultRenderer.getPixelsToAddToSelection());
    }

    protected void uninstall() {
        super.uninstall();
        this.displayer.setLayout(null);
        this.displayer.removeAll();
    }

    protected abstract LayoutManager createLayout();

    protected abstract AbstractButton[] createControlButtons();

    protected ComponentListener createComponentListener() {
        return new ScrollingDisplayerComponentListener();
    }

    protected void modelChanged() {
        int n;
        this.scroll().clearCachedData();
        int n2 = this.selectionModel.getSelectedIndex();
        if (n2 >= this.scroll().getCachedFirstVisibleTab() && n2 < this.scroll().getCachedLastVisibleTab()) {
            this.makeTabVisible(this.selectionModel.getSelectedIndex());
        }
        if ((n = this.displayer.getModel().size()) < this.lastKnownModelSize) {
            this.scroll().ensureAvailableSpaceUsed(true);
        }
        this.lastKnownModelSize = n;
        super.modelChanged();
    }

    protected void installControlButtons() {
        this.displayer.setLayout(this.layoutManager);
        for (int i = 0; i < this.controlButtons.length; ++i) {
            this.displayer.add(this.controlButtons[i]);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected final ScrollingTabLayoutModel scroll() {
        return (ScrollingTabLayoutModel)this.layoutModel;
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        this.tabState.clearTransientStates();
        int n2 = this.scroll().getOffset();
        if (n > 0 && n2 < this.displayer.getModel().size() - 1) {
            if (this.scroll().isLastTabClipped()) {
                this.scroll().setOffset(n2 + 1);
            }
        } else if (n < 0) {
            if (n2 >= 0) {
                this.scroll().setOffset(n2 - 1);
            }
        } else {
            return;
        }
        this.displayer.repaint();
    }

    public static Graphics2D getOffscreenGraphics() {
        BufferedImage bufferedImage = null;
        if (ctx != null) {
            bufferedImage = (BufferedImage)ctx.get();
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(bufferedImage);
        }
        return (Graphics2D)bufferedImage.getGraphics();
    }

    protected static class OnPressButton
    extends JButton {
        public OnPressButton(Action action) {
            super(action);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (this.isEnabled()) {
                if (mouseEvent.getID() == 501) {
                    this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
                }
            }
        }
    }

    protected static class TimerButton
    extends JButton
    implements ActionListener {
        Timer timer = null;
        Image disabledImage = null;
        Image enabledImage = null;
        int count = 0;

        public TimerButton(Action action) {
            super(action);
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            this.performAction();
            Timer timer = this.getTimer();
            if (timer.isRunning()) {
                return;
            }
            this.repaint();
            timer.setDelay(400);
            timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (this.isEnabled()) {
                if (mouseEvent.getID() == 501) {
                    this.startTimer();
                    return;
                }
            }
            if (mouseEvent.getID() == 502) {
                this.stopTimer();
                return;
            }
            super.processMouseEvent(mouseEvent);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            if (focusEvent.getID() == 1005) {
                this.stopTimer();
            }
        }

        protected void paintComponent(Graphics graphics) {
            boolean bl = this.isEnabled();
            if (bl && this.enabledImage == null || !bl && this.disabledImage == null) {
                GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
                BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(16, 18, 2);
                Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, 16, 18);
                graphics2D.setClip(0, 0, 16, 18);
                graphics2D.setComposite(composite);
                super.paintComponent(graphics2D);
                graphics2D.dispose();
                if (bl) {
                    this.enabledImage = bufferedImage;
                } else {
                    this.disabledImage = bufferedImage;
                }
            }
            graphics.drawImage(bl ? this.enabledImage : this.disabledImage, 0, 0, null);
        }
    }

    protected class ScrollingHierarchyListener
    extends AbstractTabDisplayerUI.DisplayerHierarchyListener {
        protected ScrollingHierarchyListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            super.hierarchyChanged(hierarchyEvent);
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && BasicScrollingTabDisplayerUI.this.displayer.isShowing() && BasicScrollingTabDisplayerUI.this.tabState != null && BasicScrollingTabDisplayerUI.this.selectionModel != null) {
                BasicScrollingTabDisplayerUI.this.tabState.setActive(BasicScrollingTabDisplayerUI.this.displayer.isActive());
                BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
            }
        }
    }

    protected class ScrollingDisplayerComponentListener
    extends ComponentAdapter {
        protected ScrollingDisplayerComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
        }
    }

    protected class ScrollingTabState
    extends BasicTabDisplayerUI.BasicTabState {
        protected ScrollingTabState() {
            super(BasicScrollingTabDisplayerUI.this);
        }

        public int getState(int n) {
            int n2 = super.getState(n);
            int n3 = BasicScrollingTabDisplayerUI.this.getFirstVisibleTab();
            int n4 = BasicScrollingTabDisplayerUI.this.getLastVisibleTab();
            if (n < n3 || n > n4) {
                return 64;
            }
            if (n3 == n4 && n3 == n && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1) {
                n2 |= 3;
            } else if (BasicScrollingTabDisplayerUI.this.getTabsAreaWidth() < BasicScrollingTabDisplayerUI.this.scroll().getMinimumLeftClippedWidth() + BasicScrollingTabDisplayerUI.this.scroll().getMinimumRightClippedWidth() && n == n3 && n4 == n3 - 1 && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1 && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                n2 |= 2;
            } else {
                if (n == n3 && BasicScrollingTabDisplayerUI.this.scroll().getOffset() == n3) {
                    n2 |= 2;
                }
                if (n == n4 && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                    n2 |= 1;
                }
            }
            return n2;
        }
    }
}

