/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.MetalEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class MetalViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_LEFT_PAD = 5;
    private static final int ICON_X_RIGHT_PAD = 2;
    private static final int BUMP_X_PAD = 5;
    private static final int BUMP_Y_PAD = 4;
    private static AbstractViewTabDisplayerUI.IconLoader closeIcon;
    private static Color inactBgColor;
    private static Color actBgColor;
    private static Color borderHighlight;
    private static Color borderShadow;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private MetalViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 21 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 4;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.paintBottomBorder(graphics, jComponent);
    }

    private void paintBottomBorder(Graphics graphics, JComponent jComponent) {
        Color color = this.isActive() ? MetalViewTabDisplayerUI.getActBgColor() : MetalViewTabDisplayerUI.getInactBgColor();
        graphics.setColor(color);
        Rectangle rectangle = jComponent.getBounds();
        graphics.fillRect(1, rectangle.height - 3, rectangle.width - 1, 2);
        graphics.setColor(this.getBorderShadow());
        graphics.drawLine(1, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            AbstractViewTabDisplayerUI.PinButton pinButton = this.configurePinButton(n);
            boolean bl = pinButton != null && pinButton.getOrientation() != TabDisplayer.ORIENTATION_INVISIBLE;
            int n7 = bl ? this.pinButton.getWidth() + 1 : 0;
            int n8 = 0;
            if (this.displayer.isShowCloseButton()) {
                String string2 = this.findIconPath(n);
                Icon icon = closeIcon.obtainIcon(string2);
                int n9 = icon.getIconWidth();
                n8 = n9 + 5 + 2 + n7;
                n6 = n4 - 10 - n8;
                this.getCloseIconRect(this.tempRect, n);
                icon.paintIcon(this.getDisplayer(), graphics, this.tempRect.x, this.tempRect.y);
            } else {
                this.tempRect.x = n2 + (n4 - 2);
                this.tempRect.y = !bl ? 0 : this.displayer.getHeight() / 2 - this.pinButton.getPreferredSize().height / 2;
                n6 = n4 - 10 - n7;
                n8 = n7 + 5;
            }
            n6 = (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 5), (int)(n5 - fontMetrics.getDescent() - 4), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
            int n10 = n4 - (5 + n6 + 5 + n8);
            if (n10 > 0) {
                this.paintBump(n, graphics, n2 + 5 + n6 + 5, n3 + 4, n10, n5 - 8);
            }
            if (bl) {
                if (this.tempRect.x - n7 < n2 + 5 - 1) {
                    this.pinButton.setVisible(false);
                } else {
                    this.pinButton.setVisible(true);
                    this.pinButton.setLocation(this.tempRect.x - n7, this.tempRect.y);
                }
            } else {
                this.pinButton.setVisible(false);
            }
        } else {
            n6 = n4 - 10;
            HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 5), (int)(n5 - fontMetrics.getDescent() - 4), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = this.getBorderHighlight();
        Color color2 = this.getBorderShadow();
        boolean bl = this.isSelected(n);
        boolean bl2 = n == 0;
        boolean bl3 = n == this.getDataModel().size() - 1;
        graphics.translate(n2, n3);
        graphics.setColor(color2);
        if (!bl2) {
            graphics.drawLine(0, 0, 0, n5 - 5);
        }
        if (!bl) {
            graphics.drawLine(1, n5 - 5, bl3 ? n4 - 1 : n4, n5 - 5);
        }
        graphics.setColor(color);
        graphics.drawLine(1, 0, n4 - 1, 0);
        if (bl2) {
            graphics.drawLine(0, 0, 0, n5 - 2);
        }
        if (!bl) {
            graphics.drawLine(0, n5 - 4, bl3 ? n4 - 1 : n4, n5 - 4);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention(n);
        if (bl2 && !bl3) {
            graphics.setColor(MetalViewTabDisplayerUI.getActBgColor());
            graphics.fillRect(n2, n3, n4, n5 - 3);
        } else if (bl3) {
            graphics.setColor(MetalEditorTabCellRenderer.ATTENTION_COLOR);
            graphics.fillRect(n2, n3, n4, n5 - 3);
        } else {
            graphics.setColor(MetalViewTabDisplayerUI.getInactBgColor());
            graphics.fillRect(n2, n3, n4, n5 - 3);
        }
    }

    private void paintBump(int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        ColorUtil.paintViewTabBump(graphics, n2, n3, n4, n5, this.isFocused(n) ? 4 : 2);
    }

    static Color getInactBgColor() {
        if (inactBgColor == null && (inactBgColor = (Color)UIManager.get("inactiveCaption")) == null) {
            inactBgColor = new Color(204, 204, 204);
        }
        return inactBgColor;
    }

    static Color getActBgColor() {
        if (actBgColor == null && (actBgColor = (Color)UIManager.get("activeCaption")) == null) {
            actBgColor = new Color(204, 204, 255);
        }
        return actBgColor;
    }

    private Color getBorderHighlight() {
        if (borderHighlight == null) {
            borderHighlight = MetalViewTabDisplayerUI.getInactBgColor().brighter();
        }
        return borderHighlight;
    }

    private Color getBorderShadow() {
        if (borderShadow == null) {
            borderShadow = MetalViewTabDisplayerUI.getInactBgColor().darker();
        }
        return borderShadow;
    }

    private String findIconPath(int n) {
        if (this.controller.isClosePressed() == n) {
            return "org/netbeans/swing/tabcontrol/resources/met-bigclose-pressed.gif";
        }
        return this.controller.isMouseInCloseButton() == n ? "org/netbeans/swing/tabcontrol/resources/met-bigclose-focus.gif" : "org/netbeans/swing/tabcontrol/resources/met-bigclose-normal.gif";
    }

    private Rectangle getCloseIconRect(Rectangle rectangle, int n) {
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        int n2 = tabLayoutModel.getX(n);
        int n3 = tabLayoutModel.getW(n);
        String string = this.findIconPath(n);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
        Icon icon = closeIcon.obtainIcon(string);
        int n4 = icon.getIconWidth();
        int n5 = icon.getIconHeight();
        rectangle.x = n2 + n3 - n4 - 2;
        rectangle.y = this.getCenteredIconY(icon, n);
        rectangle.width = n4;
        rectangle.height = n5;
        return rectangle;
    }

    public AbstractViewTabDisplayerUI.Controller getController() {
        return this.controller;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        HashMap<Object, String> hashMap = new HashMap<Object, String>(6);
        hashMap.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-east.gif");
        hashMap.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-west.gif");
        hashMap.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-south.gif");
        hashMap.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-center.gif");
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>(6);
        hashMap2.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-east.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-west.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-south.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-center.gif");
        HashMap<Object, String> hashMap3 = new HashMap<Object, String>(6);
        hashMap3.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-east.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-west.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-south.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-center.gif");
        return new AbstractViewTabDisplayerUI.PinButton(hashMap, hashMap2, hashMap3);
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        protected int inCloseIconRect(Point point) {
            if (!MetalViewTabDisplayerUI.this.displayer.isShowCloseButton()) {
                return -1;
            }
            int n = MetalViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (n < 0 || !MetalViewTabDisplayerUI.this.isSelected(n)) {
                return -1;
            }
            return MetalViewTabDisplayerUI.this.getCloseIconRect(MetalViewTabDisplayerUI.this.tempRect, n).contains(point) ? n : -1;
        }

        protected boolean inPinButtonRect(Point point) {
            if (!MetalViewTabDisplayerUI.this.pinButton.isVisible()) {
                return false;
            }
            Point point2 = SwingUtilities.convertPoint(MetalViewTabDisplayerUI.this.displayer, point, MetalViewTabDisplayerUI.this.pinButton);
            return MetalViewTabDisplayerUI.this.pinButton.contains(point2);
        }
    }
}

