/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class WinClassicEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final TabPainter leftClip = new WinClassicLeftClipPainter();
    private static final TabPainter rightClip = new WinClassicRightClipPainter();
    private static final TabPainter normal = new WinClassicPainter();
    private static final Color GTK_TABBED_PANE_BACKGROUND_1 = new Color(100, 100, 100);
    private static final Color GTK_TABBED_PANE_BACKGROUND_2 = new Color(255, 255, 255);
    static final Color ATTENTION_COLOR = new Color(255, 238, 120);
    private static boolean isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    private static final Insets INSETS = new Insets(0, 2, 0, 10);

    public WinClassicEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(28, 32));
    }

    public Color getSelectedForeground() {
        return UIManager.getColor("textText");
    }

    public Color getForeground() {
        return this.getSelectedForeground();
    }

    public int getPixelsToAddToSelection() {
        return 4;
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 28 : 14;
        return dimension;
    }

    private static final Color getSelGradientColor() {
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            return GTK_TABBED_PANE_BACKGROUND_1;
        }
        return UIManager.getColor("winclassic_tab_sel_gradient");
    }

    private static final Color getSelGradientColor2() {
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            return GTK_TABBED_PANE_BACKGROUND_2;
        }
        return UIManager.getColor("TabbedPane.background");
    }

    private static class WinClassicRightClipPainter
    implements TabPainter {
        private WinClassicRightClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component component) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = isGenericUI ? 0 : 1;
            int n3 = component.getWidth();
            int n4 = winClassicEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
                if (winClassicEditorTabCellRenderer.isSelected() && i == polygon.npoints - 4) {
                    graphics.setColor(winClassicEditorTabCellRenderer.isActive() ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("control"));
                } else if (i == polygon.npoints - 4) break;
                if (i == polygon.npoints - 3) break;
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            boolean bl;
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            boolean bl2 = bl = winClassicEditorTabCellRenderer.isSelected() && winClassicEditorTabCellRenderer.isActive() || (winClassicEditorTabCellRenderer.isClipLeft() || winClassicEditorTabCellRenderer.isClipRight()) && winClassicEditorTabCellRenderer.isPressed();
            if (bl) {
                ((Graphics2D)graphics).setPaint(ColorUtil.getGradientPaint(0.0f, 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor(), winClassicEditorTabCellRenderer.getWidth(), 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor2()));
            } else if (!winClassicEditorTabCellRenderer.isAttention()) {
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
            } else {
                graphics.setColor(ATTENTION_COLOR);
            }
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.fillPolygon(polygon);
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class WinClassicLeftClipPainter
    implements TabPainter {
        private WinClassicLeftClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Polygon getInteriorPolygon(Component component) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = -3;
            int n2 = isGenericUI ? 0 : 1;
            int n3 = component.getWidth() + 3;
            int n4 = winClassicEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n3 - 3, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + insets.top + 2);
            polygon.addPoint(n + n3 - 1, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
                if (i != polygon.npoints - 4) continue;
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
                graphics.drawLine(nArray[i] + 1, nArray2[i] + 1, nArray[i] + 2, nArray2[i] + 2);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            boolean bl;
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            boolean bl2 = bl = winClassicEditorTabCellRenderer.isSelected() && winClassicEditorTabCellRenderer.isActive() || (winClassicEditorTabCellRenderer.isClipLeft() || winClassicEditorTabCellRenderer.isClipRight()) && winClassicEditorTabCellRenderer.isPressed();
            if (bl) {
                ((Graphics2D)graphics).setPaint(ColorUtil.getGradientPaint(0.0f, 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor(), winClassicEditorTabCellRenderer.getWidth(), 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor2()));
            } else if (!winClassicEditorTabCellRenderer.isAttention()) {
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
            } else {
                graphics.setColor(ATTENTION_COLOR);
            }
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.fillPolygon(polygon);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }
    }

    private static class WinClassicPainter
    implements TabPainter {
        private WinClassicPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            if (!((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
                return;
            }
            Insets insets = this.getBorderInsets(jComponent);
            rectangle.y = rectangle2.y + insets.top;
            rectangle.height = rectangle2.height - rectangle.y;
            rectangle.x = rectangle2.x + rectangle2.width - 10;
            rectangle.width = 5;
            rectangle.y += rectangle.height / 2 - 2;
            rectangle.height = 5;
        }

        public Polygon getInteriorPolygon(Component component) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = winClassicEditorTabCellRenderer.isLeftmost() ? 1 : 0;
            int n2 = isGenericUI ? 0 : 1;
            int n3 = winClassicEditorTabCellRenderer.isLeftmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = winClassicEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n3 - 3, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + insets.top + 2);
            polygon.addPoint(n + n3 - 1, n2 + n4 - 2);
            polygon.addPoint(n, n2 + n4 - 2);
            return polygon;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
                if (i != polygon.npoints - 4) continue;
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
                graphics.drawLine(nArray[i] + 1, nArray2[i] + 1, nArray[i] + 2, nArray2[i] + 2);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            boolean bl;
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            boolean bl2 = bl = winClassicEditorTabCellRenderer.isSelected() && winClassicEditorTabCellRenderer.isActive() || (winClassicEditorTabCellRenderer.isClipLeft() || winClassicEditorTabCellRenderer.isClipRight()) && winClassicEditorTabCellRenderer.isPressed();
            if (bl) {
                ((Graphics2D)graphics).setPaint(ColorUtil.getGradientPaint(0.0f, 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor(), winClassicEditorTabCellRenderer.getWidth(), 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor2()));
            } else if (!winClassicEditorTabCellRenderer.isAttention()) {
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
            } else {
                graphics.setColor(ATTENTION_COLOR);
            }
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.fillPolygon(polygon);
            if (!this.supportsCloseButton((JComponent)component)) {
                return;
            }
            Rectangle rectangle = new Rectangle();
            this.getCloseButtonRectangle(winClassicEditorTabCellRenderer, rectangle, new Rectangle(0, 0, winClassicEditorTabCellRenderer.getWidth(), winClassicEditorTabCellRenderer.getHeight()));
            if (winClassicEditorTabCellRenderer.inCloseButton()) {
                graphics.setColor(UIManager.getColor("control"));
                graphics.fillRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 3, rectangle.height + 3);
                graphics.setColor(UIManager.getColor("textText"));
            } else {
                graphics.setColor(winClassicEditorTabCellRenderer.getForeground());
            }
            graphics.setColor(winClassicEditorTabCellRenderer.getForeground());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y);
            if (winClassicEditorTabCellRenderer.isSelected()) {
                graphics.setColor(UIManager.getColor("controlShadow"));
            } else if (!winClassicEditorTabCellRenderer.isSelected()) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
            }
            if (winClassicEditorTabCellRenderer.inCloseButton()) {
                rectangle.x -= 2;
                rectangle.y -= 2;
                rectangle.width += 4;
                rectangle.height += 4;
                if (!winClassicEditorTabCellRenderer.isPressed()) {
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                } else {
                    graphics.setColor(UIManager.getColor("controlShadow").darker());
                }
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                if (!winClassicEditorTabCellRenderer.isPressed()) {
                    graphics.setColor(UIManager.getColor("controlShadow").darker());
                } else {
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                }
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
            }
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return ((AbstractTabCellRenderer)jComponent).isShowCloseButton();
        }
    }
}

