/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class WinXPEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final int TOP_INSET = 0;
    private static final int LEFT_INSET = 3;
    private static final int RIGHT_INSET = 0;
    static final int BOTTOM_INSET = 3;
    private static final TabPainter leftClip = new WinXPLeftClipPainter();
    private static final TabPainter rightClip = new WinXPRightClipPainter();
    private static final TabPainter normal = new WinXPPainter();

    public WinXPEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(32, 42));
    }

    public int getPixelsToAddToSelection() {
        return 4;
    }

    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 32 : 16;
        return dimension;
    }

    private static final Color getTopInactiveSelectedColor() {
        Color color = UIManager.getColor("tab_sel_fill_bright");
        if (color == null) {
            color = new Color(252, 250, 244);
        }
        return color;
    }

    private static final Color getBottomInactiveSelectedColor() {
        Color color = UIManager.getColor("tab_sel_fill_dark");
        if (color == null) {
            color = new Color(243, 241, 224);
        }
        return color;
    }

    private static final Color getTopActiveSelectedColor() {
        Color color = UIManager.getColor("tab_focus_fill_bright");
        if (color == null) {
            color = new Color(210, 220, 243);
        }
        return color;
    }

    private static final Color getBottomActiveSelectedColor() {
        Color color = UIManager.getColor("tab_focus_fill_dark");
        if (color == null) {
            color = new Color(238, 242, 253);
        }
        return color;
    }

    private static final Color getTopUnselectedColor() {
        Color color = UIManager.getColor("tab_unsel_fill_bright");
        if (color == null) {
            color = Color.white;
        }
        return color;
    }

    private static final Color getBottomUnselectedColor() {
        Color color = UIManager.getColor("tab_unsel_fill_dark");
        if (color == null) {
            color = new Color(236, 235, 229);
        }
        return color;
    }

    static final Color getBorderColor() {
        Color color = UIManager.getColor("tab_bottom_border");
        if (color == null) {
            color = new Color(127, 187, 185);
        }
        return color;
    }

    private static final Color getCloseButtonColor(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        String string = winXPEditorTabCellRenderer.inCloseButton() ? "close_button_highlight" : "close_button";
        Color color = UIManager.getColor(string);
        if (color == null) {
            color = winXPEditorTabCellRenderer.inCloseButton() ? new Color(172, 57, 28) : Color.black;
        }
        return color;
    }

    static final Color getSelectedTabBottomLineColor() {
        Color color = UIManager.getColor("tab_sel_bottom_border");
        if (color == null) {
            color = new Color(238, 235, 218);
        }
        return color;
    }

    private static final Color getShadowBorderColor(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        return WinXPEditorTabCellRenderer.getBorderColor();
    }

    private static final Color getHighlightBorderColor(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        return WinXPEditorTabCellRenderer.getBorderColor();
    }

    private static final Color getHighlightColor() {
        Color color = UIManager.getColor("TabbedPane.selectionIndicator");
        if (color == null) {
            color = new Color(255, 199, 60);
        }
        return color;
    }

    private static final Color getTopHighlightColor() {
        Color color = UIManager.getColor("tab_highlight_header");
        if (color == null) {
            color = new Color(230, 139, 44);
        }
        return color;
    }

    public Color getSelectedActivatedForeground() {
        Color color = UIManager.getColor("textText");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    private static final Color getRightEdgeSelectedShadow() {
        Color color = UIManager.getColor("close_button_border_focus");
        if (color == null) {
            color = new Color(181, 201, 243);
        }
        return color;
    }

    public Color getSelectedActivatedBackground() {
        Color color = UIManager.getColor("tab_focus_fill_bright");
        Color color2 = UIManager.getColor("tab_focus_fill_dark");
        if (color == null) {
            color = new Color(238, 242, 253);
        }
        if (color2 == null) {
            color2 = new Color(210, 220, 243);
        }
        Color color3 = ColorUtil.getMiddle(color, color2);
        return color3;
    }

    public static Color getCloseButtonAAColor(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        Color color = winXPEditorTabCellRenderer.getBackground();
        Color color2 = WinXPEditorTabCellRenderer.getCloseButtonColor(winXPEditorTabCellRenderer);
        Color color3 = ColorUtil.getMiddle(color2, color);
        int n = winXPEditorTabCellRenderer.inCloseButton() ? 35 : 74;
        color3 = ColorUtil.adjustBy(color3, n *= ColorUtil.isBrighter(color, color2) ? 1 : -1);
        return color3;
    }

    private static Color getCloseButtonBorderColor(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        String string = winXPEditorTabCellRenderer.isActive() && winXPEditorTabCellRenderer.isSelected() ? "close_button_border_focus" : (winXPEditorTabCellRenderer.isSelected() ? "close_button_border_selected" : "close_button_border_unsel");
        Color color = UIManager.getColor(string);
        if (color == null) {
            color = winXPEditorTabCellRenderer.isActive() && winXPEditorTabCellRenderer.isSelected() ? new Color(181, 201, 243) : (winXPEditorTabCellRenderer.isSelected() ? new Color(203, 202, 187) : new Color(200, 201, 192));
        }
        return color;
    }

    public static Color getCloseButtonHighlight(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        Color color;
        Color color2 = winXPEditorTabCellRenderer.isPressed() && winXPEditorTabCellRenderer.inCloseButton() ? WinXPEditorTabCellRenderer.getCloseButtonBorderColor(winXPEditorTabCellRenderer) : (color = winXPEditorTabCellRenderer.isActive() && winXPEditorTabCellRenderer.isSelected() ? UIManager.getColor("tab_sel_fill_dark") : UIManager.getColor("tab_sel_fill_bright"));
        if (color == null) {
            color = Color.white;
        }
        return color;
    }

    public static Color getCloseButtonShadow(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        return winXPEditorTabCellRenderer.isPressed() && winXPEditorTabCellRenderer.inCloseButton() ? Color.WHITE : WinXPEditorTabCellRenderer.getCloseButtonBorderColor(winXPEditorTabCellRenderer);
    }

    private static final Paint getPaint(WinXPEditorTabCellRenderer winXPEditorTabCellRenderer, TabPainter tabPainter) {
        Insets insets = tabPainter.getBorderInsets(winXPEditorTabCellRenderer);
        int n = insets.left;
        int n2 = insets.top;
        int n3 = insets.left;
        int n4 = winXPEditorTabCellRenderer.getHeight() - (insets.top + insets.bottom + 1);
        if (winXPEditorTabCellRenderer.isSelected() || winXPEditorTabCellRenderer.isArmed()) {
            n2 += 3;
        }
        return WinXPEditorTabCellRenderer.getPaint(n, n2, n3, n4, winXPEditorTabCellRenderer);
    }

    private static final Paint getPaint(int n, int n2, int n3, int n4, WinXPEditorTabCellRenderer winXPEditorTabCellRenderer) {
        if (!winXPEditorTabCellRenderer.isSelected() && !winXPEditorTabCellRenderer.isPressed() && winXPEditorTabCellRenderer.isAttention()) {
            Color color = new Color(255, 255, 128);
            Color color2 = new Color(230, 200, 64);
            return ColorUtil.getGradientPaint(n, n2, color, n3, n4, color2);
        }
        if (winXPEditorTabCellRenderer.isSelected() || winXPEditorTabCellRenderer.isPressed() && !winXPEditorTabCellRenderer.inCloseButton()) {
            Color color;
            if (winXPEditorTabCellRenderer.isActive()) {
                return ColorUtil.getGradientPaint(n, n2, WinXPEditorTabCellRenderer.getTopActiveSelectedColor(), n3, n4, WinXPEditorTabCellRenderer.getBottomActiveSelectedColor());
            }
            Color color3 = WinXPEditorTabCellRenderer.getTopInactiveSelectedColor();
            if (color3 == (color = WinXPEditorTabCellRenderer.getBottomInactiveSelectedColor())) {
                return color3;
            }
            return ColorUtil.getGradientPaint(n, n2, color3, n3, n4, color);
        }
        return ColorUtil.getGradientPaint(n, n2, WinXPEditorTabCellRenderer.getTopUnselectedColor(), n3, n4, WinXPEditorTabCellRenderer.getBottomUnselectedColor());
    }

    private static final void paintGradient(Graphics graphics, WinXPEditorTabCellRenderer winXPEditorTabCellRenderer, TabPainter tabPainter) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = tabPainter.getBorderInsets(winXPEditorTabCellRenderer);
        Paint paint = WinXPEditorTabCellRenderer.getPaint(winXPEditorTabCellRenderer, tabPainter);
        graphics2D.setPaint(paint);
        Polygon polygon = tabPainter.getInteriorPolygon(winXPEditorTabCellRenderer);
        graphics.fillPolygon(polygon);
        if (winXPEditorTabCellRenderer.isArmed() || winXPEditorTabCellRenderer.isSelected()) {
            WinXPEditorTabCellRenderer.paintTopLine(graphics, winXPEditorTabCellRenderer, tabPainter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void paintTopLine(Graphics graphics, WinXPEditorTabCellRenderer winXPEditorTabCellRenderer, TabPainter tabPainter) {
        Polygon polygon = tabPainter.getInteriorPolygon(winXPEditorTabCellRenderer);
        ((Graphics2D)graphics).setPaint(WinXPEditorTabCellRenderer.getHighlightColor());
        graphics.setColor(WinXPEditorTabCellRenderer.getHighlightColor());
        Shape shape = graphics.getClip();
        Insets insets = tabPainter.getBorderInsets(winXPEditorTabCellRenderer);
        try {
            if (shape != null) {
                Area area = new Area(shape);
                area.intersect(new Area(polygon));
                graphics.setClip(area);
            } else {
                graphics.setClip(polygon);
            }
            graphics.fillRect(0, insets.top, winXPEditorTabCellRenderer.getWidth(), 3);
        }
        finally {
            graphics.setClip(shape);
        }
    }

    protected int getCaptionYAdjustment() {
        return 1;
    }

    private static class WinXPRightClipPainter
    implements TabPainter {
        private WinXPRightClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 3, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component component) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = component.getHeight() - insets.bottom;
            int n4 = component.getWidth() + 3;
            int n5 = winXPEditorTabCellRenderer.isSelected() ? n3 + 1 : n3;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n4, n2 + insets.top);
            polygon.addPoint(n + n4, n2 + n5 - 1);
            polygon.addPoint(n, n2 + n5 - 1);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(WinXPEditorTabCellRenderer.getHighlightBorderColor(winXPEditorTabCellRenderer));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            Color color = null;
            boolean bl = winXPEditorTabCellRenderer.isArmed() || winXPEditorTabCellRenderer.isSelected();
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                if (i == 1 && bl) {
                    color = graphics.getColor();
                    graphics.setColor(WinXPEditorTabCellRenderer.getTopHighlightColor());
                } else if (i == 2 && bl) {
                    graphics.setColor(color);
                }
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
            }
            graphics.setColor(ColorUtil.adjustComponentsTowards(bl ? WinXPEditorTabCellRenderer.getTopHighlightColor() : WinXPEditorTabCellRenderer.getHighlightBorderColor(winXPEditorTabCellRenderer), UIManager.getColor("control")));
            graphics.drawLine(nArray[0] - 1, nArray2[0], nArray[1] - 1, nArray2[1]);
            if (winXPEditorTabCellRenderer.isSelected()) {
                Insets insets = this.getBorderInsets(component);
                GradientPaint gradientPaint = (GradientPaint)WinXPEditorTabCellRenderer.getPaint(insets.top + 3, 0, n4 - (insets.top + insets.bottom + 2), 1, winXPEditorTabCellRenderer);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                Point2D point2D = gradientPaint.getPoint1();
                Point2D point2D2 = gradientPaint.getPoint2();
                gradientPaint = ColorUtil.getGradientPaint(Math.round(point2D2.getX()), Math.round(point2D2.getY()), gradientPaint.getColor1(), Math.round(point2D.getX()), Math.round(point2D.getY()), gradientPaint.getColor2(), false);
                graphics.fillRect(n + 1, n2 + insets.top + 3, n + 1, n4 - (insets.top + insets.bottom + 3));
                graphics.setColor(WinXPEditorTabCellRenderer.getSelectedTabBottomLineColor());
                graphics.drawLine(1, n4 - insets.bottom, n3 - 1, n4 - insets.bottom);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            WinXPEditorTabCellRenderer.paintGradient(graphics, winXPEditorTabCellRenderer, this);
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class WinXPLeftClipPainter
    implements TabPainter {
        private WinXPLeftClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 3, 0);
        }

        public Polygon getInteriorPolygon(Component component) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = -3;
            int n2 = 0;
            int n3 = component.getHeight() - insets.bottom;
            int n4 = component.getWidth() + 3;
            int n5 = winXPEditorTabCellRenderer.isSelected() ? n3 + 1 : n3;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n4 - 2, n2 + insets.top);
            polygon.addPoint(n + n4, n2 + insets.top + 2);
            polygon.addPoint(n + n4, n2 + n5 - 1);
            polygon.addPoint(n, n2 + n5 - 1);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(WinXPEditorTabCellRenderer.getHighlightBorderColor(winXPEditorTabCellRenderer));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            Color color = null;
            boolean bl = winXPEditorTabCellRenderer.isArmed() || winXPEditorTabCellRenderer.isSelected();
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                if (i == 1 && bl) {
                    color = graphics.getColor();
                    graphics.setColor(WinXPEditorTabCellRenderer.getTopHighlightColor());
                } else if (i == 2 && bl) {
                    graphics.setColor(color);
                }
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
                if (i != polygon.npoints - 4) continue;
                graphics.setColor(WinXPEditorTabCellRenderer.getShadowBorderColor(winXPEditorTabCellRenderer));
                graphics.drawLine(nArray[i] + 1, nArray2[i] + 1, nArray[i] + 2, nArray2[i] + 2);
            }
            graphics.setColor(ColorUtil.adjustComponentsTowards(bl ? WinXPEditorTabCellRenderer.getTopHighlightColor() : WinXPEditorTabCellRenderer.getHighlightBorderColor(winXPEditorTabCellRenderer), UIManager.getColor("control")));
            graphics.drawLine(nArray[0] - 1, nArray2[0], nArray[1] - 1, nArray2[1]);
            graphics.drawLine(nArray[2] + 1, nArray2[2], nArray[3] + 1, nArray2[3]);
            if (winXPEditorTabCellRenderer.isSelected()) {
                graphics.setColor(WinXPEditorTabCellRenderer.getRightEdgeSelectedShadow());
                Insets insets = this.getBorderInsets(component);
                graphics.drawLine(winXPEditorTabCellRenderer.getWidth() - 1, insets.top + 3, n3 - 1, n4 - insets.bottom);
                graphics.setColor(WinXPEditorTabCellRenderer.getSelectedTabBottomLineColor());
                graphics.drawLine(0, n4 - insets.bottom, n3 - 2, n4 - insets.bottom);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            WinXPEditorTabCellRenderer.paintGradient(graphics, winXPEditorTabCellRenderer, this);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class WinXPPainter
    implements TabPainter {
        private WinXPPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 3, 0);
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            if (!((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
                return;
            }
            Insets insets = this.getBorderInsets(jComponent);
            rectangle.y = rectangle2.y + insets.top - 3;
            rectangle.height = rectangle2.height - rectangle.y;
            rectangle.x = rectangle2.x + rectangle2.width - 12;
            rectangle.width = 6;
            rectangle.y += rectangle.height / 2 - 3;
            rectangle.height = 6;
        }

        public Polygon getInteriorPolygon(Component component) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = component.getHeight() - insets.bottom;
            int n4 = winXPEditorTabCellRenderer.isRightmost() ? component.getWidth() - 1 : component.getWidth();
            int n5 = winXPEditorTabCellRenderer.isSelected() ? n3 + 1 : n3;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n4 - 2, n2 + insets.top);
            polygon.addPoint(n + n4, n2 + insets.top + 2);
            polygon.addPoint(n + n4, n2 + n5 - 1);
            polygon.addPoint(n, n2 + n5 - 1);
            return polygon;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(WinXPEditorTabCellRenderer.getHighlightBorderColor(winXPEditorTabCellRenderer));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            Color color = null;
            boolean bl = winXPEditorTabCellRenderer.isArmed() || winXPEditorTabCellRenderer.isSelected();
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                if (i == 0 && bl) {
                    color = graphics.getColor();
                    graphics.setColor(WinXPEditorTabCellRenderer.getTopHighlightColor());
                } else if (i == 3 && bl) {
                    graphics.setColor(color);
                }
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
            }
            graphics.setColor(ColorUtil.adjustComponentsTowards(bl ? WinXPEditorTabCellRenderer.getTopHighlightColor() : WinXPEditorTabCellRenderer.getHighlightBorderColor(winXPEditorTabCellRenderer), UIManager.getColor("control")));
            graphics.drawLine(nArray[0] - 1, nArray2[0], nArray[1] - 1, nArray2[1]);
            graphics.drawLine(nArray[2] + 1, nArray2[2], nArray[3] + 1, nArray2[3]);
            if (winXPEditorTabCellRenderer.isSelected()) {
                graphics.setColor(WinXPEditorTabCellRenderer.getRightEdgeSelectedShadow());
                Insets insets = this.getBorderInsets(component);
                graphics.drawLine(winXPEditorTabCellRenderer.getWidth() - (winXPEditorTabCellRenderer.isRightmost() ? 2 : 1), insets.top + 3, n3 - (winXPEditorTabCellRenderer.isRightmost() ? 2 : 1), n4 - insets.bottom);
                GradientPaint gradientPaint = (GradientPaint)WinXPEditorTabCellRenderer.getPaint(insets.top + 3, 0, n4 - (insets.top + insets.bottom + 2), 1, winXPEditorTabCellRenderer);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                Point2D point2D = gradientPaint.getPoint1();
                Point2D point2D2 = gradientPaint.getPoint2();
                gradientPaint = ColorUtil.getGradientPaint(Math.round(point2D2.getX()), Math.round(point2D2.getY()), gradientPaint.getColor1(), Math.round(point2D.getX()), Math.round(point2D.getY()), gradientPaint.getColor2(), false);
                int n5 = winXPEditorTabCellRenderer.isLeftmost() ? n + 2 : n + 1;
                graphics.fillRect(n5, n2 + insets.top + 3, n5, n4 - (insets.top + insets.bottom + 3));
                graphics.setColor(WinXPEditorTabCellRenderer.getSelectedTabBottomLineColor());
                graphics.drawLine(1, n4 - insets.bottom, n3 - 2, n4 - insets.bottom);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            Color color;
            WinXPEditorTabCellRenderer winXPEditorTabCellRenderer = (WinXPEditorTabCellRenderer)component;
            WinXPEditorTabCellRenderer.paintGradient(graphics, winXPEditorTabCellRenderer, this);
            Rectangle rectangle = new Rectangle();
            this.getCloseButtonRectangle(winXPEditorTabCellRenderer, rectangle, new Rectangle(0, 0, winXPEditorTabCellRenderer.getWidth(), winXPEditorTabCellRenderer.getHeight()));
            if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return;
            }
            if (winXPEditorTabCellRenderer.inCloseButton()) {
                Paint paint;
                color = WinXPEditorTabCellRenderer.getCloseButtonBorderColor(winXPEditorTabCellRenderer);
                Color color2 = Color.WHITE;
                if (winXPEditorTabCellRenderer.inCloseButton() && winXPEditorTabCellRenderer.isPressed()) {
                    paint = color2;
                    color2 = color;
                    color = paint;
                }
                paint = ColorUtil.getGradientPaint(rectangle.x - 2, rectangle.y - 2, color2, rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height + 4, color);
                ((Graphics2D)graphics).setPaint(paint);
                graphics.fillRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
            }
            graphics.setColor(WinXPEditorTabCellRenderer.getCloseButtonAAColor(winXPEditorTabCellRenderer));
            graphics.fillRect(rectangle.x + rectangle.width / 2 - 2, rectangle.y + rectangle.height / 2 - 2, 4, 4);
            graphics.fillRect(rectangle.x, rectangle.y, 2, 2);
            graphics.fillRect(rectangle.x + rectangle.width - 2, rectangle.y, 2, 2);
            graphics.fillRect(rectangle.x, rectangle.y + rectangle.height - 2, 2, 2);
            graphics.fillRect(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2, 2, 2);
            graphics.setColor(WinXPEditorTabCellRenderer.getCloseButtonColor(winXPEditorTabCellRenderer));
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y);
            graphics.setColor(winXPEditorTabCellRenderer.isPressed() && winXPEditorTabCellRenderer.inCloseButton() ? WinXPEditorTabCellRenderer.getCloseButtonHighlight(winXPEditorTabCellRenderer) : WinXPEditorTabCellRenderer.getCloseButtonShadow(winXPEditorTabCellRenderer));
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
            graphics.drawLine(rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + 1, rectangle.y + rectangle.height);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 4, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 3);
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + 1);
            graphics.setColor(winXPEditorTabCellRenderer.isPressed() && winXPEditorTabCellRenderer.inCloseButton() ? WinXPEditorTabCellRenderer.getCloseButtonShadow(winXPEditorTabCellRenderer) : WinXPEditorTabCellRenderer.getCloseButtonHighlight(winXPEditorTabCellRenderer));
            graphics.drawLine(rectangle.x, rectangle.y - 1, rectangle.x + 1, rectangle.y - 1);
            graphics.drawLine(rectangle.x - 1, rectangle.y, rectangle.x - 1, rectangle.y + 1);
            graphics.drawLine(rectangle.x, rectangle.y + 2, rectangle.x, rectangle.y + 3);
            graphics.drawLine(rectangle.x - 1, rectangle.y + rectangle.height - 2, rectangle.x - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + 2, rectangle.y, rectangle.x + 3, rectangle.y);
            graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y - 1, rectangle.x + rectangle.width - 1, rectangle.y - 1);
            if (winXPEditorTabCellRenderer.inCloseButton()) {
                color = WinXPEditorTabCellRenderer.getCloseButtonBorderColor(winXPEditorTabCellRenderer);
                graphics.setColor(color);
                rectangle.x -= 3;
                rectangle.y -= 3;
                rectangle.width += 5;
                rectangle.height += 5;
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                graphics.setColor(ColorUtil.getMiddle(winXPEditorTabCellRenderer.getBackground(), color));
                graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x + 1, rectangle.y);
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width, rectangle.y + 1);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + 1, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
            }
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return jComponent instanceof TabDisplayer ? ((TabDisplayer)jComponent).isShowCloseButton() : true;
        }
    }
}

