/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.IntrospectionHelperProxy;
import org.apache.tools.ant.module.bridge.impl.IntrospectionHelperImpl;
import org.apache.tools.ant.module.bridge.impl.NbAntlib;
import org.apache.tools.ant.module.bridge.impl.NbBuildLogger;
import org.apache.tools.ant.module.bridge.impl.NbInputHandler;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputWriter;

public class BridgeImpl
implements BridgeInterface {
    private static final int STOP_TIMEOUT = 3000;
    private static boolean classpathInitialized;
    private static final Map loggersByThread;
    private static FileSystem[] fileSystems;
    private static boolean doHack36393;
    private static boolean doGutProject;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getAntVersion() {
        try {
            return Main.getAntVersion();
        }
        catch (BuildException be) {
            AntModule.err.notify(1, (Throwable)be);
            return NbBundle.getMessage((Class)BridgeImpl.class, (String)"LBL_ant_version_unknown");
        }
    }

    public boolean isAnt16() {
        try {
            Class.forName("org.apache.tools.ant.taskdefs.Antlib");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public IntrospectionHelperProxy getIntrospectionHelper(Class clazz) {
        return new IntrospectionHelperImpl(clazz);
    }

    public boolean toBoolean(String val) {
        return Project.toBoolean((String)val);
    }

    public String[] getEnumeratedValues(Class c) {
        if (EnumeratedAttribute.class.isAssignableFrom(c)) {
            try {
                return ((EnumeratedAttribute)c.newInstance()).getValues();
            }
            catch (Exception e) {
                AntModule.err.notify(1, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean run(File buildFile, List targets, InputStream in, OutputWriter out, OutputWriter err, Properties properties, int verbosity, String displayName, Runnable interestingOutputCallback) {
        Object c;
        Vector<String> targs;
        NbBuildLogger logger;
        Project project;
        if (!classpathInitialized) {
            classpathInitialized = true;
            Path.systemClasspath = new Path(null, AntBridge.getMainClassPath());
        }
        boolean ok = false;
        final boolean ant16 = this.isAnt16();
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        ClassLoader newCCL = Project.class.getClassLoader();
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("Fixing CCL: " + oldCCL + " -> " + newCCL);
        }
        Thread.currentThread().setContextClassLoader(newCCL);
        AntBridge.fakeJavaClassPath();
        try {
            project = null;
            logger = new NbBuildLogger(buildFile, out, err, verbosity, displayName, interestingOutputCallback);
            try {
                project = new Project();
                project.addBuildListener((BuildListener)logger);
                project.init();
                try {
                    BridgeImpl.addCustomDefs(project);
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
                project.setUserProperty("ant.file", buildFile.getAbsolutePath());
                project.setUserProperty("ant.version", Main.getAntVersion());
                project.setUserProperty("ant.home", AntSettings.getDefault().getAntHomeWithDefault().getAbsolutePath());
                Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry = it.next();
                    project.setUserProperty((String)entry.getKey(), (String)entry.getValue());
                }
                if (in != null && ant16) {
                    try {
                        Method m = Project.class.getMethod("setDefaultInputStream", InputStream.class);
                        m.invoke((Object)project, in);
                    }
                    catch (Exception e) {
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
                if (AntModule.err.isLoggable(1)) {
                    AntModule.err.log("CCL when configureProject is called: " + Thread.currentThread().getContextClassLoader());
                }
                ProjectHelper projhelper = ProjectHelper.getProjectHelper();
                project.addReference("ant.projectHelper", (Object)projhelper);
                projhelper.parse(project, (Object)buildFile);
                project.setInputHandler((InputHandler)new NbInputHandler(interestingOutputCallback));
                if (targets != null) {
                    targs = new Vector<String>(targets);
                } else {
                    targs = new Vector(1);
                    targs.add(project.getDefaultTarget());
                }
                logger.setActualTargets(targets != null ? targets.toArray(new String[targets.size()]) : null);
            }
            catch (BuildException be) {
                logger.buildInitializationFailed(be);
                out.close();
                err.close();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        AntModule.err.notify((Throwable)e);
                    }
                }
                boolean e = false;
                Object var26_25 = null;
                AntBridge.unfakeJavaClassPath();
                if (AntModule.err.isLoggable(1)) {
                    AntModule.err.log("Restoring CCL: " + oldCCL);
                }
                Thread.currentThread().setContextClassLoader(oldCCL);
                return e;
            }
        }
        catch (Throwable throwable) {
            Object var26_27 = null;
            AntBridge.unfakeJavaClassPath();
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("Restoring CCL: " + oldCCL);
            }
            Thread.currentThread().setContextClassLoader(oldCCL);
            throw throwable;
        }
        project.fireBuildStarted();
        InputStream is = System.in;
        if (in != null && ant16) {
            try {
                Class<?> dis = Class.forName("org.apache.tools.ant.DemuxInputStream");
                c = dis.getConstructor(Project.class);
                is = (InputStream)((Constructor)c).newInstance(project);
            }
            catch (Exception e) {
                AntModule.err.notify(1, (Throwable)e);
            }
        }
        AntBridge.pushSystemInOutErr((InputStream)is, (PrintStream)new PrintStream((OutputStream)new DemuxOutputStream(project, false)), (PrintStream)new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
        Thread currentThread = Thread.currentThread();
        c = loggersByThread;
        synchronized (c) {
            if (!$assertionsDisabled && loggersByThread.containsKey(currentThread)) {
                throw new AssertionError();
            }
            loggersByThread.put(currentThread, logger);
        }
        try {
            project.executeTargets(targs);
            project.fireBuildFinished(null);
            ok = true;
            Object var22_31 = null;
        }
        catch (Throwable throwable) {
            Object var22_33 = null;
            AntBridge.restoreSystemInOutErr();
            out.close();
            err.close();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    AntModule.err.notify((Throwable)e);
                }
            }
            Map map = loggersByThread;
            synchronized (map) {
                loggersByThread.remove(currentThread);
            }
            throw throwable;
        }
        AntBridge.restoreSystemInOutErr();
        out.close();
        err.close();
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                AntModule.err.notify((Throwable)e);
            }
        }
        Map map = loggersByThread;
        synchronized (map) {
            loggersByThread.remove(currentThread);
        }
        {
            catch (Throwable t) {
                project.fireBuildFinished(t);
                Object var22_32 = null;
                AntBridge.restoreSystemInOutErr();
                out.close();
                err.close();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        AntModule.err.notify((Throwable)e);
                    }
                }
                Map map2 = loggersByThread;
                synchronized (map2) {
                    loggersByThread.remove(currentThread);
                }
            }
        }
        final Project p2 = project;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                IntrospectedInfo custom = AntSettings.getDefault().getCustomDefs();
                HashMap<String, Hashtable> defs = new HashMap<String, Hashtable>();
                defs.put("task", p2.getTaskDefinitions());
                defs.put("type", p2.getDataTypeDefinitions());
                custom.scanProject(defs);
                FileSystem[] allFileSystems = BridgeImpl.getFileSystems();
                for (int i = 0; i < allFileSystems.length; ++i) {
                    FileSystem fs = allFileSystems[i];
                    fs.refresh(false);
                }
                BridgeImpl.gutProject(p2);
                if (!ant16) {
                    RequestProcessor.getDefault().post(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            BridgeImpl.access$200();
                        }
                    });
                }
            }
        });
        Object var26_26 = null;
        AntBridge.unfakeJavaClassPath();
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("Restoring CCL: " + oldCCL);
        }
        Thread.currentThread().setContextClassLoader(oldCCL);
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final Thread process) {
        NbBuildLogger logger;
        Map map = loggersByThread;
        synchronized (map) {
            logger = (NbBuildLogger)loggersByThread.get(process);
        }
        if (logger != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)BridgeImpl.class, (String)"MSG_stopping", (Object)logger.getDisplayNameNoLock()));
            logger.stop();
            RequestProcessor.getDefault().create(new Runnable(){

                public void run() {
                    BridgeImpl.this.forciblyStop(process);
                }
            }).schedule(3000);
        } else {
            this.forciblyStop(process);
        }
    }

    private void forciblyStop(Thread process) {
        if (process.isAlive()) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)BridgeImpl.class, (String)"MSG_halting"));
            process.stop();
        }
    }

    private static FileSystem[] getFileSystems() {
        if (fileSystems != null) {
            return fileSystems;
        }
        File[] roots = File.listRoots();
        LinkedHashSet<FileSystem> allRoots = new LinkedHashSet<FileSystem>();
        if (!($assertionsDisabled || roots != null && roots.length > 0)) {
            throw new AssertionError((Object)"Could not list file roots");
        }
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            FileObject random = FileUtil.toFileObject((File)root);
            if (random == null) continue;
            try {
                FileSystem fs = random.getFileSystem();
                allRoots.add(fs);
                if (fs == null) continue;
                break;
            }
            catch (FileStateInvalidException e) {
                throw new AssertionError((Object)e);
            }
        }
        FileSystem[] retVal = new FileSystem[allRoots.size()];
        allRoots.toArray(retVal);
        if (!$assertionsDisabled && retVal.length <= 0) {
            throw new AssertionError((Object)"Could not get any filesystem");
        }
        fileSystems = retVal;
        return retVal;
    }

    private static void addCustomDefs(Project project) throws BuildException, IOException {
        long start = System.currentTimeMillis();
        if (AntBridge.getInterface().isAnt16()) {
            Map antlibLoaders = AntBridge.getCustomDefClassLoaders();
            Iterator it = antlibLoaders.entrySet().iterator();
            while (it.hasNext()) {
                String resource;
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                ClassLoader l = (ClassLoader)entry.getValue();
                URL antlib = l.getResource(resource = cnb.replace('.', '/') + "/antlib.xml");
                if (antlib == null) {
                    throw new IOException("Could not find " + antlib + " in ant/nblib/" + cnb.replace('.', '-') + ".jar");
                }
                NbAntlib.process(project, antlib, null, l);
                String antlibUri = "antlib:" + cnb;
                NbAntlib.process(project, antlib, antlibUri, l);
            }
        } else {
            Map.Entry entry;
            Map customDefs = AntBridge.getCustomDefsNoNamespace();
            Iterator defs = ((Map)customDefs.get("task")).entrySet().iterator();
            while (defs.hasNext()) {
                entry = defs.next();
                project.addTaskDefinition((String)entry.getKey(), (Class)entry.getValue());
            }
            defs = ((Map)customDefs.get("type")).entrySet().iterator();
            while (defs.hasNext()) {
                entry = defs.next();
                project.addDataTypeDefinition((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("addCustomDefs took " + (System.currentTimeMillis() - start) + "msec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hack36393() {
        if (!doHack36393) {
            return;
        }
        try {
            Class<?> shutdownC = Class.forName("java.lang.Shutdown");
            Class<?> wrappedHookC = Class.forName("java.lang.Shutdown$WrappedHook");
            Field hooksF = shutdownC.getDeclaredField("hooks");
            hooksF.setAccessible(true);
            Field hookF = wrappedHookC.getDeclaredField("hook");
            hookF.setAccessible(true);
            Field lockF = shutdownC.getDeclaredField("lock");
            lockF.setAccessible(true);
            Object lock = lockF.get(null);
            HashSet<Thread> toRemove = new HashSet<Thread>();
            Object object = lock;
            synchronized (object) {
                Set hooks = (Set)hooksF.get(null);
                Iterator it = hooks.iterator();
                while (it.hasNext()) {
                    Object wrappedHook = it.next();
                    Thread hook = (Thread)hookF.get(wrappedHook);
                    if (!hook.getClass().getName().equals("org.apache.tools.ant.taskdefs.ProcessDestroyer")) continue;
                    toRemove.add(hook);
                }
            }
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                Thread hook = (Thread)it.next();
                if (!Runtime.getRuntime().removeShutdownHook(hook)) {
                    throw new IllegalStateException("Hook was not really registered!");
                }
                AntModule.err.log("#36393: removing an unwanted ProcessDestroyer shutdown hook");
                hook.start();
            }
        }
        catch (Exception e) {
            AntModule.err.notify(1, (Throwable)e);
            doHack36393 = false;
        }
    }

    private static void gutProject(Project p) {
        if (!doGutProject) {
            return;
        }
        try {
            String s = p.getName();
            AntModule.err.log("Gutting extra references in project \"" + s + "\"");
            Field[] fs = Project.class.getDeclaredFields();
            for (int i = 0; i < fs.length; ++i) {
                if (Modifier.isStatic(fs[i].getModifiers())) continue;
                if (Modifier.isFinal(fs[i].getModifiers())) {
                    Object o = fs[i].get(p);
                    try {
                        if (o instanceof Collection) {
                            ((Collection)o).clear();
                            continue;
                        }
                        if (!(o instanceof Map)) continue;
                        ((Map)o).clear();
                    }
                    catch (UnsupportedOperationException e) {}
                    continue;
                }
                if (fs[i].getType().isPrimitive()) continue;
                fs[i].setAccessible(true);
                fs[i].set(p, null);
            }
            Field helpersF = IntrospectionHelper.class.getDeclaredField("helpers");
            helpersF.setAccessible(true);
            Object helpersO = helpersF.get(null);
            Map helpersM = (Map)helpersO;
            helpersM.clear();
            Introspector.flushCaches();
        }
        catch (Exception e) {
            AntModule.err.notify(1, (Throwable)e);
            doGutProject = false;
        }
    }

    static /* synthetic */ void access$200() {
        BridgeImpl.hack36393();
    }

    static {
        $assertionsDisabled = !BridgeImpl.class.desiredAssertionStatus();
        classpathInitialized = false;
        loggersByThread = new WeakHashMap();
        doHack36393 = true;
        doGutProject = true;
    }
}

