/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.PriorityDocumentListenerList;

public final class DocumentUtilities {
    private static final Object TYPING_MODIFICATION_DOCUMENT_PROPERTY = new Object();

    private DocumentUtilities() {
    }

    public static void addDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)document.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.add(documentListener, documentListenerPriority.getPriority());
        } else {
            document.addDocumentListener(documentListener);
        }
    }

    public static void removeDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)document.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.remove(documentListener, documentListenerPriority.getPriority());
        } else {
            document.removeDocumentListener(documentListener);
        }
    }

    public static DocumentListener initPriorityListening(Document document) {
        if (document.getProperty(PriorityDocumentListenerList.class) != null) {
            throw new IllegalStateException("PriorityDocumentListenerList already initialized for doc=" + document);
        }
        PriorityDocumentListenerList priorityDocumentListenerList = new PriorityDocumentListenerList();
        document.putProperty(PriorityDocumentListenerList.class, priorityDocumentListenerList);
        return priorityDocumentListenerList;
    }

    public static void setTypingModification(Document document, boolean bl) {
        document.putProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY, bl);
    }

    public static boolean isTypingModification(DocumentEvent documentEvent) {
        Boolean bl = (Boolean)documentEvent.getDocument().getProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY);
        return bl != null ? bl : false;
    }
}

