/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class PositionRegion {
    private static Comparator comparator;
    private Position startPosition;
    private Position endPosition;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final Comparator getComparator() {
        if (comparator == null) {
            comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((PositionRegion)object).getStartOffset() - ((PositionRegion)object2).getStartOffset();
                }
            };
        }
        return comparator;
    }

    public static boolean isRegionsSorted(List list) {
        for (int i = list.size() - 2; i >= 0; --i) {
            if (PositionRegion.getComparator().compare(list.get(i), list.get(i + 1)) <= 0) continue;
            return false;
        }
        return true;
    }

    public PositionRegion(Position position, Position position2) {
        if (!$assertionsDisabled && position.getOffset() > position2.getOffset()) {
            throw new AssertionError((Object)("startPosition=" + position.getOffset() + " > endPosition=" + position2));
        }
        this.startPosition = position;
        this.endPosition = position2;
    }

    public PositionRegion(Document document, int n, int n2) throws BadLocationException {
        this(document.createPosition(n), document.createPosition(n2));
    }

    public final int getStartOffset() {
        return this.startPosition.getOffset();
    }

    public final Position getStartPosition() {
        return this.startPosition;
    }

    public final int getEndOffset() {
        return this.endPosition.getOffset();
    }

    public final Position getEndPosition() {
        return this.endPosition;
    }

    public final int getLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    void setStartPositionImpl(Position position) {
        if (!$assertionsDisabled && position.getOffset() > this.endPosition.getOffset()) {
            throw new AssertionError((Object)("startPosition=" + position.getOffset() + " > endPosition=" + this.endPosition));
        }
        this.startPosition = position;
    }

    void setEndPositionImpl(Position position) {
        if (!$assertionsDisabled && this.startPosition.getOffset() > position.getOffset()) {
            throw new AssertionError((Object)("startPosition=" + this.startPosition.getOffset() + " > endPosition=" + position));
        }
        this.endPosition = position;
    }

    static {
        $assertionsDisabled = !PositionRegion.class.desiredAssertionStatus();
    }
}

