/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static boolean useFastSAXParserFactory = true;
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Class fastParserFactoryClass = null;
    private static final ThreadLocal[] builderTL = new ThreadLocal[4];
    private static final String IDENTITY_XSLT_WITH_INDENT = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>";

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean bl) throws SAXException {
        return XMLUtil.createXMLReader(bl, false);
    }

    public static XMLReader createXMLReader(boolean bl, boolean bl2) throws SAXException {
        SAXParserFactory sAXParserFactory;
        if (!bl && useFastSAXParserFactory) {
            try {
                sAXParserFactory = XMLUtil.createFastSAXParserFactory();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                sAXParserFactory = SAXParserFactory.newInstance();
            }
            catch (SAXException sAXException) {
                sAXParserFactory = SAXParserFactory.newInstance();
            }
        } else {
            useFastSAXParserFactory = false;
            sAXParserFactory = SAXParserFactory.newInstance();
        }
        sAXParserFactory.setValidating(bl);
        sAXParserFactory.setNamespaceAware(bl2);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
    }

    public static Document createDocument(String string, String string2, String string3, String string4) throws DOMException {
        DOMImplementation dOMImplementation = XMLUtil.getDOMImplementation();
        if (string3 != null && string4 == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType documentType = null;
        if (string4 != null) {
            documentType = dOMImplementation.createDocumentType(string, string3, string4);
        }
        return dOMImplementation.createDocument(string2, string, documentType);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException runtimeException) {
            throw (DOMException)new DOMException(9, runtimeException.toString()).initCause(runtimeException);
        }
    }

    public static Document parse(InputSource inputSource, boolean bl, boolean bl2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        int n = (bl ? 0 : 1) + (bl2 ? 0 : 2);
        DocumentBuilder documentBuilder = (DocumentBuilder)builderTL[n].get();
        if (documentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            documentBuilderFactory.setNamespaceAware(bl2);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
            }
            builderTL[n].set(documentBuilder);
        }
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(inputSource);
    }

    public static void write(Document document, OutputStream outputStream, String string) throws IOException {
        Object object;
        if (string == null) {
            throw new NullPointerException("You must set an encoding; use \"UTF-8\" unless you have a good reason not to!");
        }
        Document document2 = XMLUtil.normalize(document);
        if (System.getProperty("java.specification.version").startsWith("1.4")) {
            try {
                XMLUtil.writeXerces(document2, outputStream, string);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException("You need to have xerces.jar available to use XMLUtil.write under JDK 1.4: " + classNotFoundException).initCause(classNotFoundException);
            }
            catch (Exception exception) {
                throw (IOException)new IOException(exception.toString()).initCause(exception);
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        ClassLoader classLoader3 = XMLUtil.class.getClassLoader();
        if (classLoader2 == null) {
            classLoader2 = classLoader3;
        }
        try {
            object = classLoader2.loadClass("org.netbeans.core.startup.SAXFactoryImpl");
            if (object != null) {
                classLoader3 = ((Class)object).getClassLoader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.currentThread().setContextClassLoader(classLoader3);
        try {
            Object object2;
            object = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(IDENTITY_XSLT_WITH_INDENT)));
            DocumentType documentType = document2.getDoctype();
            if (documentType != null) {
                object2 = documentType.getPublicId();
                if (object2 != null) {
                    ((Transformer)object).setOutputProperty("doctype-public", (String)object2);
                }
                ((Transformer)object).setOutputProperty("doctype-system", documentType.getSystemId());
            }
            ((Transformer)object).setOutputProperty("encoding", string);
            object2 = new DOMSource(document2);
            StreamResult streamResult = new StreamResult(outputStream);
            ((Transformer)object).transform((Source)object2, streamResult);
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.toString()).initCause(exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static void writeXerces(Document document, OutputStream outputStream, String string) throws ClassNotFoundException, Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Class.forName("org.apache.xml.serialize.XMLSerializer", true, classLoader);
        Class<?> clazz2 = Class.forName("org.apache.xml.serialize.OutputFormat", true, classLoader);
        Object obj = clazz.newInstance();
        Object obj2 = clazz2.newInstance();
        Method method = clazz2.getMethod("setMethod", String.class);
        method.invoke(obj2, "xml");
        Method method2 = clazz2.getMethod("setIndenting", Boolean.TYPE);
        method2.invoke(obj2, Boolean.TRUE);
        Method method3 = clazz2.getMethod("setLineWidth", Integer.TYPE);
        method3.invoke(obj2, new Integer(0));
        Method method4 = clazz2.getMethod("setLineSeparator", String.class);
        method4.invoke(obj2, (Object[])new String[]{System.getProperty("line.separator")});
        Method method5 = clazz.getMethod("setOutputByteStream", OutputStream.class);
        method5.invoke(obj, outputStream);
        Method method6 = clazz2.getMethod("setEncoding", String.class);
        method6.invoke(obj2, string);
        Method method7 = clazz.getMethod("setOutputFormat", clazz2);
        method7.invoke(obj, obj2);
        Method method8 = clazz.getMethod("setNamespaces", Boolean.TYPE);
        method8.invoke(obj, Boolean.TRUE);
        Method method9 = clazz.getMethod("asDOMSerializer", new Class[0]);
        Object object = method9.invoke(obj, null);
        Method method10 = object.getClass().getMethod("serialize", Document.class);
        method10.invoke(object, document);
    }

    public static String toAttributeValue(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('\'' == c) {
                stringBuffer.append("&apos;");
                continue;
            }
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toElementContent(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('>' == c && i > 1 && string.charAt(i - 2) == ']' && string.charAt(i - 1) == ']') {
                stringBuffer.append("&gt;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            stringBuffer.append(DEC2HEX[(by & 0xF0) >> 4]);
            stringBuffer.append(DEC2HEX[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHex(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new IOException("null");
        }
        int n3 = cArray.length;
        if (n3 % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] byArray = new byte[n3 / 2];
        while (n3 > 0) {
            String string = new String(cArray, n3 - 2, 2);
            try {
                byArray[n3 / 2 - 1] = (byte)Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getLocalizedMessage());
            }
            n3 -= 2;
        }
        return byArray;
    }

    private static boolean checkAttributeCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    bl = true;
                    continue block4;
                }
                default: {
                    if (c >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static boolean checkContentCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (bl) continue block5;
                    bl = i > 0 && string.charAt(i - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    bl = true;
                    continue block5;
                }
                default: {
                    if (c >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static SAXParserFactory createFastSAXParserFactory() throws ParserConfigurationException, SAXException {
        block6: {
            if (fastParserFactoryClass == null) {
                try {
                    fastParserFactoryClass = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                }
                catch (Exception exception) {
                    useFastSAXParserFactory = false;
                    if (!System.getProperty("java.version").startsWith("1.4")) break block6;
                    ErrorManager.getDefault().notify(1, exception);
                }
            }
        }
        if (fastParserFactoryClass != null) {
            try {
                SAXParserFactory sAXParserFactory = (SAXParserFactory)fastParserFactoryClass.newInstance();
                return sAXParserFactory;
            }
            catch (Exception exception) {
                useFastSAXParserFactory = false;
                throw new ParserConfigurationException(exception.getMessage());
            }
        }
        return SAXParserFactory.newInstance();
    }

    private static Document normalize(Document document) throws IOException {
        int n;
        Document document2;
        Object object;
        DocumentBuilder documentBuilder = (DocumentBuilder)builderTL[0].get();
        if (documentBuilder == null) {
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setValidating(false);
            ((DocumentBuilderFactory)object).setNamespaceAware(false);
            try {
                documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw (IOException)new IOException("Cannot create parser satisfying configuration parameters: " + parserConfigurationException).initCause(parserConfigurationException);
            }
            builderTL[0].set(documentBuilder);
        }
        object = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof DocumentType)) continue;
            object = (DocumentType)nodeList.item(i);
        }
        if (object != null) {
            document2 = documentBuilder.getDOMImplementation().createDocument(document.getDocumentElement().getNamespaceURI(), document.getDocumentElement().getTagName(), documentBuilder.getDOMImplementation().createDocumentType(document.getDoctype().getName(), document.getDoctype().getPublicId(), document.getDoctype().getSystemId()));
            document2.removeChild(document2.getDocumentElement());
        } else {
            document2 = documentBuilder.newDocument();
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (nodeList.item(n) instanceof DocumentType) continue;
            document2.appendChild(document2.importNode(nodeList.item(n), true));
        }
        document2.normalize();
        nodeList = document2.getElementsByTagName("*");
        for (n = 0; n < nodeList.getLength(); ++n) {
            Element element = (Element)nodeList.item(n);
            NodeList nodeList2 = element.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Text) || ((Text)node).getNodeValue().trim().length() != 0) continue;
                element.removeChild(node);
                --i;
            }
        }
        return document2;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            XMLUtil.builderTL[i] = new ThreadLocal();
        }
    }
}

