/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.options.codetemplates.CodeTemplatesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CodeTemplatesPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JComboBox cbLanguage = new JComboBox();
    private JTable tTemplates = new JTable();
    private JScrollPane spTable = new JScrollPane(this.tTemplates);
    private JEditorPane epTemplates = new JEditorPane();
    private JButton bNew = new JButton();
    private JButton bRemove = new JButton();
    private JComboBox cbExpander = new JComboBox();
    private CodeTemplatesModel model;
    private Lookup lookup;
    private int lastIndex = -1;

    public CodeTemplatesPanel() {
        this.bRemove.setEnabled(false);
        CodeTemplatesPanel.loc(this.bNew, "New");
        CodeTemplatesPanel.loc(this.bRemove, "Remove");
        JLabel jLabel = new JLabel();
        CodeTemplatesPanel.loc(jLabel, "Expander_Key");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(jLabel);
        jPanel.add(this.cbExpander);
        this.cbExpander.addItem(CodeTemplatesPanel.loc("SPACE"));
        this.cbExpander.addItem(CodeTemplatesPanel.loc("S-SPACE"));
        this.cbExpander.addItem(CodeTemplatesPanel.loc("TAB"));
        this.cbExpander.addItem(CodeTemplatesPanel.loc("ENTER"));
        this.tTemplates.getTableHeader().setReorderingAllowed(false);
        this.tTemplates.getSelectionModel().setSelectionMode(0);
        Font font = this.tTemplates.getFont();
        this.spTable.setPreferredSize(new Dimension(10, 10));
        JLabel jLabel2 = new JLabel();
        CodeTemplatesPanel.loc(jLabel2, "Template_List");
        jLabel2.setLabelFor(this.tTemplates);
        JLabel jLabel3 = new JLabel();
        CodeTemplatesPanel.loc(jLabel3, "Expanded_Text");
        jLabel3.setLabelFor(this.epTemplates);
        this.epTemplates.setPreferredSize(new Dimension(10, 10));
        FormLayout formLayout = new FormLayout("p, 5dlu, 100dlu, 100dlu:g, 5dlu, p", "p, 5dlu, p, 1dlu, p, 3dlu, p, f:20dlu:g, 5dlu, p, 1dlu, f:20dlu:g, 5dlu, p");
        formLayout.setRowGroups((int[][])new int[][]{{3, 7}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.addLabel(CodeTemplatesPanel.loc("CTL_Language"), cellConstraints2.xy(1, 1), (Component)this.cbLanguage, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints2.xy(1, 3));
        panelBuilder.add((Component)this.spTable, cellConstraints.xywh(1, 5, 4, 4));
        panelBuilder.add((Component)this.bNew, cellConstraints.xy(6, 5));
        panelBuilder.add((Component)this.bRemove, cellConstraints.xy(6, 7));
        panelBuilder.add((Component)jLabel3, cellConstraints2.xyw(1, 10, 4));
        panelBuilder.add((Component)new JScrollPane(this.epTemplates), cellConstraints.xyw(1, 12, 4));
        panelBuilder.add((Component)jPanel, cellConstraints.xyw(1, 14, 4, "l, c"));
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)CodeTemplatesPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(CodeTemplatesPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(CodeTemplatesPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)CodeTemplatesPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)CodeTemplatesPanel.loc("CTL_" + string));
        }
    }

    void update() {
        this.model = new CodeTemplatesModel();
        this.cbLanguage.removeActionListener(this);
        this.bNew.removeActionListener(this);
        this.bRemove.removeActionListener(this);
        this.cbExpander.removeActionListener(this);
        this.tTemplates.getSelectionModel().removeListSelectionListener(this);
        this.cbLanguage.removeAllItems();
        ArrayList arrayList = new ArrayList(this.model.getLanguages());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.cbLanguage.addItem(iterator.next());
        }
        KeyStroke keyStroke = this.model.getExpander();
        if (KeyStroke.getKeyStroke(32, 1).equals(keyStroke)) {
            this.cbExpander.setSelectedIndex(1);
        } else if (KeyStroke.getKeyStroke(9, 0).equals(keyStroke)) {
            this.cbExpander.setSelectedIndex(2);
        } else if (KeyStroke.getKeyStroke(10, 0).equals(keyStroke)) {
            this.cbExpander.setSelectedIndex(3);
        } else {
            this.cbExpander.setSelectedIndex(0);
        }
        this.cbLanguage.addActionListener(this);
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.cbExpander.addActionListener(this);
        this.tTemplates.getSelectionModel().addListSelectionListener(this);
        this.cbLanguage.setSelectedItem("Java");
    }

    void applyChanges() {
        if (this.model != null) {
            this.saveCurrentTemplate();
            this.model.saveChanges();
        }
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbLanguage) {
            this.saveCurrentTemplate();
            final String string = (String)this.cbLanguage.getSelectedItem();
            final DefaultTableModel defaultTableModel = this.model.getTableModel(string);
            this.tTemplates.setModel(defaultTableModel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epTemplates.setContentType(CodeTemplatesPanel.this.model.getMimeType(string));
                    if (defaultTableModel.getRowCount() > 0) {
                        CodeTemplatesPanel.this.lastIndex = -1;
                        CodeTemplatesPanel.this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        CodeTemplatesPanel.this.lastIndex = 0;
                    } else {
                        CodeTemplatesPanel.this.lastIndex = -1;
                    }
                }
            });
        } else if (actionEvent.getSource() == this.bNew) {
            this.saveCurrentTemplate();
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(CodeTemplatesPanel.loc("CTL_Enter_template_name"), CodeTemplatesPanel.loc("CTL_New_template_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.InputLine.OK_OPTION) {
                String string = inputLine.getInputText().trim();
                if (string.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Empty_template_name"), 0));
                } else {
                    String string2;
                    int n;
                    TableModel tableModel = this.tTemplates.getModel();
                    int n2 = tableModel.getRowCount();
                    for (n = 0; n < n2; ++n) {
                        string2 = (String)tableModel.getValueAt(n, 0);
                        if (!string.equals(string2)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Duplicate_template_name"), 0));
                        break;
                    }
                    if (n == n2) {
                        string2 = (String)this.cbLanguage.getSelectedItem();
                        this.lastIndex = -1;
                        this.model.addRow(string2, string, "");
                        this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        this.spTable.getVerticalScrollBar().setValue(0);
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epTemplates.requestFocus();
                }
            });
        } else if (actionEvent.getSource() == this.bRemove) {
            String string = (String)this.cbLanguage.getSelectedItem();
            int n = this.tTemplates.getSelectedRow();
            this.model.removeRow(string, n);
            this.lastIndex = -1;
            if (n < this.tTemplates.getModel().getRowCount()) {
                this.tTemplates.getSelectionModel().setSelectionInterval(n, n);
            } else if (this.tTemplates.getModel().getRowCount() > 0) {
                this.tTemplates.getSelectionModel().setSelectionInterval(this.tTemplates.getModel().getRowCount() - 1, this.tTemplates.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.cbExpander) {
            switch (this.cbExpander.getSelectedIndex()) {
                case 0: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 0));
                    break;
                }
                case 1: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 1));
                    break;
                }
                case 2: {
                    this.model.setExpander(KeyStroke.getKeyStroke(9, 0));
                    break;
                }
                case 3: {
                    this.model.setExpander(KeyStroke.getKeyStroke(10, 0));
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tTemplates.getSelectedRow();
        if (n < 0) {
            this.epTemplates.setText("");
            this.bRemove.setEnabled(false);
            this.lastIndex = -1;
            return;
        }
        this.saveCurrentTemplate();
        TableModel tableModel = this.tTemplates.getModel();
        this.bRemove.setEnabled(true);
        String string = (String)tableModel.getValueAt(n, 1);
        this.epTemplates.setText(string);
        this.lastIndex = n;
    }

    void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    void saveCurrentTemplate() {
        TableModel tableModel = this.tTemplates.getModel();
        if (this.lastIndex < 0) {
            return;
        }
        if (this.epTemplates.getText().equals(tableModel.getValueAt(this.lastIndex, 1))) {
            return;
        }
        tableModel.setValueAt(this.epTemplates.getText(), this.lastIndex, 1);
        this.firePropertyChange("changed", null, null);
    }
}

