/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.FontAndColorsPanel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AnnotationsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private ColorModel colorModel;
    private JList lCategories = new JList();
    private ColorComboBox foregroundColorChooser = new ColorComboBox();
    private ColorComboBox backgroundColorChooser = new ColorComboBox();
    private ColorComboBox waveUnderlinedColorChooser = new ColorComboBox();
    private boolean listen = false;
    private String currentScheme;
    private Map schemes = new HashMap();
    private Set toBeSaved = new HashSet();
    private boolean changed = false;

    public AnnotationsPanel(FontAndColorsPanel fontAndColorsPanel) {
        this.foregroundColorChooser.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Foreground_Chooser"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Foreground_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Background_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Background_Chooser"));
        this.waveUnderlinedColorChooser.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Wave_Underlined"));
        this.waveUnderlinedColorChooser.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Wave_Underlined"));
        this.lCategories.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Categories"));
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!AnnotationsPanel.this.listen) {
                    return;
                }
                AnnotationsPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.foregroundColorChooser.addPropertyChangeListener(this);
        this.backgroundColorChooser.addPropertyChangeListener(this);
        this.waveUnderlinedColorChooser.addPropertyChangeListener(this);
        JLabel jLabel = new JLabel();
        AnnotationsPanel.loc(jLabel, "CTL_Category");
        jLabel.setLabelFor(this.lCategories);
        FormLayout formLayout = new FormLayout("p:g, 10dlu, p, 3dlu, p:g", "p, 3dlu, p, 3dlu, p, 3dlu, p, p:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.add((Component)jLabel, cellConstraints2.xy(1, 1));
        panelBuilder.add((Component)new JScrollPane(this.lCategories), cellConstraints.xywh(1, 3, 1, 6));
        panelBuilder.addLabel(AnnotationsPanel.loc("CTL_Foreground_label"), cellConstraints2.xy(3, 3), (Component)this.foregroundColorChooser, cellConstraints.xy(5, 3));
        panelBuilder.addLabel(AnnotationsPanel.loc("CTL_Background_label"), cellConstraints2.xy(3, 5), (Component)this.backgroundColorChooser, cellConstraints.xy(5, 5));
        panelBuilder.addLabel(AnnotationsPanel.loc("CTL_Wave_underlined_label"), cellConstraints2.xy(3, 7), (Component)this.waveUnderlinedColorChooser, cellConstraints.xy(5, 7));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listen) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() != "color") {
            return;
        }
        this.updateData();
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.listen = false;
        this.currentScheme = colorModel.getCurrentProfile();
        this.lCategories.setListData(this.getAnnotations(this.currentScheme));
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    void cancel() {
        this.toBeSaved = new HashSet();
        this.schemes = new HashMap();
        this.changed = false;
    }

    void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator iterator = this.toBeSaved.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.colorModel.setAnnotations(string, this.getAnnotations(string));
        }
        this.toBeSaved = new HashSet();
        this.schemes = new HashMap();
    }

    boolean isChanged() {
        return this.changed;
    }

    public void setCurrentProfile(String string) {
        String string2 = this.currentScheme;
        this.currentScheme = string;
        Vector vector = this.getAnnotations(string);
        if (vector == null) {
            vector = this.getAnnotations(string2);
            this.schemes.put(string, new Vector(vector));
            this.toBeSaved.add(string);
            vector = this.getAnnotations(string);
        }
        this.lCategories.setListData(vector);
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
    }

    void deleteProfile(String string) {
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)AnnotationsPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)AnnotationsPanel.loc(string));
        }
    }

    private void updateData() {
        Vector vector = this.getAnnotations(this.currentScheme);
        SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)vector.get(this.lCategories.getSelectedIndex());
        if (this.backgroundColorChooser.getColor() != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, this.backgroundColorChooser.getColor());
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Background);
        }
        if (this.foregroundColorChooser.getColor() != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, this.foregroundColorChooser.getColor());
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
        }
        if (this.waveUnderlinedColorChooser.getColor() != null) {
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, this.waveUnderlinedColorChooser.getColor());
        } else {
            simpleAttributeSet.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.toBeSaved.add(this.currentScheme);
    }

    private void refreshUI() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            this.foregroundColorChooser.setEnabled(false);
            this.backgroundColorChooser.setEnabled(false);
            this.waveUnderlinedColorChooser.setEnabled(false);
            return;
        }
        this.foregroundColorChooser.setEnabled(true);
        this.backgroundColorChooser.setEnabled(true);
        this.waveUnderlinedColorChooser.setEnabled(true);
        this.listen = false;
        Vector vector = this.getAnnotations(this.currentScheme);
        AttributeSet attributeSet = (AttributeSet)vector.get(n);
        this.foregroundColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.Foreground));
        this.backgroundColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.Background));
        this.waveUnderlinedColorChooser.setColor((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        this.listen = true;
    }

    private Vector getAnnotations(String string) {
        if (!this.schemes.containsKey(string)) {
            Collection collection = this.colorModel.getAnnotations(this.currentScheme);
            if (collection == null) {
                return null;
            }
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            this.schemes.put(string, new Vector(arrayList));
        }
        return (Vector)this.schemes.get(string);
    }
}

