/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;

public class ColorComboBox
extends JComboBox {
    public static final String PROP_COLOR = "color";
    public static final Value CUSTOM_COLOR = new Value(ColorComboBox.loc("Custom"), null);
    private static Map colorMap = new HashMap();
    private static Object[] content;
    private Color lastColor;
    static /* synthetic */ Class class$java$awt$Dialog;

    public ColorComboBox() {
        super(content);
        this.setRenderer(new Renderer());
        this.setEditable(true);
        this.setEditor(new Renderer());
        this.setSelectedItem(new Value(null, null));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorComboBox.this.getSelectedItem() == CUSTOM_COLOR) {
                    Color color = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = ColorComboBox.class$("java.awt.Dialog")) : class$java$awt$Dialog, ColorComboBox.this), ColorComboBox.loc("SelectColor"), ColorComboBox.this.lastColor);
                    if (color != null) {
                        ColorComboBox.this.setColor(color);
                    }
                } else {
                    ColorComboBox.this.lastColor = ((Value)ColorComboBox.this.getSelectedItem()).color;
                }
                ColorComboBox.this.firePropertyChange(ColorComboBox.PROP_COLOR, null, null);
            }
        });
    }

    public void setInheritedColor(Color color) {
        Object[] objectArray = new Object[content.length];
        System.arraycopy(content, 0, objectArray, 0, content.length);
        objectArray[ColorComboBox.content.length - 1] = color != null ? new Value(ColorComboBox.loc("CTL_Inherited_Color"), color) : new Value(ColorComboBox.loc("CTL_None_Color"), null);
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    public void setColor(Color color) {
        if (color == null) {
            this.setSelectedIndex(content.length - 1);
            this.lastColor = ((Value)this.getItemAt((int)(ColorComboBox.content.length - 1))).color;
        } else {
            this.setSelectedItem(new Value(color));
            this.lastColor = color;
        }
    }

    public Color getColor() {
        if (this.getSelectedIndex() == content.length - 1) {
            return null;
        }
        return ((Value)this.getSelectedItem()).color;
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)ColorComboBox.class, (String)string);
    }

    static {
        colorMap.put(Color.BLACK, ColorComboBox.loc("Black"));
        colorMap.put(Color.BLUE, ColorComboBox.loc("Blue"));
        colorMap.put(Color.CYAN, ColorComboBox.loc("Cyan"));
        colorMap.put(Color.DARK_GRAY, ColorComboBox.loc("Dark_Gray"));
        colorMap.put(Color.GRAY, ColorComboBox.loc("Gray"));
        colorMap.put(Color.GREEN, ColorComboBox.loc("Green"));
        colorMap.put(Color.LIGHT_GRAY, ColorComboBox.loc("Light_Gray"));
        colorMap.put(Color.MAGENTA, ColorComboBox.loc("Magenta"));
        colorMap.put(Color.ORANGE, ColorComboBox.loc("Orange"));
        colorMap.put(Color.PINK, ColorComboBox.loc("Pink"));
        colorMap.put(Color.RED, ColorComboBox.loc("Red"));
        colorMap.put(Color.WHITE, ColorComboBox.loc("White"));
        colorMap.put(Color.YELLOW, ColorComboBox.loc("Yellow"));
        content = new Object[]{new Value(Color.BLACK), new Value(Color.BLUE), new Value(Color.CYAN), new Value(Color.DARK_GRAY), new Value(Color.GRAY), new Value(Color.GREEN), new Value(Color.LIGHT_GRAY), new Value(Color.MAGENTA), new Value(Color.ORANGE), new Value(Color.PINK), new Value(Color.RED), new Value(Color.WHITE), new Value(Color.YELLOW), CUSTOM_COLOR, new Value(ColorComboBox.loc("CTL_None_Color"), null)};
    }

    private class Renderer
    extends JComponent
    implements ListCellRenderer,
    ComboBoxEditor {
        private int SIZE = 9;
        private Value value;

        Renderer() {
            this.setPreferredSize(new Dimension(50, this.getFontMetrics(ColorComboBox.this.getFont()).getHeight() + 2));
            this.setOpaque(true);
            this.setFocusable(true);
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            Dimension dimension = this.getSize();
            if (this.isFocusOwner()) {
                graphics.setColor(SystemColor.textHighlight);
            } else {
                graphics.setColor(this.getBackground());
            }
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            int n = (dimension.height - this.SIZE) / 2;
            if (this.value.color != null) {
                graphics.setColor(Color.black);
                graphics.drawRect(n, n, this.SIZE, this.SIZE);
                graphics.setColor(this.value.color);
                graphics.fillRect(n + 1, n + 1, this.SIZE - 1, this.SIZE - 1);
            }
            if (this.value.text != null) {
                if (this.isFocusOwner()) {
                    graphics.setColor(SystemColor.textHighlightText);
                } else {
                    graphics.setColor(this.getForeground());
                }
                if (this.value.color != null) {
                    graphics.drawString(this.value.text, n + this.SIZE + 5, n + this.SIZE);
                } else {
                    graphics.drawString(this.value.text, 5, n + this.SIZE);
                }
            }
            graphics.setColor(color);
        }

        public void setEnabled(boolean bl) {
            this.setBackground(bl ? SystemColor.text : SystemColor.control);
            super.setEnabled(bl);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.value = (Value)object;
            this.setEnabled(jList.isEnabled());
            this.setBackground(bl ? SystemColor.textHighlight : SystemColor.text);
            this.setForeground(bl ? SystemColor.textHighlightText : SystemColor.textText);
            return this;
        }

        public Component getEditorComponent() {
            this.setEnabled(ColorComboBox.this.isEnabled());
            this.setBackground(ColorComboBox.this.isFocusOwner() ? SystemColor.textHighlight : SystemColor.text);
            this.setForeground(ColorComboBox.this.isFocusOwner() ? SystemColor.textHighlightText : SystemColor.textText);
            return this;
        }

        public void setItem(Object object) {
            this.value = (Value)object;
        }

        public Object getItem() {
            return this.value;
        }

        public void selectAll() {
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }
    }

    public static class Value {
        String text;
        Color color;

        Value(Color color) {
            this.color = color;
            this.text = (String)colorMap.get(color);
            if (this.text != null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[').append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(']');
            this.text = stringBuffer.toString();
        }

        Value(String string, Color color) {
            this.text = string;
            this.color = color;
        }
    }
}

