/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class ColorModel {
    static final String ALL_LANGUAGES = NbBundle.getMessage((Class)ColorModel.class, (String)"CTL_All_Languages");
    static final String HIGHLIGHTING_LANGUAGE = "Highlighting";
    private EditorSettings editorSettings = EditorSettings.getDefault();
    private Map languageToMimeType;
    private Set hiddenCategories = new HashSet();

    public Set getProfiles() {
        return this.editorSettings.getFontColorProfiles();
    }

    public String getCurrentProfile() {
        return this.editorSettings.getCurrentFontColorProfile();
    }

    public boolean isCustomProfile(String string) {
        return this.editorSettings.isCustomFontColorProfile(string);
    }

    public void setCurrentProfile(String string) {
        this.editorSettings.setCurrentFontColorProfile(string);
    }

    public Collection getAnnotations(String string) {
        Iterator iterator = AnnotationTypes.getTypes().getAnnotationTypeNames();
        ArrayList<SimpleAttributeSet> arrayList = new ArrayList<SimpleAttributeSet>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            AnnotationType annotationType = AnnotationTypes.getTypes().getType(string2);
            if (!annotationType.isVisible()) continue;
            URL uRL = annotationType.getGlyph();
            Image image = null;
            image = uRL.getProtocol().equals("nbresloc") ? org.openide.util.Utilities.loadImage((String)uRL.getPath().substring(1)) : Toolkit.getDefaultToolkit().getImage(uRL);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            String string3 = annotationType.getDescription();
            if (string3 == null) continue;
            simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string3);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, annotationType.getDescription());
            if (image != null) {
                simpleAttributeSet.addAttribute("icon", new ImageIcon(image));
            }
            if (annotationType.isUseHighlightColor()) {
                simpleAttributeSet.addAttribute(StyleConstants.Background, annotationType.getHighlight());
            }
            if (!annotationType.isInheritForegroundColor()) {
                simpleAttributeSet.addAttribute(StyleConstants.Foreground, annotationType.getForegroundColor());
            }
            if (annotationType.isUseWaveUnderlineColor()) {
                simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, annotationType.getWaveUnderlineColor());
            }
            simpleAttributeSet.addAttribute("annotationType", annotationType);
            arrayList.add(simpleAttributeSet);
        }
        return arrayList;
    }

    public void setAnnotations(String string, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            AnnotationType annotationType = (AnnotationType)attributeSet.getAttribute("annotationType");
            if (attributeSet.isDefined(StyleConstants.Background)) {
                annotationType.setUseHighlightColor(true);
                annotationType.setHighlight((Color)attributeSet.getAttribute(StyleConstants.Background));
            } else {
                annotationType.setUseHighlightColor(false);
            }
            if (attributeSet.isDefined(StyleConstants.Foreground)) {
                annotationType.setInheritForegroundColor(false);
                annotationType.setForegroundColor((Color)attributeSet.getAttribute(StyleConstants.Foreground));
            } else {
                annotationType.setInheritForegroundColor(true);
            }
            if (attributeSet.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                annotationType.setUseWaveUnderlineColor(true);
                annotationType.setWaveUnderlineColor((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor));
                continue;
            }
            annotationType.setUseWaveUnderlineColor(false);
        }
    }

    public Collection getHighlightings(String string) {
        Collection collection = this.editorSettings.getHighlightings(string).values();
        if (collection == null) {
            return null;
        }
        return this.hideDummyCategories(collection);
    }

    public Collection getHighlightingDefaults(String string) {
        Collection collection = this.editorSettings.getHighlightingDefaults(string).values();
        if (collection == null) {
            return null;
        }
        return this.hideDummyCategories(collection);
    }

    public void setHighlightings(String string, Collection collection) {
        this.editorSettings.setHighlightings(string, ColorModel.toMap(collection));
    }

    public Set getLanguages() {
        return this.getLanguageToMimeTypeMap().keySet();
    }

    public Collection getCategories(String string, String string2) {
        if (string2.equals(ALL_LANGUAGES)) {
            return this.editorSettings.getDefaultFontColors(string);
        }
        String string3 = this.getMimeType(string2);
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(new String[]{string3});
        return fontColorSettingsFactory.getAllFontColors(string);
    }

    public Collection getDefaults(String string, String string2) {
        if (string2.equals(ALL_LANGUAGES)) {
            return this.editorSettings.getDefaultFontColorDefaults(string);
        }
        String string3 = this.getMimeType(string2);
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(new String[]{string3});
        return fontColorSettingsFactory.getAllFontColorDefaults(string);
    }

    public void setCategories(String string, String string2, Collection collection) {
        if (string2.equals(ALL_LANGUAGES)) {
            this.editorSettings.setDefaultFontColors(string, collection);
            return;
        }
        String string3 = this.getMimeType(string2);
        if (string3 == null) {
            if (System.getProperty("org.netbeans.optionsDialog") != null) {
                System.out.println("ColorModelImpl.setCategories - unknown language " + string2);
            }
            return;
        }
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(new String[]{string3});
        fontColorSettingsFactory.setAllFontColors(string, collection);
    }

    public Component getEditorPreviewComponent() {
        return new Preview(HIGHLIGHTING_LANGUAGE);
    }

    public Component getSyntaxColoringPreviewComponent(String string) {
        return new Preview(string);
    }

    private String getMimeType(String string) {
        return (String)this.getLanguageToMimeTypeMap().get(string);
    }

    private Map getLanguageToMimeTypeMap() {
        if (this.languageToMimeType == null) {
            this.languageToMimeType = new HashMap();
            Set set = this.editorSettings.getMimeTypes();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.languageToMimeType.put(this.editorSettings.getLanguageName(string), string);
            }
            this.languageToMimeType.put(ALL_LANGUAGES, "Defaults");
        }
        return this.languageToMimeType;
    }

    private Collection hideDummyCategories(Collection collection) {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            if (this.hiddenCategories.contains(attributeSet.getAttribute(StyleConstants.NameAttribute))) continue;
            arrayList.add(attributeSet);
        }
        return arrayList;
    }

    private static Map toMap(Collection collection) {
        if (collection == null) {
            return null;
        }
        HashMap<Object, AttributeSet> hashMap = new HashMap<Object, AttributeSet>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            hashMap.put(attributeSet.getAttribute(StyleConstants.NameAttribute), attributeSet);
        }
        return hashMap;
    }

    static /* synthetic */ EditorSettings access$600(ColorModel colorModel) {
        return colorModel.editorSettings;
    }

    static /* synthetic */ Map access$700(Collection collection) {
        return ColorModel.toMap(collection);
    }

    class Preview
    extends JPanel {
        static final String PROP_CURRENT_ELEMENT = "currentAElement";
        private JEditorPane editorPane;
        private FontColorSettingsFactory fontColorSettings;
        private String currentLanguage;

        Preview(String string) {
            super(new BorderLayout());
            SwingUtilities.invokeLater(new Runnable(this, string){
                private final /* synthetic */ String val$language;
                private final /* synthetic */ Preview this$1;
                {
                    this.this$1 = preview;
                    this.val$language = string;
                }

                public void run() {
                    EditorUI editorUI;
                    Preview.access$002(this.this$1, new JEditorPane());
                    Preview.access$100(this.this$1, this.val$language);
                    if (this.val$language == "Highlighting" && (editorUI = Utilities.getEditorUI((JTextComponent)Preview.access$000(this.this$1))) != null) {
                        editorUI.setLineNumberEnabled(true);
                        editorUI.getExtComponent();
                        this.this$1.add((Component)editorUI.getExtComponent(), "Center");
                        return;
                    }
                    this.this$1.add((Component)Preview.access$000(this.this$1), "Center");
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void setParameters(String string, Collection collection, Collection collection2, Collection collection3) {
            SwingUtilities.invokeLater(new Runnable(this, string, collection, collection2, collection3){
                private final /* synthetic */ String val$language;
                private final /* synthetic */ Collection val$defaults;
                private final /* synthetic */ Collection val$highlightings;
                private final /* synthetic */ Collection val$syntaxColorings;
                private final /* synthetic */ Preview this$1;
                {
                    this.this$1 = preview;
                    this.val$language = string;
                    this.val$defaults = collection;
                    this.val$highlightings = collection2;
                    this.val$syntaxColorings = collection3;
                }

                public void run() {
                    String string = null;
                    if (!this.val$language.equals(Preview.access$200(this.this$1))) {
                        Preview.access$100(this.this$1, this.val$language);
                        Preview.access$202(this.this$1, this.val$language);
                        string = Preview.access$300(this.this$1, this.val$language);
                        Preview.access$402(this.this$1, EditorSettings.getDefault().getFontColorSettings(new String[]{string}));
                    }
                    if (string == null) {
                        string = Preview.access$300(this.this$1, this.val$language);
                    }
                    if (this.val$defaults != null) {
                        ColorModel.access$600(Preview.access$500(this.this$1)).setDefaultFontColors("test" + Preview.access$500(this.this$1).hashCode(), this.val$defaults);
                    }
                    if (this.val$highlightings != null) {
                        ColorModel.access$600(Preview.access$500(this.this$1)).setHighlightings("test" + Preview.access$500(this.this$1).hashCode(), ColorModel.access$700(this.val$highlightings));
                    }
                    if (this.val$syntaxColorings != null) {
                        Preview.access$400(this.this$1).setAllFontColors("test" + Preview.access$500(this.this$1).hashCode(), this.val$syntaxColorings);
                    }
                }
            });
        }

        private void updateMimeType(String string) {
            String string2 = this.languageToInternalMimeType(string);
            Document document = this.editorPane.getDocument();
            document.putProperty("mimeType", string2);
            this.editorPane.setContentType(string2);
            document = this.editorPane.getDocument();
            document.putProperty("mimeType", string2);
            this.editorPane.addCaretListener(new CaretListener(this){
                private final /* synthetic */ Preview this$1;
                {
                    this.this$1 = preview;
                }

                public void caretUpdate(CaretEvent caretEvent) {
                    int n = caretEvent.getDot();
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)Preview.access$000(this.this$1));
                    if (editorUI == null) {
                        return;
                    }
                    SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)editorUI.getComponent());
                    if (!(syntaxSupport instanceof ExtSyntaxSupport)) {
                        return;
                    }
                    try {
                        TokenItem tokenItem = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(n, n + 1);
                        if (tokenItem == null) {
                            return;
                        }
                        String string = tokenItem.getTokenContextPath().getNamePrefix();
                        string = tokenItem.getTokenID().getCategory() != null ? string + tokenItem.getTokenID().getCategory().getName() : string + tokenItem.getTokenID().getName();
                        Preview.access$800(this.this$1, "currentAElement", null, string);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
            this.editorPane.setEnabled(false);
            InputStream inputStream = this.loadPreviewExample(string);
            if (inputStream == null) {
                inputStream = this.loadPreviewExample("Java");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    stringBuffer.append(string3).append('\n');
                    string3 = bufferedReader.readLine();
                }
                this.editorPane.setText(new String(stringBuffer));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private InputStream loadPreviewExample(String string) {
            String string2 = ColorModel.this.getMimeType(string);
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("OptionsDialog/PreviewExamples/" + string2);
            try {
                return fileObject != null ? fileObject.getInputStream() : null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        private String languageToInternalMimeType(String string) {
            String string2 = string == ColorModel.HIGHLIGHTING_LANGUAGE || string == ALL_LANGUAGES ? "text/x-java" : ColorModel.this.getMimeType(string);
            return "test" + ColorModel.this.hashCode() + "_" + string2;
        }

        static /* synthetic */ JEditorPane access$002(Preview preview, JEditorPane jEditorPane) {
            preview.editorPane = jEditorPane;
            return preview.editorPane;
        }

        static /* synthetic */ void access$100(Preview preview, String string) {
            preview.updateMimeType(string);
        }

        static /* synthetic */ JEditorPane access$000(Preview preview) {
            return preview.editorPane;
        }

        static /* synthetic */ String access$200(Preview preview) {
            return preview.currentLanguage;
        }

        static /* synthetic */ String access$202(Preview preview, String string) {
            preview.currentLanguage = string;
            return preview.currentLanguage;
        }

        static /* synthetic */ String access$300(Preview preview, String string) {
            return preview.languageToInternalMimeType(string);
        }

        static /* synthetic */ FontColorSettingsFactory access$402(Preview preview, FontColorSettingsFactory fontColorSettingsFactory) {
            preview.fontColorSettings = fontColorSettingsFactory;
            return preview.fontColorSettings;
        }

        static /* synthetic */ ColorModel access$500(Preview preview) {
            return preview.ColorModel.this;
        }

        static /* synthetic */ FontColorSettingsFactory access$400(Preview preview) {
            return preview.fontColorSettings;
        }

        static /* synthetic */ void access$800(Preview preview, String string, Object object, Object object2) {
            preview.firePropertyChange(string, object, object2);
        }
    }
}

