/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.FontAndColorsPanel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HighlightingPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JList lCategories = new JList();
    private ColorComboBox foregroundColorChooser = new ColorComboBox();
    private ColorComboBox backgroundColorChooser = new ColorComboBox();
    private ColorModel colorModel = null;
    private boolean listen = false;
    private String currentProfile;
    private Map profileToCategories = new HashMap();
    private Set toBeSaved = new HashSet();
    private boolean changed = false;
    private Map profileToDefaults = new HashMap();

    public HighlightingPanel(FontAndColorsPanel fontAndColorsPanel) {
        this.lCategories.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Categories"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Foreground_Chooser"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Foreground_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Background_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Background_Chooser"));
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!HighlightingPanel.this.listen) {
                    return;
                }
                HighlightingPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.foregroundColorChooser.addPropertyChangeListener(this);
        this.backgroundColorChooser.addPropertyChangeListener(this);
        JLabel jLabel = new JLabel();
        HighlightingPanel.loc(jLabel, "CTL_Category");
        jLabel.setLabelFor(this.lCategories);
        FormLayout formLayout = new FormLayout("p:g, 10dlu, p, 3dlu, p:g, 1dlu, p", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, p:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.add((Component)jLabel, cellConstraints2.xy(1, 1));
        panelBuilder.add((Component)new JScrollPane(this.lCategories), cellConstraints.xywh(1, 3, 1, 8));
        panelBuilder.addLabel(HighlightingPanel.loc("CTL_Foreground_label"), cellConstraints2.xy(3, 3), (Component)this.foregroundColorChooser, cellConstraints.xyw(5, 3, 3));
        panelBuilder.addLabel(HighlightingPanel.loc("CTL_Background_label"), cellConstraints2.xy(3, 5), (Component)this.backgroundColorChooser, cellConstraints.xyw(5, 5, 3));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listen) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() != "color") {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.listen = false;
        this.setCurrentProfile(this.currentProfile);
        this.lCategories.setListData(this.getCategories(this.currentProfile));
        this.lCategories.setSelectedIndex(0);
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    void cancel() {
        this.toBeSaved = new HashSet();
        this.profileToCategories = new HashMap();
        this.changed = false;
    }

    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator iterator = this.toBeSaved.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.colorModel.setHighlightings(string, this.getCategories(string));
        }
        this.toBeSaved = new HashSet();
        this.profileToCategories = new HashMap();
    }

    boolean isChanged() {
        return this.changed;
    }

    void setCurrentProfile(String string) {
        String string2 = this.currentProfile;
        this.currentProfile = string;
        if (!this.colorModel.getProfiles().contains(string)) {
            Vector vector = this.getCategories(string2);
            this.profileToCategories.put(string, new Vector(vector));
            this.toBeSaved.add(string);
        }
        this.refreshUI();
    }

    void deleteProfile(String string) {
        if (this.colorModel.isCustomProfile(string)) {
            this.profileToCategories.put(string, null);
        } else {
            this.profileToCategories.put(string, this.getDefaults(string));
            this.refreshUI();
        }
        this.toBeSaved.add(string);
    }

    Collection getHighlightings() {
        return this.getCategories(this.currentProfile);
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)HighlightingPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)HighlightingPanel.loc(string));
        }
    }

    private void updateData() {
        if (this.lCategories.getSelectedIndex() < 0) {
            return;
        }
        Vector vector = this.getCategories(this.currentProfile);
        AttributeSet attributeSet = (AttributeSet)vector.get(this.lCategories.getSelectedIndex());
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        if (this.backgroundColorChooser.getColor() != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, this.backgroundColorChooser.getColor());
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Background);
        }
        if (this.foregroundColorChooser.getColor() != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, this.foregroundColorChooser.getColor());
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
        }
        if (var3_3 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Underline, var3_3);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Underline);
        }
        if (var5_5 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, var5_5);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.StrikeThrough);
        }
        if (var4_4 != null) {
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, var4_4);
        } else {
            simpleAttributeSet.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        int n = this.lCategories.getSelectedIndex();
        vector.set(n, simpleAttributeSet);
        this.toBeSaved.add(this.currentProfile);
    }

    private void refreshUI() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            this.foregroundColorChooser.setEnabled(false);
            this.backgroundColorChooser.setEnabled(false);
            return;
        }
        this.foregroundColorChooser.setEnabled(true);
        this.backgroundColorChooser.setEnabled(true);
        Vector vector = this.getCategories(this.currentProfile);
        AttributeSet attributeSet = (AttributeSet)vector.get(n);
        this.listen = false;
        this.foregroundColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.Foreground));
        this.backgroundColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.Background));
        this.listen = true;
    }

    private Vector getCategories(String string) {
        if (this.colorModel == null) {
            return null;
        }
        if (!this.profileToCategories.containsKey(string)) {
            Collection collection = this.colorModel.getHighlightings(string);
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            this.profileToCategories.put(string, new Vector(arrayList));
        }
        return (Vector)this.profileToCategories.get(string);
    }

    private Vector getDefaults(String string) {
        if (!this.profileToDefaults.containsKey(string)) {
            Collection collection = this.colorModel.getHighlightingDefaults(string);
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            this.profileToDefaults.put(string, new Vector(arrayList));
        }
        return (Vector)this.profileToDefaults.get(string);
    }
}

